/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;

public class PhysicalVolume
extends TResPhysicalVolumeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;
    private String m_SystemCreationClassNameId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static PhysicalVolumeCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new PhysicalVolumeCursor(con, htWhereClause, columns);
    }

    public PhysicalVolume() {
        this.clear();
    }

    public PhysicalVolume(int PhysicalVolumeId, short VendorId, short ModelId, String SerialNumber, String FirmwareRev, Timestamp ManufactureDate, short UseCount, short DeviceType, String UnsupportedModel, short Flags, String RemovableMedium, String MultiPort, Timestamp DiscoveredTime, short StorageSystemType, int DiskGroupId, Timestamp UpdateTimestamp, short SystemCreationClassNameId, short CreationClassNameId, short SystemNamesId, int SubsystemId, String DeviceId, String Name2, String Tag2, String DisplayName, long Capacity, String SubsystemSerialNumber, short Detectable, int OperationalStatus, short ConsolidatedStatus) {
        this.clear();
        this.m_PhysicalVolumeId = PhysicalVolumeId;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_SerialNumber = SerialNumber;
        this.m_FirmwareRev = FirmwareRev;
        this.m_ManufactureDate = ManufactureDate;
        this.m_UseCount = UseCount;
        this.m_DeviceType = DeviceType;
        this.m_UnsupportedModel = UnsupportedModel;
        this.m_Flags = Flags;
        this.m_RemovableMedium = RemovableMedium;
        this.m_MultiPort = MultiPort;
        this.m_DiscoveredTime = DiscoveredTime;
        this.m_StorageSystemType = StorageSystemType;
        this.m_DiskGroupId = DiskGroupId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_SubsystemId = SubsystemId;
        this.m_DeviceId = DeviceId;
        this.m_Name = Name2;
        this.m_Tag = Tag2;
        this.m_DisplayName = DisplayName;
        this.m_Capacity = Capacity;
        this.m_SubsystemSerialNumber = SubsystemSerialNumber;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PhysicalVolumeId != Integer.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), String.valueOf(this.m_PhysicalVolumeId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_FirmwareRev != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("FIRMWARE_REV"), this.m_FirmwareRev);
        }
        if (this.m_ManufactureDate != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("MANUFACTURE_DATE"), this.m_ManufactureDate);
        }
        if (this.m_UseCount != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("USE_COUNT"), String.valueOf(this.m_UseCount));
        }
        if (this.m_DeviceType != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("DEVICE_TYPE"), String.valueOf(this.m_DeviceType));
        }
        if (this.m_UnsupportedModel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("UNSUPPORTED_MODEL"), this.m_UnsupportedModel);
        }
        if (this.m_Flags != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("FLAGS"), String.valueOf(this.m_Flags));
        }
        if (this.m_RemovableMedium != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("REMOVABLE_MEDIUM"), this.m_RemovableMedium);
        }
        if (this.m_MultiPort != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("MULTI_PORT"), this.m_MultiPort);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_StorageSystemType != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("STORAGE_SYSTEM_TYPE"), String.valueOf(this.m_StorageSystemType));
        }
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_Tag != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("TAG"), this.m_Tag);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_Capacity != Long.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_SubsystemSerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("SUBSYSTEM_SERIAL_NUMBER"), this.m_SubsystemSerialNumber);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalVolume.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htColsAndValues.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_VOLUME", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_VOLUME", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_VOLUME", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhysicalVolume retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        PhysicalVolume el = null;
        if (htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), htinput.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_VOLUME", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new PhysicalVolume();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPhysicalVolumeId(DBrs.getInt("PHYSICAL_VOLUME_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setFirmwareRev(DBrs.getString("FIRMWARE_REV"));
        this.setManufactureDate(DBrs.getTimestamp("MANUFACTURE_DATE"));
        this.setUseCount(DBrs.getShort("USE_COUNT"));
        this.setDeviceType(DBrs.getShort("DEVICE_TYPE"));
        this.setUnsupportedModel(DBrs.getString("UNSUPPORTED_MODEL"));
        this.setFlags(DBrs.getShort("FLAGS"));
        this.setRemovableMedium(DBrs.getString("REMOVABLE_MEDIUM"));
        this.setMultiPort(DBrs.getString("MULTI_PORT"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
        this.setStorageSystemType(DBrs.getShort("STORAGE_SYSTEM_TYPE"));
        this.setDiskGroupId(DBrs.getInt("DISK_GROUP_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setTag(DBrs.getString("TAG"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setCapacity(DBrs.getLong("CAPACITY"));
        this.setSubsystemSerialNumber(DBrs.getString("SUBSYSTEM_SERIAL_NUMBER"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
    }

    public static class PhysicalVolumeCursor
    extends DBCursor {
        private PhysicalVolume element = new PhysicalVolume();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResPhysicalVolumeTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResPhysicalVolumeTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("MODEL_ID")))));
            }
            if (htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResPhysicalVolumeTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResPhysicalVolumeTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return htWhereClause;
        }

        public PhysicalVolumeCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_PHYSICAL_VOLUME", con, PhysicalVolumeCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public PhysicalVolume getObject() throws SQLException {
            PhysicalVolume el = null;
            if (this.DBrs != null) {
                el = new PhysicalVolume();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public PhysicalVolume getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

