/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancyTable;

public class Redundancy
extends TResRedundancyTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static RedundancyCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new RedundancyCursor(con, htWhereClause, columns);
    }

    public Redundancy() {
        this.clear();
    }

    public Redundancy(int RedundancyId, int SubsystemId, String ComponentId, String IpAddress, int NodeId, Timestamp UpdateTimestamp, short CreationClassNameId, String Name2, short NameFormat, int OperationalStatus, String Wwn, String DisplayName, int IoGroupId) {
        this.clear();
        this.m_RedundancyId = RedundancyId;
        this.m_SubsystemId = SubsystemId;
        this.m_ComponentId = ComponentId;
        this.m_IpAddress = IpAddress;
        this.m_NodeId = NodeId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_OperationalStatus = OperationalStatus;
        this.m_Wwn = Wwn;
        this.m_DisplayName = DisplayName;
        this.m_IoGroupId = IoGroupId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_Wwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("WWN"), this.m_Wwn);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_IoGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(Redundancy.getColumnInfo("IO_GROUP_ID"), String.valueOf(this.m_IoGroupId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htColsAndValues.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Redundancy retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Redundancy el = null;
        if (htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), htinput.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), htinput.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Redundancy();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setRedundancyId(DBrs.getInt("REDUNDANCY_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setComponentId(DBrs.getString("COMPONENT_ID"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setNodeId(DBrs.getInt("NODE_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setWwn(DBrs.getString("WWN"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setIoGroupId(DBrs.getInt("IO_GROUP_ID"));
    }

    public static class RedundancyCursor
    extends DBCursor {
        private Redundancy element = new Redundancy();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResRedundancyTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResRedundancyTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResRedundancyTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public RedundancyCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_REDUNDANCY", con, RedundancyCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Redundancy getObject() throws SQLException {
            Redundancy el = null;
            if (this.DBrs != null) {
                el = new Redundancy();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Redundancy getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

