/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;

public class SnapshotMetadata
extends TResSnapshotMetadataTable {
    public static SnapshotMetadataCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SnapshotMetadataCursor(con, htWhereClause, columns);
    }

    public SnapshotMetadata() {
        this.clear();
    }

    public SnapshotMetadata(int SnapshotId, Timestamp SnapshotTime, int SystemId, short SystemType, short SnapshotConsistent, short SnapshotType) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_SnapshotTime = SnapshotTime;
        this.m_SystemId = SystemId;
        this.m_SystemType = SystemType;
        this.m_SnapshotConsistent = SnapshotConsistent;
        this.m_SnapshotType = SnapshotType;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SnapshotTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_TIME"), this.m_SnapshotTime);
        }
        if (this.m_SystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(SnapshotMetadata.getColumnInfo("SYSTEM_ID"), String.valueOf(this.m_SystemId));
        }
        if (this.m_SystemType != Short.MIN_VALUE) {
            htColsAndValues.put(SnapshotMetadata.getColumnInfo("SYSTEM_TYPE"), String.valueOf(this.m_SystemType));
        }
        if (this.m_SnapshotConsistent != Short.MIN_VALUE) {
            htColsAndValues.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_CONSISTENT"), String.valueOf(this.m_SnapshotConsistent));
        }
        if (this.m_SnapshotType != Short.MIN_VALUE) {
            htColsAndValues.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_TYPE"), String.valueOf(this.m_SnapshotType));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SNAPSHOT_METADATA", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SNAPSHOT_METADATA", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SNAPSHOT_METADATA", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotMetadata retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SnapshotMetadata el = null;
        if (htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID"), htinput.get(SnapshotMetadata.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SNAPSHOT_METADATA", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SnapshotMetadata();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SNAPSHOT_METADATA", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SNAPSHOT_METADATA", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setSnapshotTime(DBrs.getTimestamp("SNAPSHOT_TIME"));
        this.setSystemId(DBrs.getInt("SYSTEM_ID"));
        this.setSystemType(DBrs.getShort("SYSTEM_TYPE"));
        this.setSnapshotConsistent(DBrs.getShort("SNAPSHOT_CONSISTENT"));
        this.setSnapshotType(DBrs.getShort("SNAPSHOT_TYPE"));
    }

    public static class SnapshotMetadataCursor
    extends DBCursor {
        private SnapshotMetadata element = new SnapshotMetadata();
        private DBConnection con;

        public SnapshotMetadataCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SNAPSHOT_METADATA", con, htWhereClause, columns);
            this.con = con;
        }

        public SnapshotMetadata getObject() throws SQLException {
            SnapshotMetadata el = null;
            if (this.DBrs != null) {
                el = new SnapshotMetadata();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SnapshotMetadata getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

