/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatSpaceHistTable;

public class SpaceHist
extends TStatSpaceHistTable {
    public static SpaceHistCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SpaceHistCursor(con, htWhereClause, columns);
    }

    public SpaceHist() {
        this.clear();
    }

    public SpaceHist(int FilesystemId, int StatisticId, String StatisticType, Timestamp StatisticTime, short AccumCount, double FileCount, double TotalSize) {
        this.clear();
        this.m_FilesystemId = FilesystemId;
        this.m_StatisticId = StatisticId;
        this.m_StatisticType = StatisticType;
        this.m_StatisticTime = StatisticTime;
        this.m_AccumCount = AccumCount;
        this.m_FileCount = FileCount;
        this.m_TotalSize = TotalSize;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_StatisticId != Integer.MIN_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("STATISTIC_ID"), String.valueOf(this.m_StatisticId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_AccumCount != Short.MIN_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("ACCUM_COUNT"), String.valueOf(this.m_AccumCount));
        }
        if (this.m_FileCount != Double.MIN_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("FILE_COUNT"), String.valueOf(this.m_FileCount));
        }
        if (this.m_TotalSize != Double.MIN_VALUE) {
            htColsAndValues.put(SpaceHist.getColumnInfo("TOTAL_SIZE"), String.valueOf(this.m_TotalSize));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_SPACE_HIST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_SPACE_HIST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_SPACE_HIST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpaceHist retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SpaceHist el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_SPACE_HIST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SpaceHist();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setFilesystemId(DBrs.getInt("FILESYSTEM_ID"));
        this.setStatisticId(DBrs.getInt("STATISTIC_ID"));
        this.setStatisticType(DBrs.getString("STATISTIC_TYPE"));
        this.setStatisticTime(DBrs.getTimestamp("STATISTIC_TIME"));
        this.setAccumCount(DBrs.getShort("ACCUM_COUNT"));
        this.setFileCount(DBrs.getDouble("FILE_COUNT"));
        this.setTotalSize(DBrs.getDouble("TOTAL_SIZE"));
    }

    public static class SpaceHistCursor
    extends DBCursor {
        private SpaceHist element = new SpaceHist();
        private DBConnection con;

        public SpaceHistCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_SPACE_HIST", con, htWhereClause, columns);
            this.con = con;
        }

        public SpaceHist getObject() throws SQLException {
            SpaceHist el = null;
            if (this.DBrs != null) {
                el = new SpaceHist();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SpaceHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

