/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchSnapshotTable;

public class SwitchSnapshot
extends TResSwitchSnapshotTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static SwitchSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SwitchSnapshotCursor(con, htWhereClause, columns);
    }

    public SwitchSnapshot() {
        this.clear();
    }

    public SwitchSnapshot(int SnapshotId, String SwitchWwn, int SwitchId, short VendorId, short ModelId, String ParentSwitchWwn, String SerialNumber, String Description, String Contact, String Location2, String IpAddress, String DisplayName, String LogicalName, String Domain2, String ManagementId, String MgmtTelAddr, String MgmtSnmpAddr, String MgmtUrlAddr, String Version2, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp ChangedTimestamp, Timestamp UpdateTimestamp, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_SwitchWwn = SwitchWwn;
        this.m_SwitchId = SwitchId;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_ParentSwitchWwn = ParentSwitchWwn;
        this.m_SerialNumber = SerialNumber;
        this.m_Description = Description;
        this.m_Contact = Contact;
        this.m_Location = Location2;
        this.m_IpAddress = IpAddress;
        this.m_DisplayName = DisplayName;
        this.m_LogicalName = LogicalName;
        this.m_Domain = Domain2;
        this.m_ManagementId = ManagementId;
        this.m_MgmtTelAddr = MgmtTelAddr;
        this.m_MgmtSnmpAddr = MgmtSnmpAddr;
        this.m_MgmtUrlAddr = MgmtUrlAddr;
        this.m_Version = Version2;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SwitchId != Integer.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("SWITCH_ID"), String.valueOf(this.m_SwitchId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ParentSwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("PARENT_SWITCH_WWN"), this.m_ParentSwitchWwn);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_Contact != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("CONTACT"), this.m_Contact);
        }
        if (this.m_Location != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("LOCATION"), this.m_Location);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_LogicalName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("LOGICAL_NAME"), this.m_LogicalName);
        }
        if (this.m_Domain != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("DOMAIN"), this.m_Domain);
        }
        if (this.m_ManagementId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("MANAGEMENT_ID"), this.m_ManagementId);
        }
        if (this.m_MgmtTelAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("MGMT_TEL_ADDR"), this.m_MgmtTelAddr);
        }
        if (this.m_MgmtSnmpAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("MGMT_SNMP_ADDR"), this.m_MgmtSnmpAddr);
        }
        if (this.m_MgmtUrlAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("MGMT_URL_ADDR"), this.m_MgmtUrlAddr);
        }
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchSnapshot.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwitchSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SwitchSnapshot el = null;
        if (htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        htWhereClause.put(SwitchSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchSnapshot.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SwitchSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SwitchSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(SwitchSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(SwitchSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(SwitchSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(SwitchSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(SwitchSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setSwitchId(DBrs.getInt("SWITCH_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setParentSwitchWwn(DBrs.getString("PARENT_SWITCH_WWN"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
        this.setContact(DBrs.getString("CONTACT"));
        this.setLocation(DBrs.getString("LOCATION"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setLogicalName(DBrs.getString("LOGICAL_NAME"));
        this.setDomain(DBrs.getString("DOMAIN"));
        this.setManagementId(DBrs.getString("MANAGEMENT_ID"));
        this.setMgmtTelAddr(DBrs.getString("MGMT_TEL_ADDR"));
        this.setMgmtSnmpAddr(DBrs.getString("MGMT_SNMP_ADDR"));
        this.setMgmtUrlAddr(DBrs.getString("MGMT_URL_ADDR"));
        this.setVersion(DBrs.getString("VERSION"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class SwitchSnapshotCursor
    extends DBCursor {
        private SwitchSnapshot element = new SwitchSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResSwitchSnapshotTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResSwitchSnapshotTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResSwitchSnapshotTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResSwitchSnapshotTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResSwitchSnapshotTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResSwitchSnapshotTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public SwitchSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SWITCH_SNAPSHOT", con, SwitchSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public SwitchSnapshot getObject() throws SQLException {
            SwitchSnapshot el = null;
            if (this.DBrs != null) {
                el = new SwitchSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SwitchSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

