/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSystemNamesSnapshotTable;

public class SystemNamesSnapshot
extends TResSystemNamesSnapshotTable {
    private String m_SystemNamesId_str;

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static SystemNamesSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SystemNamesSnapshotCursor(con, htWhereClause, columns);
    }

    public SystemNamesSnapshot() {
        this.clear();
    }

    public SystemNamesSnapshot(int SnapshotId, short SystemNamesId, String SystemName) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_SystemName = SystemName;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            htColsAndValues.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htColsAndValues.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SYSTEM_NAMES_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SYSTEM_NAMES_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_SystemName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAME not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), this.m_SystemName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SYSTEM_NAMES_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemNamesSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SystemNamesSnapshot el = null;
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAME not found");
        }
        htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME"), htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAME")));
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(SystemNamesSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SYSTEM_NAMES_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SystemNamesSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SYSTEM_NAMES_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(SystemNamesSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SYSTEM_NAMES_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setSystemName(DBrs.getString("SYSTEM_NAME"));
    }

    public static class SystemNamesSnapshotCursor
    extends DBCursor {
        private SystemNamesSnapshot element = new SystemNamesSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResSystemNamesSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResSystemNamesSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResSystemNamesSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return htWhereClause;
        }

        public SystemNamesSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SYSTEM_NAMES_SNAPSHOT", con, SystemNamesSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public SystemNamesSnapshot getObject() throws SQLException {
            SystemNamesSnapshot el = null;
            if (this.DBrs != null) {
                el = new SystemNamesSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SystemNamesSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

