/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeIoportTable;

public class TapeIoport
extends TResTapeIoportTable {
    private String m_SystemCreationClassNameId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static TapeIoportCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeIoportCursor(con, htWhereClause, columns);
    }

    public TapeIoport() {
        this.clear();
    }

    public TapeIoport(short SystemCreationClassNameId, short CreationClassNameId, short SystemNamesId, String DeviceId, int OperationalStatus, String ElementName, int TapeLibraryId, short Extended, String Caption, String Description, int LocationId, int ConsolidatedStatus, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_DeviceId = DeviceId;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ElementName = ElementName;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_Extended = Extended;
        this.m_Caption = Caption;
        this.m_Description = Description;
        this.m_LocationId = LocationId;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_Extended != Short.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("EXTENDED"), String.valueOf(this.m_Extended));
        }
        if (this.m_Caption != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("CAPTION"), this.m_Caption);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_LocationId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_ConsolidatedStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeIoport.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htColsAndValues.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(TapeIoport.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_IOPORT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        if (htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_IOPORT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_IOPORT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_IOPORT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_IOPORT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_IOPORT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_IOPORT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeIoport retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeIoport el = null;
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        htWhereClause.put(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeIoport.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        htWhereClause.put(TapeIoport.getColumnInfo("DEVICE_ID"), htinput.get(TapeIoport.getColumnInfo("DEVICE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_IOPORT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeIoport();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_IOPORT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_IOPORT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setExtended(DBrs.getShort("EXTENDED"));
        this.setCaption(DBrs.getString("CAPTION"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
        this.setLocationId(DBrs.getInt("LOCATION_ID"));
        this.setConsolidatedStatus(DBrs.getInt("CONSOLIDATED_STATUS"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class TapeIoportCursor
    extends DBCursor {
        private TapeIoport element = new TapeIoport();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeIoportTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeIoportTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResTapeIoportTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResTapeIoportTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeIoportTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeIoportTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResTapeIoportTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResTapeIoportTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResTapeIoportTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return htWhereClause;
        }

        public TapeIoportCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_IOPORT", con, TapeIoportCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeIoport getObject() throws SQLException {
            TapeIoport el = null;
            if (this.DBrs != null) {
                el = new TapeIoport();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeIoport getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

