/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;

public class TapeMediaLocation
extends TResTapeMediaLocationTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static TapeMediaLocationCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeMediaLocationCursor(con, htWhereClause, columns);
    }

    public TapeMediaLocation() {
        this.clear();
    }

    public TapeMediaLocation(int LocationId, String Tag2, short CreationClassNameId, short LocationType, String LocationCoordinates, int MediaCapacity, int TapeLibraryId, Timestamp UpdateTimestamp, short Mediatypessupported) {
        this.clear();
        this.m_LocationId = LocationId;
        this.m_Tag = Tag2;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_LocationType = LocationType;
        this.m_LocationCoordinates = LocationCoordinates;
        this.m_MediaCapacity = MediaCapacity;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Mediatypessupported = Mediatypessupported;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_LocationId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_LocationType != Short.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("LOCATION_TYPE"), String.valueOf(this.m_LocationType));
        }
        if (this.m_LocationCoordinates != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("LOCATION_COORDINATES"), this.m_LocationCoordinates);
        }
        if (this.m_MediaCapacity != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("MEDIA_CAPACITY"), String.valueOf(this.m_MediaCapacity));
        }
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Mediatypessupported != Short.MIN_VALUE) {
            htColsAndValues.put(TapeMediaLocation.getColumnInfo("MEDIATYPESSUPPORTED"), String.valueOf(this.m_Mediatypessupported));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_LOCATION", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_LOCATION", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), htinput.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), htinput.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_LOCATION", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeMediaLocation retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeMediaLocation el = null;
        if (htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), htinput.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_LOCATION", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeMediaLocation();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setLocationId(DBrs.getInt("LOCATION_ID"));
        this.setTag(DBrs.getString("TAG"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setLocationType(DBrs.getShort("LOCATION_TYPE"));
        this.setLocationCoordinates(DBrs.getString("LOCATION_COORDINATES"));
        this.setMediaCapacity(DBrs.getInt("MEDIA_CAPACITY"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setMediatypessupported(DBrs.getShort("MEDIATYPESSUPPORTED"));
    }

    public static class TapeMediaLocationCursor
    extends DBCursor {
        private TapeMediaLocation element = new TapeMediaLocation();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeMediaLocationTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeMediaLocationTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeMediaLocationTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public TapeMediaLocationCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_MEDIA_LOCATION", con, TapeMediaLocationCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeMediaLocation getObject() throws SQLException {
            TapeMediaLocation el = null;
            if (this.DBrs != null) {
                el = new TapeMediaLocation();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeMediaLocation getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

