/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewVstorageSubsystemTable;

public class VstorageSubsystem
extends TViewVstorageSubsystemTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static VstorageSubsystemCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new VstorageSubsystemCursor(con, htWhereClause, columns);
    }

    public VstorageSubsystem() {
        this.clear();
    }

    public VstorageSubsystem(String PrefixId, int SubsystemId, long AllocatedCapacity, long AvailableCapacity, long BackendStorageCapacity, short VendorId, short ModelId, String Name2, short NameFormat, long Cache2, short OsType, String Type2, String IpAddress, String CodeLevel, String SerialNumber, String DisplayName, String UserProvidedName, short Detectable, int OperationalStatus, short ConsolidatedStatus, int PropagatedStatus, String UserAttrib1, String UserAttrib2, String UserAttrib3, String AccessInfo) {
        this.clear();
        this.m_PrefixId = PrefixId;
        this.m_SubsystemId = SubsystemId;
        this.m_AllocatedCapacity = AllocatedCapacity;
        this.m_AvailableCapacity = AvailableCapacity;
        this.m_BackendStorageCapacity = BackendStorageCapacity;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_Cache = Cache2;
        this.m_OsType = OsType;
        this.m_Type = Type2;
        this.m_IpAddress = IpAddress;
        this.m_CodeLevel = CodeLevel;
        this.m_SerialNumber = SerialNumber;
        this.m_DisplayName = DisplayName;
        this.m_UserProvidedName = UserProvidedName;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
        this.m_AccessInfo = AccessInfo;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PrefixId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("PREFIX_ID"), this.m_PrefixId);
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_AllocatedCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("ALLOCATED_CAPACITY"), String.valueOf(this.m_AllocatedCapacity));
        }
        if (this.m_AvailableCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("AVAILABLE_CAPACITY"), String.valueOf(this.m_AvailableCapacity));
        }
        if (this.m_BackendStorageCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("BACKEND_STORAGE_CAPACITY"), String.valueOf(this.m_BackendStorageCapacity));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_Cache != Long.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("CACHE"), String.valueOf(this.m_Cache));
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_Type != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("TYPE"), this.m_Type);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_CodeLevel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("CODE_LEVEL"), this.m_CodeLevel);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_UserProvidedName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("USER_PROVIDED_NAME"), this.m_UserProvidedName);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VstorageSubsystem.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_VSTORAGE_SUBSYSTEM", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_VSTORAGE_SUBSYSTEM", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSTORAGE_SUBSYSTEM", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSTORAGE_SUBSYSTEM", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSTORAGE_SUBSYSTEM", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSTORAGE_SUBSYSTEM", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VSTORAGE_SUBSYSTEM", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VstorageSubsystem retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        VstorageSubsystem el = null;
        if (htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VSTORAGE_SUBSYSTEM", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new VstorageSubsystem();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSTORAGE_SUBSYSTEM", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VstorageSubsystem.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VstorageSubsystem.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(VstorageSubsystem.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(VstorageSubsystem.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(VstorageSubsystem.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSTORAGE_SUBSYSTEM", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPrefixId(DBrs.getString("PREFIX_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setAllocatedCapacity(DBrs.getLong("ALLOCATED_CAPACITY"));
        this.setAvailableCapacity(DBrs.getLong("AVAILABLE_CAPACITY"));
        this.setBackendStorageCapacity(DBrs.getLong("BACKEND_STORAGE_CAPACITY"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setCache(DBrs.getLong("CACHE"));
        this.setOsType(DBrs.getShort("OS_TYPE"));
        this.setType(DBrs.getString("TYPE"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setCodeLevel(DBrs.getString("CODE_LEVEL"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setUserProvidedName(DBrs.getString("USER_PROVIDED_NAME"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getInt("PROPAGATED_STATUS"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
        this.setAccessInfo(DBrs.getString("ACCESS_INFO"));
    }

    public static class VstorageSubsystemCursor
    extends DBCursor {
        private VstorageSubsystem element = new VstorageSubsystem();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TViewVstorageSubsystemTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TViewVstorageSubsystemTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TViewVstorageSubsystemTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TViewVstorageSubsystemTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TViewVstorageSubsystemTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TViewVstorageSubsystemTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public VstorageSubsystemCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_VSTORAGE_SUBSYSTEM", con, VstorageSubsystemCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public VstorageSubsystem getObject() throws SQLException {
            VstorageSubsystem el = null;
            if (this.DBrs != null) {
                el = new VstorageSubsystem();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public VstorageSubsystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

