/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class InFlightScan {
    private String scanId;
    private String scanType;
    private int scannerClass;
    private int systemId;
    private int systemType = -1;
    private HashSet tableList;
    private boolean inUpdate;
    private Timestamp scanTime;
    private boolean isNew;
    private String processID;
    private static ILogger traceLogger = null;
    private static String className = DetectabilityService.class.getName();
    private static boolean TRACE = false;

    InFlightScan(String scanId, int systemId, int systemType) {
        String methodName = "InFlightScan";
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " scanner id " + scanId + " systemId " + systemId);
        }
        this.scanId = scanId;
        this.systemId = systemId;
        this.systemType = systemType;
        this.scanType = DetectabilityService.getTypeFromScanId(scanId);
        this.processID = "x" + scanId + Long.toString(System.currentTimeMillis());
        this.tableList = new HashSet();
        this.isNew = true;
        this.setLock();
    }

    public boolean isLocked() {
        return this.inUpdate;
    }

    public synchronized void setLock() {
        String methodName = "setLock";
        this.inUpdate = true;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " setting lock for scanner " + this.scanId);
        }
    }

    public synchronized void resetLock() {
        String methodName = "resetLock";
        this.inUpdate = false;
        this.isNew = true;
        if (true) {
            this.isNew = false;
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " resetting lock for scanner " + this.scanId);
        }
    }

    public int getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(int scannerClass) {
        String methodName = "setScannerClass";
        this.scannerClass = scannerClass;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " setting scanner " + scannerClass + " for scanner " + this.scanId);
        }
    }

    public String getScanId() {
        return this.scanId;
    }

    public Timestamp getScanTime() {
        return this.scanTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScanTime() throws SQLException {
        String methodName = "setScanTime";
        DBConnPoolDataSource ds = null;
        DBConnection dbCon = null;
        try {
            ds = DBConnPoolDataSource.getInstance();
            dbCon = (DBConnection)ds.getPooledConnection();
            this.scanTime = CurrentTime.getTimestamp(dbCon);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " Connection succeeded - " + dbCon);
            }
        }
        finally {
            if (dbCon != null) {
                dbCon.close();
            }
        }
    }

    public int getScanSystemID() {
        return this.systemId;
    }

    public String getProcessID() {
        return this.processID;
    }

    public void setProcessID(String pID) {
        this.processID = pID;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void addTable(String tableName) {
        this.tableList.add(tableName);
    }

    public void clearTables() {
        this.tableList.clear();
    }

    public HashSet getList() {
        return this.tableList;
    }

    public void replaceList(HashSet list) {
        this.tableList = list;
    }

    public String getScanType() {
        return this.scanType;
    }

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    public int getSystemType() {
        return this.systemType;
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

