/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystemSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroupSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.IoGroupSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.ModelSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.NodeSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.PortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtentSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StoragePoolSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystemSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolumeSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.VendorSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extentSnapshot;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolumeSnapshot;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentSnapshotTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotStorageSubsystem {
    private static String STORAGE_SUBSYSTEM_TABLE = "T_RES_STORAGE_SUBSYSTEM";
    private static String STORAGE_POOL_TABLE = "T_RES_STORAGE_POOL";
    private static String STORAGE_EXTENT_TABLE = "T_RES_STORAGE_EXTENT";
    private static String DISK_GROUP_TABLE = "T_RES_DISK_GROUP";
    private static String STORAGE_VOLUME_TABLE = "T_RES_STORAGE_VOLUME";
    private static String VOLUME2EXTENT_TABLE = "T_RES_VOLUME2EXTENT";
    private static String PORT_TABLE = "T_RES_PORT";
    private static String NODE_TABLE = "T_RES_NODE";
    private static String CIMKEY_SUBSYSTEM_TABLE = "T_RES_CIMKEY_SUBSYSTEM";
    private static String VENDOR_TABLE = "T_RES_VENDOR";
    private static String MODEL_TABLE = "T_RES_MODEL";
    private static String CIMKEY_PORT_TABLE = "T_RES_CIMKEY_PORT";
    private static String CIMKEY_VOLUME_TABLE = "T_RES_CIMKEY_VOLUME";
    private static String IO_GROUP_TABLE = "T_RES_IO_GROUP";
    private static ILogger traceLogger = null;
    private static String className = SnapshotStorageSubsystem.class.getName();
    private static boolean TRACE = false;

    static int create(DBConnection sqlConn, int subsystemId) throws Exception {
        String methodName = "create(" + subsystemId + ")";
        int snapshotId = -1;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        StorageSubsystem mySubsystem = null;
        Object myPool = null;
        DBCursor mySsCursor = null;
        DBCursor mySpCursor = null;
        Vector<String> columnList = new Vector<String>();
        LinkedHashSet<Integer> myLhs = new LinkedHashSet<Integer>();
        SnapshotMetadata snapMd = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(subsystemId));
            mySsCursor = StorageSubsystem.getCursor(sqlConn, htWhereClause, null);
            if (mySsCursor.next()) {
                mySubsystem = ((StorageSubsystem.StorageSubsystemCursor)mySsCursor).getAttributes();
            }
            if (mySubsystem == null) {
                Exception ex = new Exception("Bad system ID: " + subsystemId);
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            snapshotId = AutoIdentifier.getIdentifier(9, 1);
            Timestamp currTs = CurrentTime.getTimestamp(sqlConn);
            snapMd = SnapshotUtil.createSnapshotMetadata(sqlConn, snapshotId, currTs, subsystemId, 1, false);
            SnapshotStorageSubsystem.createStorageSubsystemSnapshot(sqlConn, mySubsystem, snapshotId, STORAGE_SUBSYSTEM_TABLE);
            SnapshotStorageSubsystem.createStoragePoolSnapshot(sqlConn, mySubsystem, snapshotId, STORAGE_POOL_TABLE);
            SnapshotStorageSubsystem.createStorageExtentSnapshot(sqlConn, mySubsystem, snapshotId, STORAGE_EXTENT_TABLE);
            SnapshotStorageSubsystem.createDiskGroupSnapshot(sqlConn, mySubsystem, snapshotId, DISK_GROUP_TABLE);
            SnapshotStorageSubsystem.createPortSnapshot(sqlConn, mySubsystem, snapshotId, PORT_TABLE);
            SnapshotStorageSubsystem.createNodeSnapshot(sqlConn, mySubsystem, snapshotId, NODE_TABLE);
            SnapshotStorageSubsystem.createCimkeySubsystemSnapshot(sqlConn, mySubsystem, snapshotId, CIMKEY_SUBSYSTEM_TABLE);
            SnapshotStorageSubsystem.createVendorSnapshot(sqlConn, mySubsystem, snapshotId, VENDOR_TABLE);
            SnapshotStorageSubsystem.createModelSnapshot(sqlConn, mySubsystem, snapshotId, MODEL_TABLE);
            SnapshotStorageSubsystem.createCimkeyPortSnapshot(sqlConn, mySubsystem, snapshotId, CIMKEY_PORT_TABLE);
            SnapshotStorageSubsystem.createIoGroupSnapshot(sqlConn, mySubsystem, snapshotId, IO_GROUP_TABLE);
            sqlConn.commit();
            htWhereClause.clear();
            htWhereClause.put(TResStoragePoolTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(subsystemId));
            columnList.add("POOL_ID");
            mySpCursor = StoragePool.getCursor(sqlConn, htWhereClause, columnList);
            while (mySpCursor.next()) {
                Integer poolId = (Integer)mySpCursor.getAttribute(columnList)[0];
                myLhs.add(poolId);
            }
            sqlConn.commit();
            Iterator myIter = myLhs.iterator();
            while (myIter.hasNext()) {
                SnapshotStorageSubsystem.createStorageVolumeSnapshot(sqlConn, mySubsystem, snapshotId, (Integer)myIter.next(), STORAGE_VOLUME_TABLE);
                sqlConn.commit();
            }
            for (Integer pool : myLhs) {
                SnapshotStorageSubsystem.createCimkeyVolumeSnapshot(sqlConn, mySubsystem, snapshotId, pool, CIMKEY_VOLUME_TABLE);
                sqlConn.commit();
            }
            myIter = myLhs.iterator();
            while (myIter.hasNext()) {
                SnapshotStorageSubsystem.createVolume2extentSnapshot(sqlConn, mySubsystem, snapshotId, (Integer)myIter.next(), VOLUME2EXTENT_TABLE);
                if (!myIter.hasNext()) {
                    snapMd.setSnapshotConsistent((short)1);
                    snapMd.update(sqlConn);
                }
                sqlConn.commit();
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
            int pool = snapshotId;
            return pool;
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        finally {
            if (mySsCursor != null) {
                mySsCursor.close();
            }
            if (mySpCursor != null) {
                mySpCursor.close();
            }
        }
    }

    static void delete(DBConnection sqlConn, int snapshotId) throws SQLException {
        String methodName = "delete(" + snapshotId + ")";
        Hashtable htWhereClause = new Hashtable();
        DBCursor mySpCursor = null;
        DBCursor mySeCursor = null;
        Vector<String> columnList = new Vector<String>();
        LinkedHashSet<Integer> poolLhs = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> extentLhs = new LinkedHashSet<Integer>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.clear();
            htWhereClause.put(TResStoragePoolSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            columnList.clear();
            columnList.add("POOL_ID");
            mySpCursor = StoragePoolSnapshot.getCursor(sqlConn, htWhereClause, columnList);
            while (mySpCursor.next()) {
                Integer poolId = (Integer)mySpCursor.getAttribute(columnList)[0];
                poolLhs.add(poolId);
            }
            htWhereClause.clear();
            htWhereClause.put(TResStorageExtentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            columnList.clear();
            columnList.add("STORAGE_EXTENT_ID");
            mySeCursor = StorageExtentSnapshot.getCursor(sqlConn, htWhereClause, columnList);
            while (mySeCursor.next()) {
                Integer storageExtentId = (Integer)mySeCursor.getAttribute(columnList)[0];
                extentLhs.add(storageExtentId);
            }
            Iterator myIter = extentLhs.iterator();
            while (myIter.hasNext()) {
                htWhereClause.clear();
                htWhereClause.put(TResVolume2extentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
                htWhereClause.put(TResVolume2extentSnapshotTable.getColumnInfo("STORAGE_EXTENT_ID"), ((Integer)myIter.next()).toString());
                Volume2extentSnapshot.deletes(sqlConn, htWhereClause);
                sqlConn.commit();
            }
            myIter = poolLhs.iterator();
            while (myIter.hasNext()) {
                Vector<ColumnInfo> colInfo = new Vector<ColumnInfo>();
                Vector<String> colVal = new Vector<String>();
                colInfo.add(TResCimkeyVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"));
                colVal.add(String.valueOf(snapshotId));
                colInfo.add(TResStorageVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"));
                colVal.add(String.valueOf(snapshotId));
                colInfo.add(TResStorageVolumeSnapshotTable.getColumnInfo("POOL_ID"));
                colVal.add(((Integer)myIter.next()).toString());
                htWhereClause = ComplexQuery.generateHashtable(colInfo, colVal);
                SqlCimkeyVolumeSnapshot.sqlUpdate(sqlConn, 0, htWhereClause);
                sqlConn.commit();
            }
            myIter = poolLhs.iterator();
            while (myIter.hasNext()) {
                htWhereClause.clear();
                htWhereClause.put(TResStorageVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
                htWhereClause.put(TResStorageVolumeSnapshotTable.getColumnInfo("POOL_ID"), ((Integer)myIter.next()).toString());
                StorageVolumeSnapshot.deletes(sqlConn, htWhereClause);
                sqlConn.commit();
            }
            htWhereClause.clear();
            htWhereClause.put(TResModelSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            ModelSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResVendorSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            VendorSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResCimkeyPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            CimkeyPortSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResCimkeySubsystemSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            CimkeySubsystemSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResNodeSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            NodeSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            PortSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResDiskGroupSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            DiskGroupSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResStorageExtentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            StorageExtentSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResStoragePoolSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            StoragePoolSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResIoGroupSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            IoGroupSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResStorageSubsystemSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            StorageSubsystemSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            SnapshotMetadata.deletes(sqlConn, htWhereClause);
            sqlConn.commit();
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        finally {
            if (mySpCursor != null) {
                mySpCursor.close();
            }
            if (mySeCursor != null) {
                mySeCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createStorageSubsystemSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createStorageSubsystemSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createStoragePoolSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createStoragePoolSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStoragePoolTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createStorageExtentSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createStorageExtentSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createDiskGroupSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createDiskGroupSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createStorageVolumeSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, Integer poolId, String tableName) throws SQLException {
        String methodName = "createStorageVolumeSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), poolId.toString());
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createVolume2extentSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, Integer poolId, String tableName) throws SQLException {
        String methodName = "createVolume2extentSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), poolId.toString());
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createPortSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createPortSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createNodeSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createNodeSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResNodeTable.getColumnInfo("SYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimkeySubsystemSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createCimkeySubsystemSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createVendorSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createVendorSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createModelSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createModelSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimkeyPortSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createCimkeyPortSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimkeyVolumeSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, Integer poolId, String tableName) throws SQLException {
        String methodName = "createCimkeyVolumeSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), poolId.toString());
                sqlParams.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createIoGroupSnapshot(DBConnection sqlConn, StorageSubsystem mySubsystem, int snapshotId, String tableName) throws SQLException {
        String methodName = "createIoGroupSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(1, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(mySubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

