/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Disk;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;

public class CorrelateVolume {
    public static void correlateStorageVolume(DBConnection con, short osType, int storageVolumeId) throws SQLException {
        int physicalVolumeId;
        String serialNumber = CorrelateVolume.getStorageVolumeSerialNumber(con, osType, storageVolumeId);
        if (serialNumber != null && (physicalVolumeId = CorrelateVolume.getPhysicalVolumeId(con, osType, serialNumber)) != -1) {
            CorrelateVolume.createCorrelation(con, physicalVolumeId, storageVolumeId);
        }
    }

    public static void correlatePhysicalVolume(DBConnection con, short osType, int physicalVolumeId) throws SQLException {
        int storageVolumeId;
        String serialNumber = CorrelateVolume.getPhysicalVolumeSerialNumber(con, osType, physicalVolumeId);
        if (serialNumber != null && (storageVolumeId = CorrelateVolume.getStorageVolumeId(con, osType, serialNumber)) != -1) {
            CorrelateVolume.createCorrelation(con, physicalVolumeId, storageVolumeId);
        }
    }

    private static void createCorrelation(DBConnection con, int physicalVolumeId, int storageVolumeId) throws SQLException {
        Object[] ids;
        int old_svid;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(Disk.getColumnInfo("DISK_ID"), String.valueOf(physicalVolumeId));
        Vector<String> cols = new Vector<String>();
        cols.add("LOGICAL_DISK_ID");
        Disk.DiskCursor dCs = Disk.getCursor(con, htWhereClause, cols);
        if (dCs.next() && (old_svid = ((Integer)(ids = dCs.getAttribute(cols))[0]).intValue()) != storageVolumeId) {
            Hashtable<ColumnInfo, String> htinput = new Hashtable<ColumnInfo, String>();
            htinput.put(Disk.getColumnInfo("LOGICAL_DISK_ID"), ((Integer)ids[0]).toString());
            Disk.update(con, htinput, htWhereClause);
        }
    }

    private static String getStorageVolumeSerialNumber(DBConnection con, short osType, int storageVolumeId) throws SQLException {
        String retStr = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(storageVolumeId));
        htWhereClause.put(StorageVolume.getColumnInfo("NAME_FORMAT"), "15");
        Vector<String> cols = new Vector<String>();
        cols.add("NAME");
        StorageVolume.StorageVolumeCursor svCs = StorageVolume.getCursor(con, htWhereClause, cols);
        if (svCs.next()) {
            Object[] ids = svCs.getAttribute(cols);
            retStr = (String)ids[0];
        }
        return retStr;
    }

    private static String getPhysicalVolumeSerialNumber(DBConnection con, short osType, int physicalVolumeId) throws SQLException {
        String retStr = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), String.valueOf(physicalVolumeId));
        Vector<String> cols = new Vector<String>();
        cols.add("SERIAL_NUMBER");
        PhysicalVolume.PhysicalVolumeCursor pvCs = PhysicalVolume.getCursor(con, htWhereClause, cols);
        if (pvCs.next()) {
            Object[] ids = pvCs.getAttribute(cols);
            retStr = (String)ids[0];
        }
        return retStr;
    }

    private static int getPhysicalVolumeId(DBConnection con, short osType, String serialNumber) throws SQLException {
        int ret = -1;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(PhysicalVolume.getColumnInfo("STORAGE_SYSTEM_TYPE"), String.valueOf(osType));
        htWhereClause.put(PhysicalVolume.getColumnInfo("SERIAL_NUMBER"), serialNumber);
        Vector<String> cols = new Vector<String>();
        cols.add("PHYSICAL_VOLUME_ID");
        PhysicalVolume.PhysicalVolumeCursor pvCs = PhysicalVolume.getCursor(con, htWhereClause, cols);
        if (pvCs.next()) {
            Object[] ids = pvCs.getAttribute(cols);
            ret = (Integer)ids[0];
        }
        return ret;
    }

    private static int getStorageVolumeId(DBConnection con, short osType, String serialNumber) throws SQLException {
        int ret = -1;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(StorageVolume.getColumnInfo("NAME"), serialNumber);
        htWhereClause.put(StorageVolume.getColumnInfo("NAME_FORMAT"), "15");
        Vector<String> cols = new Vector<String>();
        cols.add("SVID");
        StorageVolume.StorageVolumeCursor svCs = StorageVolume.getCursor(con, htWhereClause, cols);
        if (svCs.next()) {
            Object[] ids = svCs.getAttribute(cols);
            ret = (Integer)ids[0];
        }
        return ret;
    }
}

