/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class FcPortXmlToDBMapper
extends DBAttributeMapper {
    private static final String STATE = "State";
    private static final String PORTSTATE = "Port State";
    private static final String CONSTATE = "conState";
    private static final String FCPORTID = "FC Port ID";
    private static final String TYPE = "Type";
    private static final String PHYSICALPORTNUMBER = "Physical Port Number";
    private static final String NAMEFORMAT = "Name Format";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "FcPortXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public FcPortXmlToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(TYPE.toLowerCase(), "Port_Types");
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
        this.m_htAttribToMapperInfo.put(PHYSICALPORTNUMBER.toLowerCase(), new MapperInfo(Port.getColumnInfo("PORT_NUMBER")));
        this.m_htAttribToMapperInfo.put(STATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(PORTSTATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CONSTATE.toLowerCase(), new MapperInfo(Port.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(TYPE.toLowerCase(), new MapperInfo(Port.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put(FCPORTID.toLowerCase(), new MapperInfo(Port.getColumnInfo("FC_PORT_ID")));
        ColumnInfo portWwnInfo = Port.getColumnInfo("NAME");
        portWwnInfo.setIsPrimaryKey();
        MapperInfo portWwnMapperInfo = new MapperInfo(portWwnInfo);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), portWwnMapperInfo);
        ColumnInfo nameFormat = Port.getColumnInfo("NAME_FORMAT");
        nameFormat.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(NAMEFORMAT.toLowerCase(), new MapperInfo(nameFormat));
        ColumnInfo portIdInfo = Port.getColumnInfo("PORT_ID");
        portIdInfo.setAutoGenerated();
        portWwnMapperInfo.setDerivedColumn(portIdInfo);
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String uniqueXML = (String)htValues.get("UniqueIdXml");
        if (uniqueXML == null) {
            SQLException e = new SQLException("Required field, UniqueIdXml, was not found.");
            this.logException(this.myClassname, methodName, e, "");
            throw e;
        }
        htValues.put("UniqueIdXml", uniqueXML.toUpperCase());
        String sniaValState = (String)htValues.remove(STATE);
        boolean isState = true;
        if (sniaValState == null) {
            sniaValState = (String)htValues.remove(PORTSTATE);
            if (sniaValState == null) {
                sniaValState = (String)htValues.remove(PORTSTATE.toLowerCase());
            }
            isState = false;
        }
        if (sniaValState != null) {
            String[] smisValStateArr = this.convertSNIAOPStatToBitArrValue(sniaValState);
            if (isState) {
                htValues.put(STATE, smisValStateArr[0]);
            } else {
                htValues.put(PORTSTATE, smisValStateArr[0]);
            }
            Vector<String> vOpStat = new Vector<String>();
            vOpStat.add(smisValStateArr[1]);
            String conState = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vOpStat);
            if (conState != null) {
                htValues.put(CONSTATE, conState);
            }
        }
        htValues.put(NAMEFORMAT.toLowerCase(), DBConstants.getValueFromKey("Name_Format", "FC_WWN"));
        String fcPortId = (String)htValues.get(FCPORTID);
        if (fcPortId != null) {
            try {
                int id = Integer.parseInt(fcPortId, 16);
                htValues.put(FCPORTID, Integer.toString(id));
            }
            catch (NumberFormatException e) {
                htValues.remove(FCPORTID);
                this.logWarning(this.myClassname, methodName, "An error occurred when trying to parse the FC_PORT_ID value, " + fcPortId + ", as a hex integer");
            }
        }
        MapperResult mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

