/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBTableMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperPackage;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.IMapperRouterService;
import org.eclipse.aperi.util.UStack;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class MapperRouter
extends AbstractExtensionMgr
implements IMapperRouterService {
    public static final String SMIS102 = "1.0.2";
    public static final String SMIS103 = "1.0.3";
    public static final String SMIS11 = "1.1.0";
    public static final String DEVICE_1750 = "1750";
    public static final String DEVICE_2105 = "2105";
    public static final String DEVICE_2107 = "2107";
    public static final String DEVICE_2145 = "2145";
    public static final String DEVICE_3581 = "3581";
    public static final String DEVICE_3582 = "3582";
    public static final String DEVICE_3583 = "3583";
    public static final String DEVICE_3584 = "3584";
    public static final String DEVICE_3494 = "3494";
    public static final String DEVICE_GENERIC_TAPE_LIBRARY = "GENERIC_TAPE_LIBRARY";
    public static final String DEVICE_2109 = "2109";
    public static final String AGENT_11 = "1.1";
    public static final String AGENT_111 = "1.1.1";
    public static final String AGENT_12 = "1.2";
    public static final String AGENT_21 = "2.1";
    public static final String AGENT_51 = "5.1";
    private Hashtable<String, IDBAttributeMapper> htMapperInstances = new Hashtable();
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.common.dbAttributeMapper";
    public static final String ATTR_IMPL = "impl";
    public static final String ELEMENT_SMISDBMAPPERREGISTRATIONDATA = "SMISMapperRegistrationData";
    public static final String ATTR_CIMCLASSNAME = "SMISVersion";
    public static final String ATTR_SMISVERSION = "SMISVersion";
    public static final String ATTR_DEVICETYPE = "DeviceType";
    public static final String ATTR_SMISPROVIDERVERION = "SMISProviderVersion";
    public static final String ATTR_DEDICATED = "Dedicated";
    private static MapperRouter stRouter = new MapperRouter();
    private static boolean stIsScanned = false;
    private static String stPackageFileSep = "com" + File.separator + "ibm" + File.separator + "tpc" + File.separator + "infrastructure" + File.separator + "mapping";
    private Map cMapperMap1 = new HashMap();
    private Map cMapperMap2;

    private static Map getInnerMap(Map pMap, String pKey) {
        Map mResult;
        if (pMap.containsKey(pKey)) {
            mResult = (Map)pMap.get(pKey);
        } else {
            mResult = new HashMap();
            pMap.put(pKey, mResult);
        }
        return mResult;
    }

    public static MapperRouter getMapperRouter() {
        if (!stIsScanned) {
            stRouter.registerMappers();
            stIsScanned = true;
        }
        return stRouter;
    }

    private MapperRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cMapperMap1;
        synchronized (map) {
            this.cMapperMap1.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findBestMatch(Map pMap, UStack pStack, MatchGauge pGauge) {
        Map map = this.cMapperMap1;
        synchronized (map) {
            String mKey = (String)pStack.pop();
            boolean mHasPrecise = pMap.containsKey(mKey);
            boolean mHasGeneric = pMap.containsKey(null);
            if (!mHasPrecise && !mHasGeneric) {
                pGauge.markMismatch();
                return null;
            }
            if (pStack.empty()) {
                if (!mHasPrecise) {
                    pGauge.countGenericMatch();
                    return pMap.get(null);
                }
                pGauge.countPreciseMatch();
                return pMap.get(mKey);
            }
            if (!mHasPrecise) {
                return this.findBestMatch((HashMap)pMap.get(null), pStack, pGauge.countGenericMatch());
            }
            if (!mHasGeneric) {
                return this.findBestMatch((HashMap)pMap.get(mKey), pStack, pGauge.countPreciseMatch());
            }
            MatchGauge bGauge1 = new MatchGauge();
            MatchGauge bGauge2 = new MatchGauge();
            Object bPos1 = this.findBestMatch((HashMap)pMap.get(null), new UStack(pStack), bGauge1.countGenericMatch());
            Object bPos2 = this.findBestMatch((HashMap)pMap.get(mKey), new UStack(pStack), bGauge2.countPreciseMatch());
            pGauge.concat(bGauge2.less(bGauge1) ? bGauge1 : bGauge2);
            return bGauge2.less(bGauge1) ? bPos1 : bPos2;
        }
    }

    public IDBAttributeMapper findMapper(String pCIMClassName, String pSMISVersion, String pDeviceModel, String pInstrumentationVersion, String pDedicated, String pOriginalCIMClass) {
        String DEDICATED_Storage = "3";
        String DEDICATED_Switch = "5";
        String DEDICATED_Block_Server = "15";
        String DEDICATED_Storage_Virtualizer = "21";
        String DEDICATED_Media_Library = "22";
        Vector mDedicated = null;
        if (pDedicated != null) {
            mDedicated = DBAttributeMapper.processArrayvalues(pDedicated);
        }
        Object mMapper = null;
        for (int counter = 0; mMapper == null && pCIMClassName != null && counter < 5; ++counter) {
            mMapper = this.retrieveMapper(pCIMClassName, pSMISVersion, pDeviceModel, pInstrumentationVersion, mDedicated);
            pCIMClassName = DBTableMapper.getLookup(pCIMClassName, pDedicated);
        }
        if (mMapper == null && pDedicated != null && pOriginalCIMClass != null) {
            mMapper = mDedicated.contains(DEDICATED_Storage_Virtualizer) || mDedicated.contains("0") ? this.retrieveMapper(pOriginalCIMClass, pSMISVersion, pDeviceModel, pInstrumentationVersion, mDedicated) : (mDedicated.contains(DEDICATED_Media_Library) && pOriginalCIMClass.equals("CIM_ComputerSystem") ? this.retrieveMapper("CIM_ComputerSystem", pSMISVersion, pDeviceModel, pInstrumentationVersion, mDedicated) : this.retrieveMapper(pOriginalCIMClass, pSMISVersion, pDeviceModel, pInstrumentationVersion, mDedicated));
        } else if (mMapper == null && pDedicated == null && pOriginalCIMClass != null) {
            mMapper = this.retrieveMapper(pOriginalCIMClass, pSMISVersion, pDeviceModel, pInstrumentationVersion, pDedicated);
        }
        if (mMapper != null) {
            try {
                IDBAttributeMapper dbMapper;
                if (mMapper.getClass().getName().equals(String.class.getName())) {
                    dbMapper = (DBAttributeMapper)this.htMapperInstances.get((String)mMapper);
                    if (dbMapper == null) {
                        dbMapper = (IDBAttributeMapper)this.getExtensionImpl((String)mMapper, false);
                        this.htMapperInstances.put((String)mMapper, dbMapper);
                    }
                } else {
                    Class bMapperClass = (Class)mMapper;
                    String bMapperClassname = bMapperClass.getName();
                    dbMapper = (DBAttributeMapper)this.htMapperInstances.get(bMapperClassname);
                    if (dbMapper == null) {
                        dbMapper = (DBAttributeMapper)bMapperClass.newInstance();
                        this.htMapperInstances.put(bMapperClassname, dbMapper);
                    }
                }
                return dbMapper;
            }
            catch (ExtensionException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }

    public IDBAttributeMapper findMapper(String pCIMClassName, String pSMISVersion, String pDeviceModel, String pInstrumentationVersion) {
        return this.findMapper(pCIMClassName, pSMISVersion, pDeviceModel, pInstrumentationVersion, null, null);
    }

    public IDBAttributeMapper findMapper(String pCIMClassName, String pSMISVersion, String pDeviceModel, String pInstrumentationVersion, String pDedicated) {
        return this.findMapper(pCIMClassName, pSMISVersion, pDeviceModel, pInstrumentationVersion, pDedicated, null);
    }

    private Object retrieveMapper(String pCIMClassName, String pSMISVersion, String pDeviceModel, String pInstrumentationVersion, String pDedicated) {
        UStack mData = new UStack();
        mData.push(pCIMClassName);
        mData.push(pSMISVersion);
        mData.push(pDeviceModel);
        mData.push(pInstrumentationVersion);
        mData.push(pDedicated);
        Object mMapper = this.findBestMatch(this.cMapperMap1, mData, new MatchGauge());
        return mMapper;
    }

    private Object retrieveMapper(String pCIMClassName, String pSMISVersion, String pDeviceModel, String pInstrumentationVersion, Vector pDedicated) {
        Object mMapper = null;
        if (pDedicated == null) {
            return this.retrieveMapper(pCIMClassName, pSMISVersion, pDeviceModel, pInstrumentationVersion, (String)null);
        }
        for (int i = 0; i < pDedicated.size() && (mMapper = this.retrieveMapper(pCIMClassName, pSMISVersion, pDeviceModel, pInstrumentationVersion, (String)pDedicated.get(i))) == null; ++i) {
        }
        return mMapper;
    }

    public DBAttributeMapper.RegistrationData[] getRegisteredProcesses() {
        ArrayList mResult = this.recurseRequests(this.cMapperMap1, new UStack());
        return mResult.toArray(new DBAttributeMapper.RegistrationData[mResult.size()]);
    }

    public DBAttributeMapper.RegistrationData[] getRegisteredProcessNames() {
        ArrayList mResult = this.recurseRequests(this.cMapperMap1, new UStack());
        return mResult.toArray(new DBAttributeMapper.RegistrationData[mResult.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList recurseRequests(Map pMap, UStack pParameterStack) {
        ArrayList<DBAttributeMapper.RegistrationData> mResult = new ArrayList<DBAttributeMapper.RegistrationData>();
        Map map = pMap;
        synchronized (map) {
            for (Map.Entry mEntry : pMap.entrySet()) {
                pParameterStack.push(mEntry.getKey());
                if (mEntry.getValue() instanceof Map) {
                    mResult.addAll(this.recurseRequests((Map)mEntry.getValue(), pParameterStack));
                } else {
                    UStack bStack = new UStack(pParameterStack);
                    String bCIMClassName = (String)bStack.pop();
                    String bSMISVersion = (String)bStack.pop();
                    String bDeviceModel = (String)bStack.pop();
                    String bIVersion = (String)bStack.pop();
                    String bDedicated = (String)bStack.pop();
                    DBAttributeMapper.RegistrationData bData = new DBAttributeMapper.RegistrationData(bCIMClassName, bSMISVersion, bDeviceModel, bIVersion, bDedicated);
                    mResult.add(bData);
                }
                pParameterStack.pop();
            }
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMapperWithParameters(Class pMapperClass) throws InvalidClassException {
        DBAttributeMapper.RegistrationData[] mRegistration;
        Class mSuperclass = pMapperClass;
        do {
            if ((mSuperclass = mSuperclass.getSuperclass()) != null) continue;
            throw new InvalidClassException(pMapperClass.getName(), "Class doesn't extend " + DBAttributeMapper.class.getName());
        } while (!mSuperclass.equals(DBAttributeMapper.class));
        try {
            Method mGetRegistrationData = pMapperClass.getMethod("getRegistrationData", new Class[0]);
            mRegistration = (DBAttributeMapper.RegistrationData[])mGetRegistrationData.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidClassException(pMapperClass.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        for (int i = 0; i < mRegistration.length; ++i) {
            UStack bStack = new UStack();
            bStack.push(mRegistration[i].getCIMClassName());
            bStack.push(mRegistration[i].getSmisVersion());
            bStack.push(mRegistration[i].getDeviceType());
            bStack.push(mRegistration[i].getInstrumentationVersion());
            bStack.push(mRegistration[i].getDedicated());
            Map map = this.cMapperMap1;
            synchronized (map) {
                String bKey = (String)bStack.pop();
                Map bMap = this.cMapperMap1;
                while (!bStack.empty()) {
                    bMap = MapperRouter.getInnerMap(bMap, bKey);
                    bKey = (String)bStack.pop();
                }
                if (bMap.containsKey(bKey)) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                bMap.put(bKey, pMapperClass);
                continue;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMapperWithName(String pMapperName, Class pMapperClass) throws InvalidClassException {
        Class mSuperclass = pMapperClass;
        do {
            if ((mSuperclass = mSuperclass.getSuperclass()) != null) continue;
            throw new InvalidClassException(pMapperClass.getName(), "Class doesn't extend " + DBAttributeMapper.class.getName());
        } while (!mSuperclass.equals(DBAttributeMapper.class));
        Map map = this.cMapperMap2;
        synchronized (map) {
            if (this.cMapperMap2.containsKey(pMapperName)) {
                throw new IllegalArgumentException("Name already registered.");
            }
            this.cMapperMap2.put(pMapperName, pMapperClass);
        }
        return true;
    }

    private void registerMappers() {
        ArrayList mMapperClasses = MapperPackage.getPackage().getMapperClasses();
        for (int i = 0; i < mMapperClasses.size(); ++i) {
            boolean bSuccess = false;
            try {
                bSuccess = this.registerMapperWithParameters((Class)mMapperClasses.get(i));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        MapperRouter router = MapperRouter.getMapperRouter();
        router.generateMapperPackage();
    }

    private void generateMapperPackage() {
        ArrayList mMappers = this.scanPackage();
        String stPackageFileSep = "com" + File.separator + "ibm" + File.separator + "tpc" + File.separator + "infrastructure" + File.separator + "mapping";
        try {
            FileOutputStream fos = new FileOutputStream(new File(stPackageFileSep + File.separator + "MapperPackage.java"));
            PrintWriter writer = new PrintWriter(fos);
            writer.println("/** \n* (C) Copyright IBM Corp. 2006* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n */\n");
            writer.println("");
            writer.println("package org.eclipse.aperi.infrastructure.mapping;");
            writer.println("");
            writer.println("import java.util.ArrayList;");
            writer.println("");
            writer.println("public class MapperPackage {");
            writer.println("");
            writer.println("   private static ArrayList cMappers = new ArrayList();");
            writer.println("");
            writer.println("   private static MapperPackage stMapperPackage = new MapperPackage();");
            writer.println("");
            writer.println("   public static MapperPackage getPackage() {");
            writer.println("      return stMapperPackage;");
            writer.println("   } ");
            writer.println("");
            writer.println("   private MapperPackage() {");
            for (int i = 0; i < mMappers.size(); ++i) {
                writer.println("      cMappers.add(" + mMappers.get(i) + ".class);");
            }
            writer.println("   }");
            writer.println("");
            writer.println("   public ArrayList getMapperClasses() {");
            writer.println("      return cMappers;");
            writer.println("   }");
            writer.println("");
            writer.println("}");
            writer.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private ArrayList scanPackage() {
        ArrayList<String> mMappers = new ArrayList<String>();
        String mAbsolutPath = ClassLoader.getSystemResource(stPackageFileSep).getPath();
        File mPathName = new File(mAbsolutPath);
        String[] fileNames = mPathName.list();
        String mDBAttributeMapperClassName = this.getClass().getPackage().getName() + ".DBAttributeMapper";
        for (int i = 0; i < fileNames.length; ++i) {
            String bFile = fileNames[i].substring(0, fileNames[i].indexOf("."));
            String mExt = fileNames[i].substring(fileNames[i].indexOf(".") + 1);
            if (!mExt.equals("class") || bFile.indexOf(36) != -1) continue;
            boolean bRegistered = false;
            try {
                Class<?> bClass = Class.forName(this.getClass().getPackage().getName() + "." + bFile);
                String bClassName = bClass.getName();
                Class<?> bSuperClass = bClass;
                while (bSuperClass.getName() != "java.lang.Object" && !bRegistered) {
                    String bSuperClassName = (bSuperClass = bSuperClass.getSuperclass()).getName();
                    if (!bSuperClassName.equals(mDBAttributeMapperClassName)) continue;
                    mMappers.add(bFile);
                    bRegistered = true;
                }
                continue;
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return mMappers;
    }

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    protected void extensionAdded(String extensionId) {
        this.handleDBAttributeMapperExtension(extensionId, true);
    }

    protected void extensionRemoved(String extensionId) {
        this.handleDBAttributeMapperExtension(extensionId, false);
    }

    private void handleDBAttributeMapperExtension(String extensionId, boolean registerExtension) {
        IConfigurationElement[] elements;
        IExtension extension = this.getExtension(extensionId);
        if (extension != null && (elements = extension.getConfigurationElements()) != null) {
            IConfigurationElement[] smisDBMapperRegistrations = elements[0].getChildren(ELEMENT_SMISDBMAPPERREGISTRATIONDATA);
            for (int i = 0; i < smisDBMapperRegistrations.length; ++i) {
                IConfigurationElement smisDBMapperRegistrationData = smisDBMapperRegistrations[i];
                this.registerDBAttributeMapperExtension(extensionId, smisDBMapperRegistrationData, registerExtension);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDBAttributeMapperExtension(String pExtensionID, IConfigurationElement pConfigElement, boolean registerExtension) {
        if (ELEMENT_SMISDBMAPPERREGISTRATIONDATA.equals(pConfigElement.getName())) {
            UStack bStack = new UStack();
            bStack.push(pConfigElement.getAttribute("SMISVersion"));
            bStack.push(pConfigElement.getAttribute("SMISVersion"));
            bStack.push(pConfigElement.getAttribute(ATTR_DEVICETYPE));
            bStack.push(pConfigElement.getAttribute(ATTR_SMISPROVIDERVERION));
            bStack.push(pConfigElement.getAttribute(ATTR_DEDICATED));
            Map map = this.cMapperMap1;
            synchronized (map) {
                String bKey = (String)bStack.pop();
                Map bMap = this.cMapperMap1;
                while (!bStack.empty()) {
                    bMap = MapperRouter.getInnerMap(bMap, bKey);
                    bKey = (String)bStack.pop();
                }
                if (bMap.containsKey(bKey)) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                bMap.put(bKey, pExtensionID);
            }
        } else {
            throw new IllegalArgumentException("No SMISMapperRegistrationData Extensionelement passed.");
        }
    }

    private static final class MatchGauge {
        private int mPreciseMatchCount;
        private int mLevel;
        private int mMatchPattern;

        public MatchGauge() {
            this.mPreciseMatchCount = 0;
            this.mLevel = 0;
            this.mMatchPattern = 0;
        }

        public MatchGauge(MatchGauge rhs) {
            this.mPreciseMatchCount = rhs.mPreciseMatchCount;
            this.mLevel = rhs.mLevel;
            this.mMatchPattern = rhs.mMatchPattern;
        }

        public MatchGauge countPreciseMatch() {
            ++this.mLevel;
            ++this.mPreciseMatchCount;
            this.mMatchPattern += 1 << this.mLevel;
            return this;
        }

        public MatchGauge countGenericMatch() {
            ++this.mLevel;
            return this;
        }

        public void markMismatch() {
            this.mPreciseMatchCount = -1;
        }

        public MatchGauge concat(MatchGauge rhs) {
            if (rhs.mPreciseMatchCount == -1) {
                this.markMismatch();
            } else {
                this.mPreciseMatchCount += rhs.mPreciseMatchCount;
                this.mMatchPattern += rhs.mMatchPattern << this.mLevel;
                this.mLevel += rhs.mLevel;
            }
            return this;
        }

        public boolean less(MatchGauge rhs) {
            return this.mPreciseMatchCount != rhs.mPreciseMatchCount ? this.mPreciseMatchCount < rhs.mPreciseMatchCount : this.mMatchPattern < rhs.mMatchPattern;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(this.mPreciseMatchCount);
            buffer.append(',');
            buffer.append(this.mMatchPattern);
            buffer.append(',');
            buffer.append(this.mLevel);
            buffer.append(')');
            return buffer.toString();
        }
    }
}

