/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class PeripheralEntityXmlToDBMapper
extends DBAttributeMapper {
    private static final String SCSITYPE = "SCSI Type";
    private static final String PLATFORMTYPE = "Platform Type";
    private static final String RNIDTYPE = "RNID Type";
    private static final String SCSISUPPORT = "SCSI Support";
    private static final String SERIALNUMBER = "Serial Number";
    private static final String VENDOR = "Vendor";
    private static final String PRODUCTID = "Product ID";
    private static final String REVISION = "Revision";
    private static final String MGMTTELNETADDRESS = "Management Telnet Address";
    private static final String MGMTSNMPADDRESS = "Management Snmp Address";
    private static final String MGMTURLADDRESS = "Management URL Address";
    private static final String MANUALLYENTEREDNAME = "Manually Entered Name";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "PeripheralEntityXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public PeripheralEntityXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
        this.m_dataConverter.addSimpleDataConversion(SCSITYPE.toLowerCase(), "PE_SCSI_Type");
        this.m_dataConverter.addSimpleDataConversion(PLATFORMTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(RNIDTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(SCSISUPPORT.toLowerCase(), "Node_SCSI_Support");
        ColumnInfo name = PhyPe.getColumnInfo("PE_NAME");
        name.setIsPrimaryKey();
        MapperInfo nameMapping = new MapperInfo(name);
        ColumnInfo autoID = PhyPe.getColumnInfo("PHY_PE_ID");
        autoID.setAutoGenerated();
        nameMapping.setDerivedColumn(autoID);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), nameMapping);
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put(PRODUCTID.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put(REVISION.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("FIRMWARE_REVISION")));
        this.m_htAttribToMapperInfo.put(MGMTTELNETADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_TEL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTSNMPADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_SNMP_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTURLADDRESS.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("MGMT_URL_ADDR")));
        this.m_htAttribToMapperInfo.put(SCSITYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SCSI_TYPE")));
        this.m_htAttribToMapperInfo.put(PLATFORMTYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("PLATFORM_TYPE")));
        this.m_htAttribToMapperInfo.put(RNIDTYPE.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("RNID_TYPE")));
        this.m_htAttribToMapperInfo.put(SCSISUPPORT.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("SCSI_SUPPORT")));
        this.m_htAttribToMapperInfo.put(MANUALLYENTEREDNAME.toLowerCase(), new MapperInfo(PhyPe.getColumnInfo("DISPLAY_NAME")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult mr = null;
        String url = (String)htValues.get(MGMTURLADDRESS);
        if (url != null && url.indexOf("0.0.0.0") != -1) {
            htValues.remove(MGMTURLADDRESS);
        }
        mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

