/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.TapeIoport;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_LimitedAccessPortToDBMapper
extends DBAttributeMapper {
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sDEVICEID = "deviceid";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sELMENTNAME = "elementname";
    public static final String sEXTENDED = "extended";
    public static final String sCAPTION = "caption";
    public static final String sDESCRIPTION = "description";
    public static final String sLIBRARYID = "ref_toplevelsystem_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_LimitedAccessPort";
        String mSMIS = "1.1.0";
        String mDeviceType = "GENERIC_TAPE_LIBRARY";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMIS11CIM_LimitedAccessPortToDBMapper() {
        ColumnInfo mLibraryIDInfo = TapeIoport.getColumnInfo("TAPE_LIBRARY_ID");
        mLibraryIDInfo.setIsPrimaryKey();
        ColumnInfo mDeviceIDInfo = TapeIoport.getColumnInfo("DEVICE_ID");
        mDeviceIDInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(sLIBRARYID, new MapperInfo(mLibraryIDInfo));
        this.m_htAttribToMapperInfo.put(sDEVICEID, new MapperInfo(mDeviceIDInfo));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(TapeIoport.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeIoport.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeIoport.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeIoport.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS", new MapperInfo(TapeIoport.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sELMENTNAME, new MapperInfo(TapeIoport.getColumnInfo("ELEMENT_NAME")));
        this.m_dataConverter.addSimpleDataConversion(sEXTENDED, "Boolean");
        this.m_htAttribToMapperInfo.put(sEXTENDED, new MapperInfo(TapeIoport.getColumnInfo("EXTENDED")));
        this.m_htAttribToMapperInfo.put(sCAPTION, new MapperInfo(TapeIoport.getColumnInfo("CAPTION")));
        this.m_htAttribToMapperInfo.put(sDESCRIPTION, new MapperInfo(TapeIoport.getColumnInfo("DESCRIPTION")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String opstatus;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        if (pParams.get(sDESCRIPTION) == null) {
            String mElementName = (String)pParams.get(sELMENTNAME);
            if (mElementName != null) {
                pParams.put(sDESCRIPTION, mElementName);
            } else {
                pParams.put(sDESCRIPTION, "N/A");
            }
        }
        if ((opstatus = (String)pParams.get(sOPERATIONALSTATUS)) != null) {
            Vector opArray = SMIS11CIM_LimitedAccessPortToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        MapperResult mMapperResult = super.persist(pConn, pParams, pScanID);
        mMapperResult.addKeyReference("ref_device_id", TapeIoport.getColumnInfo("DEVICE_ID"));
        mMapperResult.addKeyReference(sLIBRARYID, TapeIoport.getColumnInfo("TAPE_LIBRARY_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mMapperResult);
        return mMapperResult;
    }
}

