/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_ComputerSystem_NodeToDBMapper;

public class SMISCIM_ComputerSystem_TopLevelToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_ComputerSystem";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "15";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_ComputerSystem_TopLevelToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion("nameformat", "SMISName_Format");
        this.m_htAttribToMapperInfo.put("nameformat", new MapperInfo(StorageSubsystem.getColumnInfo("NAME_FORMAT")));
        ColumnInfo phname = StorageSubsystem.getColumnInfo("NAME");
        phname.setIsPrimaryKey();
        MapperInfo phnameMapperInfo = new MapperInfo(phname);
        ColumnInfo phIdInfo = StorageSubsystem.getColumnInfo("SUBSYSTEM_ID");
        phIdInfo.setAutoGenerated();
        phnameMapperInfo.setDerivedColumn(phIdInfo);
        this.m_htAttribToMapperInfo.put("name", phnameMapperInfo);
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(StorageSubsystem.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(StorageSubsystem.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("accessinfo", new MapperInfo(StorageSubsystem.getColumnInfo("ACCESS_INFO")));
        this.m_htAttribToMapperInfo.put("TYPE".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put("OS_TYPE".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("OS_TYPE")));
        this.m_htAttribToMapperInfo.put("SerialNumber".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("vendor", new MapperInfo(StorageSubsystem.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("model", new MapperInfo(StorageSubsystem.getColumnInfo("MODEL_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String opstatus;
        String elementname;
        String nameformat;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        if (pParams.get("ref_toplevelsystem_id") != null && pParams.get("ref_toplevelsystem_name") != null && pParams.get("ref_toplevelsystem_nameformat") != null) {
            SMISCIM_ComputerSystem_NodeToDBMapper mNodeMapper = new SMISCIM_ComputerSystem_NodeToDBMapper();
            return mNodeMapper.persist(pConn, pParams, pScanID);
        }
        String mCreationClass = (String)pParams.get("creationclassname");
        if (mCreationClass != null) {
            if (mCreationClass.indexOf("EMC") > -1 && pParams.get("OS_TYPE".toLowerCase()) == null) {
                pParams.put("TYPE".toLowerCase(), "EMC");
                pParams.put("OS_TYPE".toLowerCase(), String.valueOf(26));
            } else if (mCreationClass.toLowerCase().startsWith("sun") && pParams.get("OS_TYPE".toLowerCase()) == null) {
                pParams.put("TYPE".toLowerCase(), "SUN");
                pParams.put("OS_TYPE".toLowerCase(), String.valueOf(26));
            } else if (mCreationClass.startsWith("HP") && pParams.get("OS_TYPE".toLowerCase()) == null) {
                pParams.put("TYPE".toLowerCase(), "HP");
                pParams.put("OS_TYPE".toLowerCase(), String.valueOf(18));
            }
        }
        if (pParams.get("OS_TYPE".toLowerCase()) == null) {
            pParams.put("TYPE".toLowerCase(), "Unknown");
            pParams.put("OS_TYPE".toLowerCase(), String.valueOf(26));
        }
        if ((nameformat = (String)pParams.get("nameformat")) != null) {
            pParams.put("nameformat2", nameformat);
        }
        if ((elementname = (String)pParams.get("elementname")) == null) {
            pParams.put("elementname", pParams.get("caption"));
        }
        if ((opstatus = (String)pParams.get("operationalstatus")) != null) {
            Vector opArray = SMISCIM_ComputerSystem_TopLevelToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put("operationalstatus", opstatus);
            } else {
                pParams.remove("operationalstatus");
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        String serial = (String)pParams.get("SERIAL_NUMBER".toLowerCase());
        String genSerial = (String)pParams.get("SerialNumber");
        if (serial != null) {
            pParams.put("SerialNumber", serial);
            this.m_htAttribToMapperInfo.remove("SERIAL_NUMBER".toLowerCase());
        } else if (genSerial == null) {
            pParams.remove("SerialNumber");
        }
        MapperResult result1 = super.persist(pConn, pParams, pScanID);
        Hashtable mAllHTregCIMOM = result1.getAllRows();
        String mSSID = (String)((Hashtable)mAllHTregCIMOM.get("T_RES_STORAGE_SUBSYSTEM")).get(StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"));
        pParams.put("subsystemid", mSSID);
        SMISCimkeySubsystemToDBMapper mapper = new SMISCimkeySubsystemToDBMapper();
        MapperResult result2 = mapper.persist(pConn, pParams, pScanID);
        MapperResult returnResult = result1.addMapperResult(result2);
        returnResult.addKeyReference("ref_toplevelsystem_id", StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"));
        returnResult.addKeyReference("ref_toplevelsystem_name", StorageSubsystem.getColumnInfo("NAME"));
        returnResult.addKeyReference("ref_toplevelsystem_nameformat", StorageSubsystem.getColumnInfo("NAME_FORMAT"));
        try {
            returnResult.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"));
        }
        catch (Exception e) {
            this.logInfo(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "TopLevelSystem mapper called w/o cimom2namespace creation - Indication mapping!");
        }
        return returnResult;
    }

    private class SMISCimkeySubsystemToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeySubsystemToDBMapper() {
            ColumnInfo subsystemname = CimkeySubsystem.getColumnInfo("NAME");
            subsystemname.setIsPrimaryKey();
            MapperInfo subsystemnameMapperInfo = new MapperInfo(subsystemname);
            this.m_htAttribToMapperInfo.put("name", subsystemnameMapperInfo);
            ColumnInfo subsystemid = CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID");
            subsystemid.setIsPrimaryKey();
            MapperInfo subsystemidMapperInfo = new MapperInfo(subsystemid);
            ColumnInfo cimkeyIDInfo = CimkeySubsystem.getColumnInfo("CIMKEY_SUBSYSTEM_ID");
            cimkeyIDInfo.setAutoGenerated();
            subsystemidMapperInfo.setDerivedColumn(cimkeyIDInfo);
            this.m_htAttribToMapperInfo.put("subsystemid", subsystemidMapperInfo);
            this.m_dataConverter.addSimpleDataConversion("nameformat2", "SMISName_Format");
            this.m_htAttribToMapperInfo.put("nameformat2", new MapperInfo(CimkeySubsystem.getColumnInfo("NAME_FORMAT")));
            ColumnInfo nsid = CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID");
            nsid.setIsPrimaryKey();
            MapperInfo nsidMapperInfo = new MapperInfo(nsid);
            nsidMapperInfo.setDerivedColumn(cimkeyIDInfo);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", nsidMapperInfo);
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            Hashtable lookup = new Hashtable();
            String val = (String)pParams.get("ref_serviceurl");
            if (val != null) {
                RegisteredCimom helper = new RegisteredCimom();
                helper.setServiceUrl(val);
                boolean retval = helper.retrieve(pConn);
                if (retval) {
                    int cimomid = helper.getRegCimomId();
                    val = (String)pParams.get("ref_namespace");
                    if (val != null) {
                        Cimom2namespace helperc2n = new Cimom2namespace();
                        helperc2n.setCimomId(cimomid);
                        helperc2n.setNamespace(val);
                        retval = helperc2n.retrieve(pConn);
                        if (retval) {
                            pParams.put("cimnamespaceid", new String(helperc2n.getCimNamespaceId() + ""));
                            MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
                            return mReturnResult;
                        }
                    }
                }
            }
            MapperResult mReturnResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            return mReturnResult;
        }
    }
}

