/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_PhysicalMediaToDBMapper
extends DBAttributeMapper {
    protected static final String SERIALNUMBER = "serialnumber";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_PhysicalMedia";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_PhysicalMediaToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion("removeable", "Boolean");
        this.m_htAttribToMapperInfo.put("removeable", new MapperInfo(PhysicalVolume.getColumnInfo("REMOVABLE_MEDIUM")));
        this.m_htAttribToMapperInfo.put(SERIALNUMBER, new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_dataConverter.addCalculationDataConversion("capacity", "/", "512");
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("manufacturedate", new MapperInfo(PhysicalVolume.getColumnInfo("MANUFACTURE_DATE")));
        this.m_htAttribToMapperInfo.put("tag", new MapperInfo(PhysicalVolume.getColumnInfo("TAG")));
        this.m_htAttribToMapperInfo.put("manufacturer", new MapperInfo(PhysicalVolume.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("model", new MapperInfo(PhysicalVolume.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put("ref_diskgroup_id", new MapperInfo(PhysicalVolume.getColumnInfo("DISK_GROUP_ID")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_ID")));
        ColumnInfo phname = PhysicalVolume.getColumnInfo("DEVICE_ID");
        phname.setIsPrimaryKey();
        MapperInfo phnameMapperInfo = new MapperInfo(phname);
        ColumnInfo phIdInfo = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
        phIdInfo.setAutoGenerated();
        phnameMapperInfo.setDerivedColumn(phIdInfo);
        this.m_htAttribToMapperInfo.put("ref_physicalvolume_device_id", phnameMapperInfo);
        ColumnInfo systemName = PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID");
        systemName.setIsPrimaryKey();
        MapperInfo systemnameMapper = new MapperInfo(systemName);
        this.m_htAttribToMapperInfo.put("ref_physicalvolume_system_names_id", systemnameMapper);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mSystemNameIDRef;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String datetime = (String)pParams.get("manufacturedate");
        if (datetime != null) {
            String datetimeDB = datetime.substring(0, 4) + "-" + datetime.substring(4, 6) + "-" + datetime.substring(6, 8) + " " + datetime.substring(8, 10) + ":" + datetime.substring(10, 12) + ":" + datetime.substring(12, 14) + "." + datetime.substring(15, 21) + datetime.substring(22);
            pParams.put("manufacturedate", datetimeDB);
        }
        if ((mSystemNameIDRef = (String)pParams.get("ref_physicalvolume_system_names_id")) != null) {
            mSystemNameIDRef = Normalizer.SystemNamesGetName(pConn, Short.parseShort(mSystemNameIDRef));
            pParams.put("ref_physicalvolume_system_names_id", mSystemNameIDRef);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

