/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageCapabilitiesToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_StorageCapabilities";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mCIMClass = "IBMTSESS_StorageCapabilities";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mCIMClass = "IBMTSSVC_StorageCapabilities";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_StorageCapabilitiesToDBMapper() {
        this.m_htAttribToMapperInfo.put("dataredundancydefault", new MapperInfo(StoragePool.getColumnInfo("DATA_REDUNDANCY_DEF")));
        this.m_htAttribToMapperInfo.put("dataredundancymax", new MapperInfo(StoragePool.getColumnInfo("DATA_REDUNDANCY_MAX")));
        this.m_htAttribToMapperInfo.put("dataredundancymin", new MapperInfo(StoragePool.getColumnInfo("DATA_REDUNDANCY_MIN")));
        this.m_htAttribToMapperInfo.put("deltareservationdefault", new MapperInfo(StoragePool.getColumnInfo("DELTA_RES_DEF")));
        this.m_htAttribToMapperInfo.put("deltareservationmax", new MapperInfo(StoragePool.getColumnInfo("DELTA_RES_MAX")));
        this.m_htAttribToMapperInfo.put("deltareservationmin", new MapperInfo(StoragePool.getColumnInfo("DELTA_RES_MIN")));
        this.m_htAttribToMapperInfo.put("packageredundancydefault", new MapperInfo(StoragePool.getColumnInfo("PCK_REDUNDANCY_DEF")));
        this.m_htAttribToMapperInfo.put("packageredundancymax", new MapperInfo(StoragePool.getColumnInfo("PCK_REDUNDANCY_MAX")));
        this.m_htAttribToMapperInfo.put("packageredundancymin", new MapperInfo(StoragePool.getColumnInfo("PCK_REDUNDANCY_MIN")));
        this.m_htAttribToMapperInfo.put("RAID_LEVEL".toLowerCase(), new MapperInfo(StoragePool.getColumnInfo("RAID_LEVEL")));
        ColumnInfo instIDColumn = StoragePool.getColumnInfo("INSTANCE_ID");
        instIDColumn.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_instance_id", new MapperInfo(instIDColumn));
        ColumnInfo subsystemIDColumn = StoragePool.getColumnInfo("SUBSYSTEM_ID");
        subsystemIDColumn.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(subsystemIDColumn));
        ColumnInfo classIDColumn = StoragePool.getColumnInfo("CLASS_NAME_ID");
        classIDColumn.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_storagepool_class_id", new MapperInfo(classIDColumn));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mElementName;
        if (pParams.get("RAID_LEVEL".toLowerCase()) == null && (mElementName = (String)pParams.get("elementname")) != null && (mElementName = mElementName.toLowerCase()).startsWith("raid")) {
            pParams.put("RAID_LEVEL".toLowerCase(), mElementName);
        }
        if (pParams.get("RAID_LEVEL".toLowerCase()) == null && (mElementName = (String)pParams.get("caption")) != null && (mElementName = mElementName.toLowerCase()).startsWith("raid")) {
            pParams.put("RAID_LEVEL".toLowerCase(), mElementName);
        }
        if (pParams.get("RAID_LEVEL".toLowerCase()) == null && (mElementName = (String)pParams.get("supportedraidvalues")) != null && (mElementName = mElementName.toLowerCase()).startsWith("raid")) {
            pParams.put("RAID_LEVEL".toLowerCase(), mElementName);
        }
        if (pParams.get("RAID_LEVEL".toLowerCase()) == null && (mElementName = (String)pParams.get("description")) != null && (mElementName = mElementName.toLowerCase()).startsWith("raid")) {
            pParams.put("RAID_LEVEL".toLowerCase(), mElementName);
        }
        if ((mElementName = (String)pParams.get("RAID_LEVEL".toLowerCase())) != null) {
            String mRaid_Level = new String(" ");
            if (mElementName.indexOf("raid10") != -1) {
                mRaid_Level = "raid10 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid01") != -1) {
                mRaid_Level = "raid01 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid0") != -1 && mRaid_Level.indexOf("raid0") == -1) {
                mRaid_Level = "raid0 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid1") != -1 && mRaid_Level.indexOf("raid1") == -1) {
                mRaid_Level = "raid1 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid2") != -1) {
                mRaid_Level = "raid2 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid3") != -1) {
                mRaid_Level = "raid3 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid4") != -1) {
                mRaid_Level = "raid4 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid5") != -1) {
                mRaid_Level = "raid5 " + mRaid_Level;
            }
            if (mElementName.indexOf("raid6") != -1) {
                mRaid_Level = "raid6 " + mRaid_Level;
            }
            if (mRaid_Level.indexOf("raid") != -1) {
                pParams.put("RAID_LEVEL".toLowerCase(), mRaid_Level);
            } else {
                pParams.remove("RAID_LEVEL".toLowerCase());
            }
        }
        String classID = (String)pParams.get("ref_storagepool_class_id");
        MapperResult mReturnResult = new MapperResult();
        if (classID != null) {
            classID = Normalizer.ClassNameGetName(pConn, Short.parseShort(classID));
            pParams.put("ref_storagepool_class_id", classID);
            mReturnResult = super.persist(pConn, pParams, pScanID);
        }
        return mReturnResult;
    }
}

