/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimom2namespace;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageSubsystem;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlVolume2extent;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageVolumeToDBMapper
extends DBAttributeMapper {
    private static final String sqlUpdateBeginning = "update T_RES_STORAGE_VOLUME set ";
    private static final String sqlInsertBeginning = "insert into T_RES_STORAGE_VOLUME (";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_StorageVolume";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_StorageVolumeToDBMapper() {
        ColumnInfo ssID = StorageVolume.getColumnInfo("SUBSYSTEM_ID");
        ssID.setIsPrimaryKey();
        MapperInfo ssIDMapper = new MapperInfo(ssID);
        ColumnInfo svId = StorageVolume.getColumnInfo("SVID");
        svId.setAutoGenerated();
        ssIDMapper.setDerivedColumn(svId);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", ssIDMapper);
        ColumnInfo nameColInfo = StorageVolume.getColumnInfo("NAME");
        nameColInfo.setIsPrimaryKey();
        MapperInfo nameMapperInfo = new MapperInfo(nameColInfo);
        nameMapperInfo.setDerivedColumn(svId);
        this.m_htAttribToMapperInfo.put("name", nameMapperInfo);
        ColumnInfo nameformatColInfo = StorageVolume.getColumnInfo("NAME_FORMAT");
        nameformatColInfo.setIsPrimaryKey();
        MapperInfo nameformatMapperInfo = new MapperInfo(nameformatColInfo);
        nameformatMapperInfo.setDerivedColumn(svId);
        this.m_htAttribToMapperInfo.put("nameformat", nameformatMapperInfo);
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(StorageVolume.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put("blocksize", new MapperInfo(StorageVolume.getColumnInfo("BLOCK_SIZE")));
        this.m_htAttribToMapperInfo.put("numberofblocks", new MapperInfo(StorageVolume.getColumnInfo("NUMBER_OF_BLOCKS")));
        this.m_htAttribToMapperInfo.put("consumableblocks", new MapperInfo(StorageVolume.getColumnInfo("CONSUMABLE_BLOCKS")));
        this.m_htAttribToMapperInfo.put("DISPLAY_NAME".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(StorageVolume.getColumnInfo("ELEMENT_NAME")));
        this.m_dataConverter.addSimpleDataConversion("isbasedonunderlyingredundancy", "Boolean");
        this.m_htAttribToMapperInfo.put("isbasedonunderlyingredundancy", new MapperInfo(StorageVolume.getColumnInfo("UNDERLYING_REDUNDANCY")));
        this.m_htAttribToMapperInfo.put("throttle", new MapperInfo(StorageVolume.getColumnInfo("THROTTLE")));
        this.m_dataConverter.addCalculationDataConversion("CAPACITY".toLowerCase(), "/", "512");
        this.m_htAttribToMapperInfo.put("CAPACITY".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(StorageVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("ref_storagepool_id", new MapperInfo(StorageVolume.getColumnInfo("POOL_ID")));
    }

    private Hashtable generateMappings(DBConnection conn, Hashtable htValues) {
        Hashtable mappings = this.generateValuesHashtable(htValues);
        try {
            mappings.put(StorageVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(conn));
            mappings.put(StorageVolume.getColumnInfo("DETECTABLE"), "1");
        }
        catch (Exception e) {
            // empty catch block
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNameAndNameFormat(DBConnection conn, Hashtable htValues) throws SQLException {
        this.logEntry(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", new Object[]{conn, htValues});
        Object subsystemID = htValues.get("ref_toplevelsystem_id");
        if (subsystemID != null) {
            Statement ps = null;
            ResultSet rs = null;
            try {
                String sql = SqlStorageVolume.getQueryString(1);
                String sysNameID = (String)htValues.get("ref_system_names_id");
                if (sysNameID != null) {
                    sql = sql + " and SYSTEM_NAMES_ID = ?";
                }
                ps = conn.getConnection().prepareStatement(sql);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, CimkeyVolume.getColumnInfo("DEVICE_ID"), 1, htValues.get("deviceid"));
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), 2, subsystemID);
                if (sysNameID != null) {
                    SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), 3, sysNameID);
                }
                if ((rs = ps.executeQuery()).next()) {
                    htValues.put("name", rs.getString("NAME"));
                    htValues.put("nameformat", rs.getString("NAME_FORMAT"));
                } else {
                    this.logInfo(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", "Unable to find a name & nameformat value using query: " + sql);
                }
            }
            finally {
                if (ps != null) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore) {}
                    }
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryForSubsystemType(DBConnection conn, String subsystemID) throws SQLException {
        this.logEntry(this.myClassname, "queryForSubsystemType(DBConnection conn, String subSystemID)", new Object[]{conn, subsystemID});
        String type = null;
        if (subsystemID != null) {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = conn.getConnection().prepareStatement(SqlStorageSubsystem.getQueryString(SqlStorageSubsystem.querySubSystemType));
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), 1, subsystemID);
                rs = ps.executeQuery();
                if (rs.next()) {
                    type = rs.getString("TYPE");
                }
            }
            finally {
                if (ps != null) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore) {}
                    }
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
        this.logEntry(this.myClassname, "attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID)", new Object[]{conn, valueMappings, scanID});
        if (!(valueMappings.containsKey("NAME") && valueMappings.containsKey("NAME_FORMAT") && valueMappings.containsKey("SUBSYSTEM_ID"))) {
            throw new SQLException("Values for all three elements of the primary key -- NAME, NAME_FORMAT, and SUBSYSTEM_ID -- are required.");
        }
        StringBuffer sql = new StringBuffer(sqlInsertBeginning);
        int autoId = AutoIdentifier.getIdentifier(1, 1);
        valueMappings.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(autoId));
        Iterator i = valueMappings.keySet().iterator();
        StringBuffer tempValues = new StringBuffer("values (");
        Vector<ColumnInfo> discoveredColumns = new Vector<ColumnInfo>();
        Vector discoveredValues = new Vector();
        while (i.hasNext()) {
            ColumnInfo col = (ColumnInfo)i.next();
            sql.append(col.getName() + ",");
            tempValues.append("?,");
            discoveredColumns.add(col);
            discoveredValues.add(valueMappings.get(col));
        }
        sql.setCharAt(sql.length() - 1, ')');
        tempValues.setCharAt(tempValues.length() - 1, ')');
        sql.append(tempValues);
        PreparedStatement ps = null;
        int value = Integer.MIN_VALUE;
        try {
            ps = conn.getConnection().prepareStatement(sql.toString());
            for (int index = 0; index < discoveredColumns.size(); ++index) {
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, (ColumnInfo)discoveredColumns.elementAt(index), index + 1, discoveredValues.elementAt(index));
            }
            value = ps.executeUpdate();
            conn.commit();
            try {
                Hashtable<ColumnInfo, String> autoIDHash = new Hashtable<ColumnInfo, String>();
                autoIDHash.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(autoId));
                DetectabilityService.tableUpdated(scanID, StorageVolume.getTablename(), autoIDHash);
            }
            catch (Exception e) {
                this.logException(this.myClassname, "attemptInsert", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ignore) {}
            }
        }
        this.logExit(this.getClass().getName(), "attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID)", new Integer(value));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attemptUpdate(DBConnection conn, Hashtable valueMappings) throws SQLException {
        this.logEntry(this.myClassname, "attemptUpdate(DBConnection conn, Hashtable valueMappings)", new Object[]{conn, valueMappings});
        StringBuffer sql = new StringBuffer(sqlUpdateBeginning);
        Vector<ColumnInfo> orderedColumns = new Vector<ColumnInfo>();
        for (ColumnInfo col : valueMappings.keySet()) {
            if (col.isPrimaryKey()) continue;
            sql.append(col.getName() + " = ?,");
            orderedColumns.add(col);
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where NAME = ? and NAME_FORMAT = ? and SUBSYSTEM_ID = ?");
        PreparedStatement ps = null;
        int value = -1;
        try {
            ps = conn.getConnection().prepareStatement(sql.toString());
            int paramCounter = 1;
            for (int i = 0; i < orderedColumns.size(); ++i) {
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, (ColumnInfo)orderedColumns.get(i), paramCounter++, valueMappings);
            }
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("NAME"), paramCounter++, valueMappings);
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("NAME_FORMAT"), paramCounter++, valueMappings);
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), paramCounter++, valueMappings);
            value = ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ignore) {}
            }
        }
        this.logExit(this.getClass().getName(), "attemptUpdate(DBConnection conn, Hashtable valueMappings)", new Integer(value));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAutoId(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
        int autoID;
        block16: {
            this.logEntry(this.myClassname, "getAutoId(DBConnection conn, Hashtable valueMappings, String scanID )", new Object[]{conn, valueMappings, scanID});
            PreparedStatement ps = null;
            ResultSet rs = null;
            autoID = Integer.MIN_VALUE;
            try {
                ps = conn.getConnection().prepareStatement(SqlStorageVolume.getQueryString(2));
                int paramCounter = 1;
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("NAME"), paramCounter++, valueMappings);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("NAME_FORMAT"), paramCounter++, valueMappings);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(ps, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), paramCounter++, valueMappings);
                rs = ps.executeQuery();
                if (rs.next()) {
                    autoID = rs.getInt(1);
                    valueMappings.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(autoID));
                    conn.commit();
                    try {
                        Hashtable<ColumnInfo, String> autoIDHash = new Hashtable<ColumnInfo, String>();
                        autoIDHash.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(autoID));
                        DetectabilityService.tableUpdated(scanID, StorageVolume.getTablename(), autoIDHash);
                    }
                    catch (Exception e) {
                        this.logException(this.myClassname, "getAutoId", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                    }
                    break block16;
                }
                throw new SQLException("No row was found matching NAME = " + valueMappings.get("NAME") + "and NAME_FORMAT = " + valueMappings.get("NAME_FORMAT") + "and SUBSYSTEM_ID = " + valueMappings.get("SUBSYSTEM_ID"));
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ignore) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        this.logExit(this.getClass().getName(), "getAutoId(DBConnection conn, Hashtable valueMappings, String scanID )", new Integer(autoID));
        return autoID;
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        boolean bVolumeExists;
        String opstatus;
        this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{conn, htValues, scanID});
        String elementName = (String)htValues.get("DISPLAY_NAME".toLowerCase());
        if (elementName == null && (elementName = (String)htValues.get("elementname")) != null && elementName.length() > 0) {
            htValues.put("DISPLAY_NAME".toLowerCase(), elementName);
        }
        if ((opstatus = (String)htValues.get("operationalstatus")) != null) {
            Vector opArray = SMISCIM_StorageVolumeToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                htValues.put("operationalstatus", opstatus);
            } else {
                htValues.remove("operationalstatus");
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                htValues.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        String mName = (String)htValues.get("name");
        String mNameFormat = (String)htValues.get("nameformat");
        boolean bl = bVolumeExists = mName != null && mNameFormat != null;
        if (mName == null || mNameFormat == null) {
            this.updateNameAndNameFormat(conn, htValues);
            bVolumeExists = htValues.get("name") != null && htValues.get("nameformat") != null;
        } else {
            String capacity = (String)htValues.get("CAPACITY".toLowerCase());
            if (capacity == null) {
                try {
                    long blocksize = Long.parseLong((String)htValues.get("blocksize"));
                    long blocks = Long.parseLong((String)htValues.get("numberofblocks"));
                    capacity = Long.toString(blocksize * blocks);
                    htValues.put("CAPACITY".toLowerCase(), capacity);
                }
                catch (NumberFormatException e) {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Wasn't able to calculate Volume Capacity");
                }
                catch (Exception e) {
                    this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Wasn't able to calculate Volume Capacity");
                }
            }
        }
        if (bVolumeExists) {
            String type;
            String serialNumber = (String)htValues.get("serialnumber");
            String subSystemID = (String)htValues.get("ref_toplevelsystem_id");
            if (subSystemID != null && serialNumber == null && (type = this.queryForSubsystemType(conn, subSystemID)) != null) {
                String name;
                if (type.compareTo("DS6000") == 0 || type.compareTo("DS8000") == 0 || type.compareTo("ESS") == 0) {
                    String name2 = (String)htValues.get("name");
                    if (name2 != null) {
                        String replacementString = new String("");
                        serialNumber = name2.replaceFirst("0+", replacementString).trim();
                        htValues.put("serialnumber", serialNumber);
                    }
                } else if (type.compareTo("FAStT") == 0 && (name = (String)htValues.get("name")) != null) {
                    htValues.put("serialnumber", name);
                }
            }
            this.m_dataConverter.performDataConversion(htValues);
            Hashtable mappings = this.generateMappings(conn, htValues);
            MapperResult result = new MapperResult();
            int numRowsUpdated = this.attemptUpdate(conn, mappings);
            if (numRowsUpdated == 0) {
                this.attemptInsert(conn, mappings, scanID);
                result.addInsertedRow(StorageVolume.getTablename(), mappings);
            } else {
                this.getAutoId(conn, mappings, scanID);
                result.addUpdatedRow(StorageVolume.getTablename(), mappings);
            }
            Hashtable mAllHTregCIMOM = result.getAllRows();
            String mSVID = (String)((Hashtable)mAllHTregCIMOM.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SVID"));
            htValues.put("svid", mSVID);
            String mSSID = (String)((Hashtable)mAllHTregCIMOM.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SUBSYSTEM_ID"));
            htValues.put("ssid", mSSID);
            SMISCimkeyVolumeToDBMapper mapper = new SMISCimkeyVolumeToDBMapper();
            MapperResult result2 = mapper.persist(conn, htValues, scanID);
            MapperResult mReturnResult = result.addMapperResult(result2);
            mReturnResult.addKeyReference("ref_toplevelsystem_id", StorageVolume.getColumnInfo("SUBSYSTEM_ID"));
            mReturnResult.addKeyReference("ref_name", StorageVolume.getColumnInfo("NAME"));
            mReturnResult.addKeyReference("ref_name_format", StorageVolume.getColumnInfo("NAME_FORMAT"));
            mReturnResult.addKeyReference("ref_storagevolume_id", StorageVolume.getColumnInfo("SVID"));
            if (htValues.get("ref_storageextent_id") != null) {
                Hashtable mAllRows = mReturnResult.getAllRows();
                String mVolumeID = (String)((Hashtable)mAllRows.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SVID"));
                htValues.put("ref_storagevolume_id", mVolumeID);
                SMISVolume2ExtentToDBMapper bV2EMapper = new SMISVolume2ExtentToDBMapper();
                mReturnResult.addMapperResult(bV2EMapper.persist(conn, htValues, scanID));
            }
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            return mReturnResult;
        }
        this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "No volume for the given parameters could be found");
        return new MapperResult();
    }

    private class SMISCimkeyVolumeToDBMapper
    extends DBAttributeMapper {
        private static final String sqlUpdateBeginning = "update T_RES_CIMKEY_VOLUME set ";
        private final String SVID = "svid";
        private final String CIMNAMESPACEID = "cimnamespaceid";
        private final String SYSTEMNAME = "systemname";
        private final String CREATIONCLASSNAME = "creationclassname";
        private final String SYSTEMCREATIONCLASSNAME = "systemcreationclassname";
        private final String DEVICEID = "deviceid";

        public SMISCimkeyVolumeToDBMapper() {
            ColumnInfo svid = CimkeyVolume.getColumnInfo("VOLUME_ID");
            svid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("svid", new MapperInfo(svid));
            ColumnInfo nsid = CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID");
            nsid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("cimnamespaceid", new MapperInfo(nsid));
            this.m_htAttribToMapperInfo.put("systemname", new MapperInfo(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")));
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("deviceid", new MapperInfo(CimkeyVolume.getColumnInfo("DEVICE_ID")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getCIMNamespaceID(DBConnection conn, String serviceURL, String namespace) throws SQLException {
            this.logEntry(this.myClassname, "getCIMNamespaceID(DBConnection conn, String serviceURL, String namespace)", new Object[]{conn, serviceURL, namespace});
            int id = Integer.MIN_VALUE;
            if (serviceURL == null || namespace == null) {
                return id;
            }
            Statement ps = null;
            ResultSet rs = null;
            try {
                Hashtable<ColumnInfo, String> hash = new Hashtable<ColumnInfo, String>();
                hash.put(RegisteredCimom.getColumnInfo("SERVICE_URL"), serviceURL);
                hash.put(Cimom2namespace.getColumnInfo("NAMESPACE"), namespace);
                ps = conn.getConnection().prepareStatement(SqlCimom2namespace.getQueryString(0));
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, RegisteredCimom.getColumnInfo("SERVICE_URL"), 1, hash);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, Cimom2namespace.getColumnInfo("NAMESPACE"), 2, hash);
                rs = ps.executeQuery();
                id = rs.next() ? rs.getInt(1) : Integer.MIN_VALUE;
            }
            finally {
                if (ps != null) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore) {}
                    }
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return id;
        }

        private Hashtable generateMappings(DBConnection conn, Hashtable htValues) throws SQLException {
            String systemCCN;
            String creationCN;
            Hashtable mappings = new Hashtable();
            for (String key : htValues.keySet()) {
                MapperInfo mapping = (MapperInfo)this.m_htAttribToMapperInfo.get(key.toLowerCase());
                if (mapping == null) continue;
                mappings.put(mapping.getTargetColInfo(), htValues.get(key));
            }
            try {
                mappings.put(CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(conn));
            }
            catch (Exception e) {
                // empty catch block
            }
            String systemName = (String)htValues.get("systemname");
            if (systemName != null) {
                short id = Normalizer.SystemNamesGetID(conn, systemName);
                mappings.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(id));
            }
            if ((creationCN = (String)htValues.get("creationclassname")) != null) {
                short id = Normalizer.CreationClassNameGetID(conn, creationCN);
                mappings.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(id));
            }
            if ((systemCCN = (String)htValues.get("systemcreationclassname")) != null) {
                short id = Normalizer.SystemCreationClassNameGetID(conn, systemCCN);
                mappings.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(id));
            }
            return mappings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int attemptUpdate(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
            StringBuffer sql = new StringBuffer(sqlUpdateBeginning);
            Vector<ColumnInfo> orderedColumns = new Vector<ColumnInfo>();
            for (ColumnInfo col : valueMappings.keySet()) {
                if (col.isPrimaryKey()) continue;
                sql.append(col.getName() + " = ?,");
                orderedColumns.add(col);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" where VOLUME_ID = ? and CIM_NAMESPACE_ID = ?");
            PreparedStatement ps = null;
            int value = -1;
            try {
                ps = conn.getConnection().prepareStatement(sql.toString());
                int paramCounter = 1;
                for (int i = 0; i < orderedColumns.size(); ++i) {
                    SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, (ColumnInfo)orderedColumns.get(i), paramCounter++, valueMappings);
                }
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), paramCounter++, valueMappings);
                value = ps.executeUpdate();
                conn.commit();
                try {
                    Hashtable autoIDHash = new Hashtable();
                    DetectabilityService.tableUpdated(scanID, CimkeyVolume.getTablename(), autoIDHash);
                }
                catch (Exception e) {
                    this.logException(this.myClassname, "attemptUpdate", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
            String sql = SqlCimkeyVolume.getQueryString(0);
            PreparedStatement ps = null;
            int value = Integer.MIN_VALUE;
            try {
                ps = conn.getConnection().prepareStatement(sql);
                int paramCounter = 1;
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("DEVICE_ID"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("ACTIVE"), paramCounter++, valueMappings);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(ps, CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), paramCounter++, valueMappings);
                value = ps.executeUpdate();
                conn.commit();
                try {
                    Hashtable autoIDHash = new Hashtable();
                    DetectabilityService.tableUpdated(scanID, CimkeyVolume.getTablename(), autoIDHash);
                }
                catch (Exception e) {
                    this.logException(this.myClassname, "attemptInsert", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            return value;
        }

        public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
            this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{conn, htValues, scanID});
            int namespaceID = this.getCIMNamespaceID(conn, (String)htValues.get("ref_serviceurl"), (String)htValues.get("ref_namespace"));
            if (namespaceID != Integer.MIN_VALUE) {
                htValues.put("cimnamespaceid", String.valueOf(namespaceID));
            }
            MapperResult mr = new MapperResult();
            Hashtable valueMappings = this.generateMappings(conn, htValues);
            int rows = this.attemptUpdate(conn, valueMappings, scanID);
            if (rows == 0) {
                this.attemptInsert(conn, valueMappings, scanID);
            } else {
                mr.addUpdatedRow(CimkeyVolume.getTablename(), valueMappings);
            }
            this.logExit(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", mr);
            return mr;
        }
    }

    private class SMISVolume2ExtentToDBMapper
    extends DBAttributeMapper {
        private static final String EXTENTCOUNT = "extentcount";
        private static final String sqlUpdateBeginning = "update T_RES_VOLUME2EXTENT set ";

        public SMISVolume2ExtentToDBMapper() {
            ColumnInfo svid = Volume2extent.getColumnInfo("VOLUME_ID");
            svid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(svid));
            ColumnInfo extid = Volume2extent.getColumnInfo("STORAGE_EXTENT_ID");
            extid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(extid));
            this.m_htAttribToMapperInfo.put(EXTENTCOUNT, new MapperInfo(Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS")));
        }

        private Hashtable generateMappings(DBConnection conn, Hashtable htValues) throws SQLException {
            Hashtable mappings = this.generateValuesHashtable(htValues);
            try {
                mappings.put(CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(conn));
            }
            catch (Exception e) {
                // empty catch block
            }
            return mappings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int attemptUpdate(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
            StringBuffer sql = new StringBuffer(sqlUpdateBeginning);
            Vector<ColumnInfo> orderedColumns = new Vector<ColumnInfo>();
            for (ColumnInfo col : valueMappings.keySet()) {
                if (col.isPrimaryKey()) continue;
                sql.append(col.getName() + " = ?,");
                orderedColumns.add(col);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" where VOLUME_ID = ? and STORAGE_EXTENT_ID = ? ");
            PreparedStatement ps = null;
            int value = -1;
            try {
                ps = conn.getConnection().prepareStatement(sql.toString());
                int paramCounter = 1;
                for (int i = 0; i < orderedColumns.size(); ++i) {
                    SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, (ColumnInfo)orderedColumns.get(i), paramCounter++, valueMappings);
                }
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), paramCounter++, valueMappings);
                value = ps.executeUpdate();
                conn.commit();
                try {
                    Hashtable autoIDHash = new Hashtable();
                    DetectabilityService.tableUpdated(scanID, CimkeyVolume.getTablename(), autoIDHash);
                }
                catch (Exception e) {
                    this.logException(this.myClassname, "attemptUpdate", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
            String sql = SqlVolume2extent.getQueryString(1);
            PreparedStatement ps = null;
            int value = Integer.MIN_VALUE;
            try {
                ps = conn.getConnection().prepareStatement(sql);
                int paramCounter = 1;
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), paramCounter++, valueMappings);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS"), paramCounter++, valueMappings);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(ps, Volume2extent.getColumnInfo("UPDATE_TIMESTAMP"), paramCounter++, valueMappings);
                value = ps.executeUpdate();
                conn.commit();
                try {
                    Hashtable autoIDHash = new Hashtable();
                    DetectabilityService.tableUpdated(scanID, CimkeyVolume.getTablename(), autoIDHash);
                }
                catch (Exception e) {
                    this.logException(this.myClassname, "attemptInsert", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            return value;
        }

        public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
            this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{conn, htValues, scanID});
            MapperResult mr = new MapperResult();
            Hashtable valueMappings = this.generateMappings(conn, htValues);
            int rows = this.attemptUpdate(conn, valueMappings, scanID);
            if (rows == 0) {
                this.attemptInsert(conn, valueMappings, scanID);
            } else {
                mr.addUpdatedRow(CimkeyVolume.getTablename(), valueMappings);
            }
            this.logExit(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", mr);
            return mr;
        }
    }
}

