/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageExtentToDBMapper;

public class SMISIBMTSESS_StorageExtentToDBMapper
extends SMISCIM_StorageExtentToDBMapper {
    public static final String sSTORAGETYPE = "storagetype";
    public static final String sRANKID = "rankid";
    public static final String sARRAYIDS = "arrayids";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSESS_StorageExtent";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSESS_StorageExtentToDBMapper() {
        this.m_htAttribToMapperInfo.put("redundancy", new MapperInfo(StorageExtent.getColumnInfo("REDUNDANCY")));
        this.m_dataConverter.addSimpleDataConversion(sSTORAGETYPE, "ESS_Format");
        this.m_htAttribToMapperInfo.put(sSTORAGETYPE, new MapperInfo(StorageExtent.getColumnInfo("EXTENT_TYPE")));
        this.m_htAttribToMapperInfo.put(sRANKID, new MapperInfo(StorageExtent.getColumnInfo("RANK_ID")));
        this.m_htAttribToMapperInfo.put(sARRAYIDS, new MapperInfo(StorageExtent.getColumnInfo("ARRAY_IDS")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        MapperResult mReturnResult;
        block12: {
            String mDeviceID;
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String raid = (String)pParams.get("redundancy");
            if (raid != null) {
                if (raid.endsWith("10")) {
                    pParams.put("redundancy", "10");
                } else if (raid.endsWith("5")) {
                    pParams.put("redundancy", "5");
                } else if (raid.endsWith("1")) {
                    pParams.put("redundancy", "1");
                } else if (raid.endsWith("0")) {
                    pParams.put("redundancy", "0");
                } else {
                    pParams.remove("redundancy");
                }
            }
            if ((mDeviceID = (String)pParams.get("deviceid")) != null && !mDeviceID.startsWith("dg")) {
                pParams.put(sRANKID, mDeviceID);
            }
            mReturnResult = super.persist(pConn, pParams, pScanID);
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            String mNumOfDataDisks = (String)pParams.get("numofdatadisks");
            if (mNumOfDataDisks != null && mNumOfDataDisks.length() > 0) {
                Vector vNumOfDataDisks = SMISIBMTSESS_StorageExtentToDBMapper.processArrayvalues(mNumOfDataDisks);
                mReturnResult.addKeyReference("ref_numofdatadisks", (String)vNumOfDataDisks.firstElement());
            }
            String mRankGroup = (String)pParams.get("rankgroup");
            String mPoolID = (String)pParams.get("ref_storagepool_id");
            if (mRankGroup == null || mRankGroup.length() <= 0 || mPoolID == null) break block12;
            Hashtable<ColumnInfo, String> mWherePoolID = new Hashtable<ColumnInfo, String>();
            Vector<String> bColumns = new Vector<String>();
            bColumns.add("INSTANCE_ID");
            bColumns.add("SUBSYSTEM_ID");
            bColumns.add("CLASS_NAME_ID");
            mWherePoolID.put(TResStoragePoolTable.getColumnInfo("POOL_ID"), mPoolID);
            DBResultSet resultSet = DBQueryAssistant.performRetrieve(TResStoragePoolTable.getTablename(), pConn, mWherePoolID, bColumns);
            if (resultSet.next()) {
                StoragePool mPool = new StoragePool();
                mPool.setInstanceId(resultSet.getString("INSTANCE_ID"));
                mPool.setSubsystemId(resultSet.getInt("SUBSYSTEM_ID"));
                mPool.setClassNameId(resultSet.getShort("CLASS_NAME_ID"));
                mPool.setRankGroup(Short.parseShort(mRankGroup));
                mPool.update(pConn);
                resultSet.closeAll();
            }
        }
        return mReturnResult;
    }
}

