/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.jobs;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.aperi.agent.req.RunReq;

public class JobUtils {
    private static NumberFormat schedRunFormat = new DecimalFormat("0000");
    private static NumberFormat jobRunFormat = new DecimalFormat("00000000");

    public static String generateLogFileName(RunReq run, String directory) {
        return JobUtils.generateLogFileName(run.getSchedCreator(), run.getSchedName(), run.getSchedRunNumber(), run.getJobName(), run.getRunNumber(), directory);
    }

    public static String generateLogFileName(String schedCreator, String schedName, int schedRunNumber, String jobName, int runNumber, String directory) {
        StringBuffer buf = new StringBuffer();
        if (directory != null) {
            buf.append(directory);
            buf.append(File.separatorChar);
        }
        buf.append(schedCreator);
        buf.append('.');
        buf.append(schedName);
        buf.append('.');
        buf.append(schedRunFormat.format(schedRunNumber));
        buf.append('_');
        buf.append(jobName);
        buf.append('.');
        buf.append(jobRunFormat.format(runNumber));
        buf.append(".log");
        return buf.toString();
    }
}

