/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.LogConfigRequest;
import org.eclipse.aperi.logging.NativeLogManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class LogConfigHandler {
    public static void handle(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogConfigHandler.class.getName(), "handle", "request, response");
        }
        if (RequestChecker.isDesiredType(LogConfigRequest.class, request, response)) {
            LogConfigRequest data = (LogConfigRequest)request.requestData;
            try {
                if (data.doSet) {
                    TraceLoggerFactory.setTraceConfig(data.configMap, data.requestCode);
                    NativeLogManager.setTraceConfig(data.configMap, data.requestCode);
                } else {
                    response.responseData = TraceLoggerFactory.getTraceConfig(data.requestCode);
                }
                response.status = 0;
            }
            catch (LocalizableException exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(LogConfigHandler.class.getName(), "handle", exception);
                }
                response.errorMessage = exception.getMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogConfigHandler.class.getName(), "handle");
        }
    }
}

