/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.aperi.common.ConfigParser;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class NativeLogManager {
    private static PrintWriter writer;
    public static final String CONFIG_FILENAME;
    public static final String SERVER_CONFIG;
    public static final String INS_CNAME = "Install";
    public static final String AGT_CNAME = "Agent";
    public static final String SRV_CNAME = "Server";
    public static final String AGT_STOP_CNAME = "StopAgent";
    public static final String SRV_STOP_CNAME = "StopServer";
    public static final String IMPEXP_CNAME = "ImportExport";
    public static final String INS_PREFIX = "ins";
    public static final String AGT_PREFIX = "agt";
    public static final String SRV_PREFIX = "srv";
    public static final String AGT_STOP_PREFIX = "stpagt";
    public static final String SRV_STOP_PREFIX = "stpsrv";
    public static final String IMPEXP_PREFIX = "impexp";
    public static final String PREFIX = "traceTPCDNative";
    public static final String LOG_EXT = ".LOG";
    public static final String AGT_TRC_FNAME = "traceTPCDNativeAgent";
    public static final String SRV_TRC_FNAME = "traceTPCDNativeServer";
    public static final String AGT_STOP_TRC_FNAME = "traceTPCDNativeStopAgent";
    public static final String SRV_STOP_TRC_FNAME = "traceTPCDNativeStopServer";
    public static final String IMPEXP_TRC_FNAME = "traceTPCDNativeImportExport";
    public static final String ENABLE_FLAG = "enableFlag";
    public static final String LEVEL = "level";
    public static final String FILENAME = "fileName";
    public static final String MAX_FILES = "maxFiles";
    public static final String MAX_FILE_SIZE = "maxFileSize";
    private static final int L_CODE = 0;
    private static final int MF_CODE = 1;
    private static final int MFS_CODE = 2;
    public static final String DEBUG_MIN = "DEBUG_MIN";
    public static final String DEBUG_MID = "DEBUG_MID";
    public static final String DEBUG_MAX = "DEBUG_MAX";
    public static final int MIN_MAX_FILES = 2;
    public static final int MAX_MAX_FILES = 100;
    public static final int MAX_FILES_INCREMENT = 1;
    public static final int MIN_MAX_FILE_SIZE = 128000;
    public static final int MAX_MAX_FILE_SIZE = 102400000;
    public static final int MAX_FILE_SIZE_INCREMENT = 128000;
    private static String installDebugLevel;
    private static String[][] configParms;

    public static native String getDefaultTraceLevel() throws LocalizableException;

    public static native String getDefaultTraceMaxFiles() throws LocalizableException;

    public static native String getDefaultTraceMaxFileSize() throws LocalizableException;

    private static native void initToolkit(String var0, String var1, String var2) throws LocalizableException;

    private static native void initTraceLogger(String var0, String var1) throws LocalizableException;

    private static void initToolkit(String componentPrefix) throws LocalizableException {
        String mfsProperty;
        String mfProperty;
        String lProperty;
        Properties config;
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(NativeLogManager.class.getName(), "initToolkit", "componentPrefix");
            }
            config = new Properties();
            lProperty = componentPrefix + "." + LEVEL;
            mfProperty = componentPrefix + "." + MAX_FILES;
            mfsProperty = componentPrefix + "." + MAX_FILE_SIZE;
            try {
                String directory = System.getProperty("user.dir") + File.separator;
                String configFile = directory + CONFIG_FILENAME;
                config.load(new FileInputStream(configFile));
            }
            catch (IOException ioException) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception(NativeLogManager.class.getName(), "initToolkit", ioException);
            }
        }
        NativeLogManager.initToolkit(componentPrefix.indexOf(INS_PREFIX) != -1 ? NativeLogManager.getConfigProperty(config, lProperty, 0, NativeLogManager.getInstallTraceLevel()) : NativeLogManager.getConfigProperty(config, lProperty, 0, NativeLogManager.getDefaultTraceLevel()), NativeLogManager.getConfigProperty(config, mfProperty, 1, NativeLogManager.getDefaultTraceMaxFiles()), NativeLogManager.getConfigProperty(config, mfsProperty, 2, NativeLogManager.getDefaultTraceMaxFileSize()));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initToolkit");
        }
    }

    private static String getConfigProperty(Properties config, String property, int propertyCode, String defaultValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getConfigProperty", "config, property, propertyCode, defaultValue");
        }
        String value = null;
        if (property.indexOf(INS_PREFIX) != -1) {
            if (NativeLogManager.getInstallTraceLevel() == DEBUG_MAX) {
                MessageLog.logMessage("GEN2009W", property, defaultValue);
            }
            String traceResult = defaultValue;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", traceResult);
            }
            return traceResult;
        }
        value = config.getProperty(property);
        if (value == null) {
            MessageLog.logMessage("GEN2009W", property, defaultValue);
            String traceResult = defaultValue;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", traceResult);
            }
            return traceResult;
        }
        String traceResult = NativeLogManager.checkValue(property, propertyCode, value, defaultValue);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", traceResult);
        }
        return traceResult;
    }

    private static String checkValue(String property, int propertyCode, String value, String defaultValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkValue", "property, propertyCode, value, defaultValue");
        }
        String finalValue = null;
        switch (propertyCode) {
            case 0: {
                finalValue = NativeLogManager.checkLevelValue(property, value, defaultValue);
                break;
            }
            case 1: {
                finalValue = NativeLogManager.checkMaxFilesValue(property, value, defaultValue);
                break;
            }
            case 2: {
                finalValue = NativeLogManager.checkMaxFileSizeValue(property, value, defaultValue);
            }
        }
        String traceResult = finalValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkValue", traceResult);
        }
        return traceResult;
    }

    private static String checkLevelValue(String lProperty, String lValue, String defaultLValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkLevelValue", "lProperty, lValue, defaultLValue");
        }
        if (lValue.equals(DEBUG_MIN) || lValue.equals(DEBUG_MID) || lValue.equals(DEBUG_MAX)) {
            String traceResult = lValue;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "checkLevelValue", traceResult);
            }
            return traceResult;
        }
        MessageLog.logMessage("GEN2010W", lProperty, lValue, defaultLValue);
        String traceResult = defaultLValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkLevelValue", traceResult);
        }
        return traceResult;
    }

    private static String checkMaxFilesValue(String mfProperty, String mfValue, String defaultMfValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkMaxFilesValue", "mfProperty, mfValue, defaultMfValue");
        }
        try {
            int maxFiles = Integer.parseInt(mfValue);
            if (maxFiles >= 2 && maxFiles <= 100) {
                String traceResult = mfValue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFilesValue", traceResult);
                }
                return traceResult;
            }
            MessageLog.logMessage("GEN2011W", mfProperty, mfValue, defaultMfValue);
        }
        catch (NumberFormatException exception) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "checkMaxFilesValue", exception);
            }
            MessageLog.logMessage("GEN2010W", mfProperty, mfValue, defaultMfValue);
        }
        String traceResult = defaultMfValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFilesValue", traceResult);
        }
        return traceResult;
    }

    private static String checkMaxFileSizeValue(String mfsProperty, String mfsValue, String defaultMfsValue) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkMaxFileSizeValue", "mfsProperty, mfsValue, defaultMfsValue");
        }
        try {
            int maxFileSize = Integer.parseInt(mfsValue);
            if (maxFileSize >= 128000 && maxFileSize <= 102400000) {
                String traceResult = mfsValue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFileSizeValue", traceResult);
                }
                return traceResult;
            }
            MessageLog.logMessage("GEN2011W", mfsProperty, mfsValue, defaultMfsValue);
        }
        catch (NumberFormatException execption) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "checkMaxFileSizeValue", execption);
            }
            MessageLog.logMessage("GEN2010W", mfsProperty, mfsValue, defaultMfsValue);
        }
        String traceResult = defaultMfsValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFileSizeValue", traceResult);
        }
        return traceResult;
    }

    public static void reInitInstallTraceLogger(String directory) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "reInitInstallTraceLogger", "directory");
        }
        NativeLogManager.setInstallTraceLevel(NativeLogManager.getInstallTraceLevel());
        NativeLogManager.initToolkit(INS_PREFIX);
        NativeLogManager.initTraceLogger(directory + File.separator + PREFIX + INS_CNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, INS_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "reInitInstallTraceLogger");
        }
    }

    public static void initInstallTraceLogger(String level) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initInstallTraceLogger", LEVEL);
        }
        System.loadLibrary("DataLog");
        NativeLogManager.setInstallTraceLevel(level);
        NativeLogManager.initToolkit(INS_PREFIX);
        NativeLogManager.initTraceLogger(NativeLogManager.getInstallLogDirectory() + PREFIX + INS_CNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, INS_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initInstallTraceLogger");
        }
    }

    private static void setInstallTraceLevel(String level) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setInstallTraceLevel", LEVEL);
        }
        installDebugLevel = level != null ? level : DEBUG_MIN;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setInstallTraceLevel");
        }
    }

    public static String getInstallTraceLevel() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getInstallTraceLevel", "");
        }
        if (installDebugLevel != null) {
            String traceResult = installDebugLevel;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getInstallTraceLevel", traceResult);
            }
            return traceResult;
        }
        String traceResult = DEBUG_MIN;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getInstallTraceLevel", traceResult);
        }
        return traceResult;
    }

    public static void initAgentTraceLogger(String agentLogDirectory) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initAgentTraceLogger", "agentLogDirectory");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(AGT_PREFIX);
        NativeLogManager.initTraceLogger(agentLogDirectory + File.separator + AGT_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, AGT_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initAgentTraceLogger");
        }
    }

    public static void initStopAgentTraceLogger() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initStopAgentTraceLogger", "");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(AGT_STOP_PREFIX);
        NativeLogManager.initTraceLogger(NativeLogManager.getAgentLogDirectory() + "/" + AGT_STOP_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, AGT_STOP_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initStopAgentTraceLogger");
        }
    }

    private static String getAgentLogDirectory() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getAgentLogDirectory", "");
        }
        String traceResult = NativeLogManager.getServerLogDirectory() + "/" + HardwareID.getLocalHostName();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getAgentLogDirectory", traceResult);
        }
        return traceResult;
    }

    public static void initServerTraceLogger() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initServerTraceLogger", "");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(SRV_PREFIX);
        NativeLogManager.initTraceLogger(NativeLogManager.getServerLogDirectory() + "/" + SRV_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, SRV_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initServerTraceLogger");
        }
    }

    public static void initStopServerTraceLogger() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initStopServerTraceLogger", "");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(SRV_STOP_PREFIX);
        NativeLogManager.initTraceLogger(NativeLogManager.getServerLogDirectory() + "/" + SRV_STOP_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, SRV_STOP_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initStopServerTraceLogger");
        }
    }

    public static void initImportExportTraceLogger() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initImportExportTraceLogger", "");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(IMPEXP_PREFIX);
        NativeLogManager.initTraceLogger(NativeLogManager.getServerLogDirectory() + "/" + IMPEXP_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, IMPEXP_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initImportExportTraceLogger");
        }
    }

    private static String getTimeDateStamp() {
        String today;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTimeDateStamp", "");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String traceResult = today = "_" + formatter.format(new Date()) + "LOG";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTimeDateStamp", traceResult);
        }
        return traceResult;
    }

    private static String getInstallLogDirectory() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getInstallLogDirectory", "");
        }
        String installDir = System.getProperty("java.io.tmpdir");
        installDir.replace('\\', '/');
        if (!installDir.substring(installDir.length() - 1).equals("/")) {
            installDir = installDir + "/";
        }
        String traceResult = installDir;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getInstallLogDirectory", traceResult);
        }
        return traceResult;
    }

    private static String getServerLogDirectory() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getServerLogDirectory", "");
        }
        String traceResult = System.getProperty("user.dir").replace('\\', '/') + "/log";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getServerLogDirectory", traceResult);
        }
        return traceResult;
    }

    public static HashMap getTraceConfig() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTraceConfig", "");
        }
        HashMap<String, String> traceConfig = new HashMap<String, String>();
        traceConfig.put(LEVEL, NativeLogManager.getTraceLoggerProperty(LEVEL));
        traceConfig.put(FILENAME, NativeLogManager.getTraceHandlerProperty(FILENAME));
        traceConfig.put(MAX_FILES, NativeLogManager.getTraceHandlerProperty(MAX_FILES));
        traceConfig.put(MAX_FILE_SIZE, NativeLogManager.getTraceHandlerProperty(MAX_FILE_SIZE));
        HashMap<String, String> traceResult = traceConfig;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTraceConfig", traceResult);
        }
        return traceResult;
    }

    public static void setTraceConfig(HashMap traceConfig, String requestCode) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setTraceConfig", "traceConfig, requestCode");
        }
        HashMap backupConfig = NativeLogManager.getTraceConfig();
        try {
            NativeLogManager.setTraceConfig((String)traceConfig.get(LEVEL), (String)traceConfig.get(MAX_FILES), (String)traceConfig.get(MAX_FILE_SIZE));
            NativeLogManager.updateNativeLogConfig(traceConfig, requestCode);
        }
        catch (LocalizableException exception) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "setTraceConfig", exception);
            }
            try {
                NativeLogManager.setTraceConfig((String)backupConfig.get(LEVEL), (String)backupConfig.get(MAX_FILES), (String)backupConfig.get(MAX_FILE_SIZE));
            }
            catch (LocalizableException ignoredException) {
                // empty catch block
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
            }
            throw exception;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
        }
    }

    private static void setTraceConfig(String level, String maxFiles, String maxFileSize) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setTraceConfig", "level, maxFiles, maxFileSize");
        }
        NativeLogManager.setTraceLoggerProperty(LEVEL, level);
        NativeLogManager.setTraceHandlerProperty(MAX_FILES, maxFiles);
        NativeLogManager.setTraceHandlerProperty(MAX_FILE_SIZE, maxFileSize);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
        }
    }

    public static String getTraceLoggerFilename() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTraceLoggerFilename", "");
        }
        String traceFilename = NativeLogManager.getTraceHandlerProperty(FILENAME);
        String traceResult = traceFilename.replace('/', File.separatorChar);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTraceLoggerFilename", traceResult);
        }
        return traceResult;
    }

    public static void updateNativeLogConfig(HashMap traceConfig, String requestCode) throws LocalizableException {
        String configFile;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "updateNativeLogConfig", "traceConfig, requestCode");
        }
        if (requestCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            String homeDir = Variables.homeDirectory;
            configFile = homeDir + File.separator + CONFIG_FILENAME;
        } else {
            configFile = CONFIG_FILENAME;
        }
        ConfigParser ap = new ConfigParser(configFile);
        try {
            ap.readValues(configParms);
            writer = new PrintWriter(new BufferedWriter(new FileWriter(configFile)));
            writer.println("# level: DEBUG_MIN || DEBUG_MID || DEBUG_MAX");
            writer.println("# maxFiles: >= 2 && <= 100");
            writer.println("# maxFileSize: >= 128000 && <= 102400000");
            writer.println();
            Boolean b = (Boolean)traceConfig.get(ENABLE_FLAG);
            String logLevel = b != false ? (String)traceConfig.get(LEVEL) : DEBUG_MIN;
            String maxFiles = (String)traceConfig.get(MAX_FILES);
            String maxNumFiles = (String)traceConfig.get(MAX_FILE_SIZE);
            if (requestCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
                NativeLogManager.configParms[0][1] = logLevel;
                NativeLogManager.configParms[1][1] = maxFiles;
                NativeLogManager.configParms[2][1] = maxNumFiles;
            } else if (requestCode.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
                NativeLogManager.configParms[3][1] = logLevel;
                NativeLogManager.configParms[4][1] = maxFiles;
                NativeLogManager.configParms[5][1] = maxNumFiles;
            }
            if (configParms[0][1] != null) {
                NativeLogManager.printComponentValues(writer, AGT_CNAME, AGT_PREFIX, configParms[0][1], configParms[1][1], configParms[2][1]);
            }
            if (configParms[3][1] != null) {
                NativeLogManager.printComponentValues(writer, SRV_CNAME, SRV_PREFIX, configParms[3][1], configParms[4][1], configParms[5][1]);
            }
            if (configParms[6][1] != null) {
                NativeLogManager.printComponentValues(writer, IMPEXP_CNAME, IMPEXP_PREFIX, configParms[6][1], configParms[7][1], configParms[8][1]);
            }
            if (configParms[9][1] != null) {
                NativeLogManager.printComponentValues(writer, AGT_STOP_CNAME, AGT_STOP_PREFIX, configParms[9][1], configParms[10][1], configParms[11][1]);
            }
            if (configParms[12][1] != null) {
                NativeLogManager.printComponentValues(writer, SRV_STOP_CNAME, SRV_STOP_PREFIX, configParms[12][1], configParms[13][1], configParms[14][1]);
            }
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "updateNativeLogConfig", e);
            }
            String errMsg = MessageLog.getMessage("GEN2018E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "updateNativeLogConfig");
            }
            throw new LocalizableException(errMsg, null);
        }
        finally {
            writer.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "updateNativeLogConfig");
        }
    }

    private static void printComponentValues(PrintWriter writer, String name, String prefix, String lvl, String maxfiles, String maxfs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "printComponentValues", "writer, name, prefix, lvl, maxfiles, maxfs");
        }
        writer.println("# " + name);
        Util.printKeyValuePair(writer, prefix + "." + LEVEL, lvl);
        Util.printKeyValuePair(writer, prefix + "." + MAX_FILES, maxfiles);
        Util.printKeyValuePair(writer, prefix + "." + MAX_FILE_SIZE, maxfs);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "printComponentValues");
        }
    }

    public static String updateTraceLoggerFilename(String directory) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "updateTraceLoggerFilename", "directory");
        }
        String oldTraceFilename = NativeLogManager.getTraceHandlerProperty(FILENAME);
        File oldTraceFile = new File(oldTraceFilename);
        NativeLogManager.setTraceHandlerProperty(FILENAME, directory.replace('\\', '/') + "/" + oldTraceFile.getName());
        String traceResult = oldTraceFilename.replace('/', File.separatorChar);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "updateTraceLoggerFilename", traceResult);
        }
        return traceResult;
    }

    private static native String getTraceLoggerProperty(String var0) throws LocalizableException;

    private static native String getTraceHandlerProperty(String var0) throws LocalizableException;

    private static native void setTraceLoggerProperty(String var0, String var1) throws LocalizableException;

    private static native void setTraceHandlerProperty(String var0, String var1) throws LocalizableException;

    public static void executeTracePropertyTest() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "executeTracePropertyTest", "");
        }
        try {
            HashMap configMap = NativeLogManager.getTraceConfig();
            System.err.println("level:       " + configMap.get(LEVEL));
            System.err.println("maxFiles:    " + configMap.get(MAX_FILES));
            System.err.println("maxFileSize: " + configMap.get(MAX_FILE_SIZE));
            System.err.println("fileName:    " + NativeLogManager.getTraceHandlerProperty(FILENAME));
            String oldLevel = configMap.put(LEVEL, DEBUG_MAX);
            String oldMaxFiles = configMap.put(MAX_FILES, "10");
            String oldMaxFileSize = configMap.put(MAX_FILE_SIZE, "1024000");
            NativeLogManager.setTraceConfig(configMap, "org.eclipse.aperi.agent.svp.AgentSvp");
            configMap = NativeLogManager.getTraceConfig();
            System.err.println("level:       " + configMap.get(LEVEL));
            System.err.println("maxFiles:    " + configMap.get(MAX_FILES));
            System.err.println("maxFileSize: " + configMap.get(MAX_FILE_SIZE));
            configMap.put(LEVEL, oldLevel);
            configMap.put(MAX_FILES, oldMaxFiles);
            configMap.put(MAX_FILE_SIZE, oldMaxFileSize);
            NativeLogManager.setTraceConfig(configMap, "org.eclipse.aperi.agent.svp.AgentSvp");
        }
        catch (LocalizableException exception) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "executeTracePropertyTest", exception);
            }
            exception.print();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "executeTracePropertyTest");
        }
    }

    public static native void executeTraceMacroTest();

    static {
        CONFIG_FILENAME = "configuration" + File.separator + "nativelog.config";
        SERVER_CONFIG = "configuration" + File.separator + "server.config";
        configParms = new String[][]{{"agt.level", null}, {"agt.maxFiles", null}, {"agt.maxFileSize", null}, {"srv.level", null}, {"srv.maxFiles", null}, {"srv.maxFileSize", null}, {"impexp.level", null}, {"impexp.maxFiles", null}, {"impexp.maxFileSize", null}, {"stpagt.level", null}, {"stpagt.maxFiles", null}, {"stpagt.maxFileSize", null}, {"stpsrv.level", null}, {"stpsrv.maxFiles", null}, {"stpsrv.maxFileSize", null}};
    }
}

