/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class Transform {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean putTransformed(String input, String fileName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "putTransformed", "input, fileName");
        }
        BufferedWriter writer = null;
        String output = Transform.stringToHex(Transform.transformString(input));
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(output, 0, output.length());
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(Transform.class.getName(), "putTransformed", e);
            }
            MessageLog.logException("SRV0065E", (Exception)e, fileName);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(Transform.class.getName(), "putTransformed", traceResult);
            }
            boolean bl = traceResult;
            return bl;
        }
        finally {
            block17: {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(Transform.class.getName(), "putTransformed", e);
                    }
                }
            }
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "putTransformed", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTransformed(String fileName) {
        String traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "getTransformed", "fileName");
        }
        BufferedReader reader = null;
        String input = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            input = reader.readLine();
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(Transform.class.getName(), "getTransformed", e);
            }
            MessageLog.logException("SRV0066E", (Exception)e, fileName);
        }
        finally {
            block18: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception(Transform.class.getName(), "getTransformed", e);
                    }
                }
            }
        }
        if (input == null) {
            traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(Transform.class.getName(), "getTransformed", traceResult);
            }
            return traceResult;
        }
        traceResult = Transform.transformString(Transform.hexToString(input));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "getTransformed", traceResult);
        }
        return traceResult;
    }

    public static String transformString(String input) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "transformString", "input");
        }
        long pattern1 = 7941439903471721695L;
        long pattern2 = -1565980515881497136L;
        StringBuffer output = new StringBuffer(input);
        Transform.applyPattern(pattern1, output);
        Transform.applyPattern(pattern2, output);
        String traceResult = output.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "transformString", traceResult);
        }
        return traceResult;
    }

    private static void applyPattern(long patternIn, StringBuffer buffer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "applyPattern", "patternIn, buffer");
        }
        long pattern = patternIn;
        for (int i = 0; i < buffer.length(); ++i) {
            if (pattern == 0L) {
                pattern = patternIn;
            }
            buffer.setCharAt(i, (char)((long)buffer.charAt(i) ^ pattern & 0xFFL));
            pattern >>= 8;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "applyPattern");
        }
    }

    private static String stringToHex(String charString) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "stringToHex", "charString");
        }
        StringBuffer output = new StringBuffer(32);
        for (int i = 0; i < charString.length(); ++i) {
            char c = charString.charAt(i);
            if (c < '\u0010') {
                output.append('0');
            }
            output.append(Integer.toHexString(c));
        }
        String traceResult = output.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "stringToHex", traceResult);
        }
        return traceResult;
    }

    private static String hexToString(String hexString) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "hexToString", "hexString");
        }
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < hexString.length(); i += 2) {
            char c = (char)Integer.parseInt(hexString.substring(i, i + 2), 16);
            output.append(c);
        }
        String traceResult = output.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "hexToString", traceResult);
        }
        return traceResult;
    }

    public static void main(String[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transform.class.getName(), "main", "args");
        }
        if (args[0].equals("-p")) {
            boolean status = Transform.putTransformed(args[1], args[2]);
            if (status) {
                System.out.println("Succeeded!");
            } else {
                System.out.println("Failed!");
            }
        } else {
            String transformed = Transform.getTransformed(args[1]);
            System.out.println(transformed);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transform.class.getName(), "main");
        }
    }
}

