/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class LimitedWaitOutputStream
extends OutputStream
implements Runnable {
    private static final String THREAD_NAME = "IO Prodder";
    private static IORequest requestHead;
    private static IORequest requestTail;
    private static Thread thread;
    private boolean shutdown = false;
    private static IORequest inProgress;
    private OutputStream real;
    private boolean timedOut;
    private boolean tooLate;
    private boolean awaitingCancel;
    private long timeout;

    private LimitedWaitOutputStream() {
        this.real = null;
    }

    public LimitedWaitOutputStream(OutputStream pReal, int timeoutInSeconds) {
        this.real = pReal;
        if (this.real == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "LimitedWaitOutputStream");
            }
            throw new RuntimeException("LimitedWaitOutputStream(): NULL passed");
        }
        this.timedOut = false;
        this.tooLate = false;
        this.awaitingCancel = true;
        this.timeout = timeoutInSeconds;
        this.timeout *= 1000L;
    }

    private static synchronized void enqueue(IORequest request) {
        if (requestTail == null) {
            requestHead = request;
        } else {
            LimitedWaitOutputStream.requestTail.next = request;
        }
        requestTail = request;
        LimitedWaitOutputStream.class.notify();
    }

    private synchronized void notifyWaiter(boolean pTooLate) {
        this.tooLate = pTooLate;
        this.awaitingCancel = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCancelAndWait() throws LocalizableException {
        LimitedWaitOutputStream.enqueue(new IORequest(this, -1L));
        LimitedWaitOutputStream limitedWaitOutputStream = this;
        synchronized (limitedWaitOutputStream) {
            while (this.awaitingCancel) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignored) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(LimitedWaitOutputStream.class.getName(), "queueCancelAndWait", ignored);
                }
            }
        }
        if (this.tooLate) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "queueCancelAndWait");
            }
            throw new LocalizableException("GEN0556E", null);
        }
    }

    private static void cancel(LimitedWaitOutputStream stream) {
        IORequest prev = null;
        IORequest current = inProgress;
        while (current != null && current.stream != stream) {
            prev = current;
            current = current.next;
        }
        if (current != null) {
            if (prev == null) {
                inProgress = current.next;
            } else {
                prev.next = current.next;
            }
        }
        stream.notifyWaiter(current == null);
    }

    private static void insert(IORequest request, long now) {
        request.time += now;
        IORequest prev = null;
        IORequest current = inProgress;
        while (current != null && current.time < request.time) {
            prev = current;
            current = current.next;
        }
        if (prev == null) {
            inProgress = request;
        } else {
            prev.next = request;
        }
        request.next = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LimitedWaitOutputStream.class.getName(), "run", "");
        }
        if (this.real != null) {
            if (!TraceLogger.enableTrace) throw new RuntimeException("LimitedWaitOutputStream.run() called illegally!");
            TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "run");
            throw new RuntimeException("LimitedWaitOutputStream.run() called illegally!");
        }
        long toWait = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        while (!this.shutdown) {
            IORequest localHead = null;
            long then = now;
            Class<LimitedWaitOutputStream> clazz = LimitedWaitOutputStream.class;
            // MONITORENTER : org.eclipse.aperi.request.LimitedWaitOutputStream.class
            while (requestHead == null && toWait > 0L) {
                block17: {
                    try {
                        LimitedWaitOutputStream.class.wait(toWait);
                        if (this.shutdown) {
                            // MONITOREXIT : clazz
                            return;
                        }
                    }
                    catch (InterruptedException ignored) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(LimitedWaitOutputStream.class.getName(), "run", ignored);
                    }
                }
                now = System.currentTimeMillis();
                toWait -= now - then;
                then = now;
            }
            localHead = requestHead;
            requestHead = null;
            requestTail = null;
            // MONITOREXIT : clazz
            while (localHead != null) {
                IORequest next = localHead.next;
                if (localHead.time < 0L) {
                    LimitedWaitOutputStream.cancel(localHead.stream);
                } else {
                    LimitedWaitOutputStream.insert(localHead, now);
                }
                localHead = next;
            }
            while (inProgress != null && LimitedWaitOutputStream.inProgress.time <= now) {
                LimitedWaitOutputStream.inProgress.stream.timedOut = true;
                try {
                    LimitedWaitOutputStream.inProgress.stream.real.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(LimitedWaitOutputStream.class.getName(), "run", e);
                    }
                    MessageLog.logException("GEN0168E", e);
                }
                inProgress = LimitedWaitOutputStream.inProgress.next;
            }
            if (inProgress == null) {
                toWait = Long.MAX_VALUE;
                continue;
            }
            toWait = LimitedWaitOutputStream.inProgress.time - now;
        }
    }

    public void write(byte[] array, int offset, int length) throws LocalizableException {
        IOException caught = null;
        try {
            LimitedWaitOutputStream.enqueue(new IORequest(this, this.timeout));
            this.real.write(array, offset, length);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(LimitedWaitOutputStream.class.getName(), "write", e);
            }
            caught = e;
        }
        if (this.timedOut) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "write");
            }
            throw new LocalizableException("GEN0164E", null);
        }
        this.queueCancelAndWait();
        if (caught != null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "write");
            }
            throw new NestableException("GEN0166E", null, caught);
        }
    }

    public void write(byte[] array) throws LocalizableException {
        this.write(array, 0, array.length);
    }

    public void write(int b) throws LocalizableException {
        byte[] array = new byte[]{(byte)b};
        this.write(array, 0, 1);
    }

    public void close() throws LocalizableException {
        try {
            this.real.close();
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(LimitedWaitOutputStream.class.getName(), "close", e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(LimitedWaitOutputStream.class.getName(), "close");
            }
            throw new NestableException("GEN0168E", null, e);
        }
    }

    static {
        thread = null;
        requestHead = null;
        requestTail = null;
        inProgress = null;
        thread = new TSThread(new LimitedWaitOutputStream(), THREAD_NAME);
        thread.setDaemon(true);
        thread.start();
    }

    private static class IORequest {
        public IORequest next;
        public long time;
        public LimitedWaitOutputStream stream;

        public IORequest(LimitedWaitOutputStream pStream, long pTime) {
            this.stream = pStream;
            this.time = pTime;
        }
    }
}

