/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import com.ibm.log.util.MessageCatalog;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.apache.soap.SOAPException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;

public class Cli {
    protected static transient ILogger msgLogger = null;
    protected static transient ILogger traceLogger = null;
    static String url = null;
    static final String TRACE_NAME = "aperi.logger.trace.TSNMServiceManager";
    static final String MESSAGE_NAME = "aperi.logger.message.TSNMServiceManager";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManagerText";
    MessageCatalog MsgCat = new MessageCatalog("org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager");
    static final String PROTOCOL_ERROR = "SOAP-ENV:Protocol";
    static final String CLIENT_ERROR = "SOAP-ENV:Client";
    static final String AUTH_FAILED = "HTTP Status 401";
    static final String CONNECTION_FAILED = "Error opening socket: Connection refused: connect";

    public static void main(String[] args) {
        String methodName = "main";
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(BUNDLENAME);
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, Cli.class, "main");
        }
        Cli cli = new Cli();
        cli.execute(args);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, Cli.class, "main");
        }
    }

    public void execute(String[] args) {
        block22: {
            String username = null;
            String password = null;
            boolean debug = false;
            String methodName = "execute";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, this, "execute");
            }
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                String arg;
                if ((arg = args[i++]).equals("-debug") | arg.equals("-d")) {
                    debug = true;
                    continue;
                }
                if (arg.equals("-url")) {
                    if (i < args.length) {
                        url = args[i++];
                        continue;
                    }
                    System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_no_host_arg"));
                    msgLogger.message(IRecordType.TYPE_ERR, this, "execute", "TSNMServiceManagerCli_no_host_arg");
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-u") | arg.equals("-user")) {
                    username = args[i++];
                    continue;
                }
                if (!(arg.equals("-p") | arg.equals("-password"))) continue;
                password = args[i++];
            }
            if (args.length < i + 2 | username == null | password == null) {
                System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_IncorrectParms"));
                msgLogger.message(IRecordType.TYPE_ERR, this, "execute", "TSNMServiceManagerCli_IncorrectParms");
                System.exit(1);
            }
            String service = args[i++];
            String method = args[i++];
            String[] params = new String[args.length - i];
            for (int k = 0; k < args.length - i; ++k) {
                params[k] = args[i + k];
            }
            if (debug) {
                try {
                    String protocol = System.getProperty("tsnm.protocol");
                    System.out.println("Protocol set to " + protocol);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.print("url=" + url + ", service=" + service + ", method=" + method + ", params=");
                String s1 = "url=" + url + ", service=" + service + ", method=" + method + ", params=";
                for (int n = 0; n < params.length; ++n) {
                    System.out.print("\"" + params[n] + "\" ");
                    s1 = s1 + "\"" + params[n] + "\" ";
                }
                System.out.println("\n");
                msgLogger.text(IRecordType.TYPE_WARN, this, "execute", s1);
            }
            try {
                ICliDispatcher cli = (ICliDispatcher)ConnectorClient.getService((String)url, ICliDispatcher.class, (String)service, (String)username, (String)password);
                System.out.println(cli.dispatch(method, params));
            }
            catch (Throwable e) {
                if (e instanceof UndeclaredThrowableException) {
                    e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                    if (e instanceof SOAPException) {
                        String faultCode = ((SOAPException)e).getFaultCode();
                        String message = e.getMessage();
                        if (PROTOCOL_ERROR.equals(faultCode) && message.indexOf(AUTH_FAILED) != -1) {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_LoginFailed"));
                        } else if (CLIENT_ERROR.equals(faultCode) && message.indexOf(CONNECTION_FAILED) != -1) {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_ConnectFailed"));
                        } else {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_CommandFailed"));
                            traceLogger.message(IRecordType.TYPE_ERR, (Object)this, "execute", "TSNMServiceManagerCli_InvokeErr", e.toString());
                        }
                    }
                } else {
                    System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_CommandFailed"));
                    traceLogger.message(IRecordType.TYPE_ERR, (Object)this, "execute", "TSNMServiceManagerCli_InvokeErr", e.toString());
                }
                if (!debug) break block22;
                System.out.println("\n");
                e.printStackTrace();
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this, "execute");
        }
    }

    static {
        String localPort = System.getProperty("tsnm.localPort", "8443");
        try {
            String localHostname = InetAddress.getLocalHost().getHostName();
            url = localHostname + ":" + localPort;
        }
        catch (Exception e) {
            String methodName = "Cli.static()";
            msgLogger.message(IRecordType.TYPE_ERR, Cli.class, methodName, "TSNMServiceManagerCli_CaughtException", e.toString());
            msgLogger.exception(IRecordType.TYPE_ERR, Cli.class, methodName, e);
        }
    }
}

