/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class CliDispatcher {
    protected static transient ILogger traceLogger = null;
    protected static transient ILogger msgLogger = null;
    static final String TRACE_NAME = "aperi.logger.trace.TSNMServiceManager";
    static final String MESSAGE_NAME = "aperi.logger.message.TSNMServiceManager";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManagerText";

    public static String dispatch(Object obj, String methodName, String[] args) {
        String myMethodName = "dispatch";
        String ret = "";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, CliDispatcher.class, "dispatch");
        }
        try {
            boolean found = false;
            Class[] paramTypes = null;
            Method[] methods = obj.getClass().getMethods();
            Method method = null;
            Object retObj = null;
            Hashtable<Method, Class<?>[]> methodsTable = new Hashtable<Method, Class<?>[]>();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] pt;
                if (!methods[i].getName().equals(methodName) || ((pt = methods[i].getParameterTypes()).length != 0 || args != null && args.length != 0) && (args == null || pt.length != args.length)) continue;
                methodsTable.put(methods[i], pt);
            }
            if (methodsTable.size() > 0) {
                Object[] params = null;
                Enumeration keys = methodsTable.keys();
                while (keys.hasMoreElements()) {
                    method = (Method)keys.nextElement();
                    paramTypes = (Class[])methodsTable.get(method);
                    if (paramTypes.length == 0) {
                        params = null;
                        found = true;
                        break;
                    }
                    try {
                        params = CliDispatcher.convertToParams(args, paramTypes);
                        found = true;
                        break;
                    }
                    catch (RuntimeException re) {
                    }
                }
                if (found) {
                    retObj = method.invoke(obj, params);
                    if (retObj != null) {
                        ret = retObj.toString();
                    }
                } else {
                    if (traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, CliDispatcher.class, "dispatch");
                    }
                    RuntimeException e1 = new RuntimeException("Method not found or method signature mismatch");
                    msgLogger.exception(IRecordType.TYPE_ERR, CliDispatcher.class, methodName, e1);
                }
            } else {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, "Cli", "dispatch");
                }
                RuntimeException e1 = new RuntimeException("Method not found or method signature mismatch");
                msgLogger.exception(IRecordType.TYPE_ERR, CliDispatcher.class, methodName, e1);
            }
        }
        catch (Throwable e) {
            ret = e.toString();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, CliDispatcher.class, "dispatch");
        }
        return ret;
    }

    private static Object[] convertToParams(String[] args, Class[] paramTypes) throws RuntimeException {
        String methodName = "convertToParms";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, CliDispatcher.class, "convertToParms");
        }
        Object[] params = new Object[paramTypes.length];
        Class[] constructorParam = new Class[]{String.class};
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    paramType = Boolean.class;
                } else if (paramType == Character.TYPE) {
                    paramType = Character.class;
                } else if (paramType == Byte.TYPE) {
                    paramType = Byte.class;
                } else if (paramType == Short.TYPE) {
                    paramType = Short.class;
                } else if (paramType == Integer.TYPE) {
                    paramType = Integer.class;
                } else if (paramType == Long.TYPE) {
                    paramType = Long.class;
                } else if (paramType == Float.TYPE) {
                    paramType = Float.class;
                } else if (paramType == Double.TYPE) {
                    paramType = Double.class;
                }
            }
            try {
                Constructor c = paramType.getConstructor(constructorParam);
                Object[] p = new Object[]{args[i]};
                params[i] = c.newInstance(p);
                continue;
            }
            catch (Throwable e12) {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, CliDispatcher.class, "convertToParms");
                }
                RuntimeException e12 = new RuntimeException("Unable to convert \"" + args[i] + "\" to object of type " + paramType.getName());
                msgLogger.exception(IRecordType.TYPE_ERR, CliDispatcher.class, "convertToParms", e12);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, CliDispatcher.class, "convertToParms");
        }
        return params;
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(BUNDLENAME);
    }
}

