/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import javax.crypto.SealedObject;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.eclipse.aperi.sanmgmt.middleware.data.SessionContext;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ISecuredObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaObjectSerializer
implements Serializer,
Deserializer {
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        if (src == null) {
            SoapEncUtils.generateNullStructure((String)inScopeEncStyle, (Class)javaType, (Object)context, (Writer)sink, (NSStack)nsStack, (XMLJavaMappingRegistry)xjmr);
        } else {
            SoapEncUtils.generateStructureHeader((String)inScopeEncStyle, (Class)javaType, (Object)context, (Writer)sink, (NSStack)nsStack, (XMLJavaMappingRegistry)xjmr);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(src);
            oos.close();
            sink.write(Base64.encode((byte[])baos.toByteArray()) + "</" + context + '>');
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        String value = DOMUtils.getChildCharacterData((Element)root);
        ObjectInputStream ois = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)value));
        Object obj = null;
        try {
            ois = new ObjectInputStream(bais);
            obj = ois.readObject();
            if (obj instanceof ISecuredObject) {
                obj = ((SealedObject)obj).getObject(SessionContext.getSecretKey());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        String javaTypeString = elementType.getNamespaceURI();
        Class javaType = Object.class;
        try {
            javaType = Class.forName(javaTypeString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        return new Bean(javaType, obj);
    }
}

