/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;

public class LocalServiceProxy
implements InvocationHandler,
Serializable {
    private static Class[] getTargetObjectParams = new Class[]{String.class};
    public String service;
    private Object targetObject = null;
    private boolean isInitialized = false;

    public LocalServiceProxy(String serviceName) throws Exception {
        this.service = serviceName;
        this.init();
    }

    public static Object newInstance(String serviceName, Class c) throws Exception {
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)new LocalServiceProxy(serviceName));
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (!this.isInitialized) {
                this.init();
                this.isInitialized = true;
            }
            return m.invoke(this.targetObject, args);
        }
        catch (UndeclaredThrowableException ute) {
            throw ute.getUndeclaredThrowable();
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void init() throws Exception {
        Class<?> cServiceManager = Class.forName("org.eclipse.aperi.sanmgmt.middleware.TSNMServiceManager");
        Method mGetInstance = cServiceManager.getMethod("getInstance", new Class[0]);
        Method mGetTargetObject = cServiceManager.getMethod("getTargetObject", getTargetObjectParams);
        Object oServiceManager = mGetInstance.invoke(null, new Object[0]);
        this.targetObject = mGetTargetObject.invoke(oServiceManager, this.service);
        if (this.targetObject == null) {
            throw new RuntimeException("Failed to get local proxy for service " + this.service);
        }
    }
}

