/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import com.ibm.log.util.MessageCatalog;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.eclipse.aperi.sanmgmt.middleware.data.MappingRegistry;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.NotAuthorizedException;
import org.eclipse.aperi.sanmgmt.middleware.data.NullUserException;
import org.eclipse.aperi.sanmgmt.middleware.data.RetryFailedException;
import org.eclipse.aperi.sanmgmt.middleware.data.SOAPNotAuthorizedException;
import org.eclipse.aperi.sanmgmt.middleware.data.SecuredObject;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.UserSecurityContext;
import org.w3c.dom.Element;

public class SoapClient {
    public static final String HTTP_PROTOCOL = "http://";
    public static String tsnm_servlet_protocol = "http://";
    public static final String TSNM_SERVLET_PATH = "/ServiceManager";
    public static final String TSNM_SERVLET_PATH_2 = "/ServiceManagerUA";
    private SecurityContext sc = null;
    private URL url = null;
    private Call call = null;
    private Vector params = null;
    private SOAPMappingRegistry smr = null;
    private String encodingStyleURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private SecretKey clientSecretKey = null;
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    MessageCatalog msgCat = new MessageCatalog("org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager");
    private static final byte[] skip1024ModulusBytes = new byte[]{-30, 16, 126, 80, -19, 40, -54, 80, -83, -74, 127, 113, -30, -7, 39, 75, -51, 45, -101, -104, 14, 51, -78, -41, 79, 108, -11, -82, -122, -22, 42, -16, 21, -34, -85, -123, -115, -53, -122, -32, -109, 51, 55, 95, 109, 118, -4, -2, -3, 62, 88, -46, -47, -72, 54, -80, 33, -117, -93, -40, 92, -127, 41, -96, -89, 60, -21, -127, 40, -44, 0, -42, -53, -80, -63, 94, 126, -85, 47, 55, 62, -58, -60, -81, -96, 69, 70, 84, -8, 86, 106, -45, 120, -69, 6, -8, 77, -94, 60, -24, 105, -64, 91, -62, 52, 31, -42, 37, -71, 88, 4, 69, 76, 101, 117, 45, 33, 62, 104, -6, 62, 92, 10, -88, -123, 66, -68, -101};
    private static final byte[] skip1024BaseBytes = new byte[]{-122, -40, -90, 16, -20, -43, 13, -50, -101, -81, 31, 35, 34, -35, -94, -112, 126, -98, 71, 35, 5, -60, 19, -20, -69, -21, 103, 24, -127, 127, -81, 91, 110, -50, 78, 85, 103, -4, -40, -36, 83, -125, 78, -77, -65, 19, -19, -94, -78, 1, 63, 17, -6, -86, -40, -5, 20, -123, 1, 90, 14, -51, -15, -114, 57, 69, -5, -118, 115, -64, -64, -50, -17, -81, -118, -14, 18, 93, -25, 64, -99, -112, -46, 16, 34, -113, -35, -38, -11, 122, -113, 42, -65, -77, -63, 16, 43, 108, 44, 102, -39, 78, -59, 58, 52, -65, 38, 28, -84, -56, -21, -107, -128, 4, -70, -117, 86, -120, -37, -82, -70, 28, 2, -46, 16, 76, 51, 4};
    private static final BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private static final BigInteger skip1024Base = new BigInteger(1, skip1024BaseBytes);
    static final Object genKeyLock = new Object();

    public SoapClient() {
    }

    public SoapClient(String hostUrl, String service, SecurityContext sc) throws Exception {
        this.sc = sc;
    }

    public SoapClient(String host, int port, String service, SecurityContext sc) throws Exception {
        this.sc = sc;
    }

    public void init(String hostUrl, String service) throws Exception {
        if (this.sc == null) {
            this.sc = SecurityContext.getDefaultContext();
        }
        if (this.sc == null) {
            throw new RuntimeException("SecurityContext is null");
        }
        this.smr = MappingRegistry.getInstance();
        this.call = new Call();
        if (this.sc instanceof UserSecurityContext) {
            SOAPHTTPConnection shc = new SOAPHTTPConnection();
            shc.setUserName(((UserSecurityContext)this.sc).getUser());
            shc.setPassword(((UserSecurityContext)this.sc).getPassword());
            this.call.setSOAPTransport((SOAPTransport)shc);
        }
        this.call.setSOAPMappingRegistry(this.smr);
        this.call.setTargetObjectURI(service);
        this.call.setEncodingStyleURI(this.encodingStyleURI);
        this.params = new Vector();
        this.url = this.sc instanceof SystemSecurityContext ? new URL(tsnm_servlet_protocol + hostUrl + TSNM_SERVLET_PATH) : new URL(tsnm_servlet_protocol + hostUrl + TSNM_SERVLET_PATH_2);
        if (this.sc instanceof SystemSecurityContext) {
            this.handshake(hostUrl, service);
        }
    }

    public Object invoke() throws Throwable {
        String targetURI = this.call.getFullTargetObjectURI();
        Object returnVal = null;
        Response resp = null;
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        resp = this.call.invoke(this.url, null);
        if (Thread.interrupted()) {
            throw new ThreadDeath();
        }
        if (resp != null) {
            if (!resp.generatedFault()) {
                Parameter result = resp.getReturnValue();
                if (result != null) {
                    returnVal = result.getValue();
                }
            } else {
                Throwable ex = null;
                Fault fault = resp.getFault();
                Vector v = fault.getDetailEntries();
                if (v == null || v.size() < 1) {
                    ex = new RuntimeException(fault.toString());
                } else {
                    Object obj = v.get(0);
                    if (obj instanceof Element) {
                        try {
                            String value = ((Element)v.get(0)).getFirstChild().getNodeValue();
                            ObjectInputStream ois = null;
                            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)value));
                            ois = new ObjectInputStream(bais);
                            ex = (Throwable)ois.readObject();
                        }
                        catch (Exception e) {
                            ex = new RuntimeException(fault.toString());
                        }
                    } else if (obj instanceof Parameter) {
                        Parameter param = (Parameter)obj;
                        Object val = param.getValue();
                        if (val instanceof Throwable) {
                            ex = (Throwable)val;
                        }
                    } else {
                        ex = new RuntimeException(fault.toString());
                    }
                }
                if (ex instanceof NullUserException) {
                    Vector origParams = (Vector)this.call.getParams().clone();
                    String origMethodName = this.call.getMethodName();
                    this.handshake(this.url.toString(), targetURI);
                    resp = null;
                    this.setMethod(origMethodName, origParams);
                    this.call.setTargetObjectURI(targetURI);
                    if (Thread.interrupted()) {
                        throw new ThreadDeath();
                    }
                    resp = this.call.invoke(this.url, null);
                    if (Thread.interrupted()) {
                        throw new ThreadDeath();
                    }
                    if (resp != null) {
                        if (!resp.generatedFault()) {
                            Parameter result = resp.getReturnValue();
                            if (result != null) {
                                return result.getValue();
                            }
                            return null;
                        }
                        ex = new RetryFailedException(ex.getMessage());
                    }
                }
                this.call.setFullTargetObjectURI(targetURI);
                if (ex instanceof SOAPNotAuthorizedException) {
                    ex = new NotAuthorizedException(ex.getMessage());
                }
                throw ex;
            }
        }
        return returnVal;
    }

    public static void setCommunicationProtocol(String protocol) {
        StringBuffer debugMessage = new StringBuffer();
        debugMessage.append("Protocol switched from ");
        debugMessage.append(tsnm_servlet_protocol);
        debugMessage.append(" to ");
        debugMessage.append(protocol);
        System.out.println(debugMessage.toString());
        tsnm_servlet_protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handshake(String hostUrl, String service) throws SOAPException {
        String clientPubKeyEncEncrypted = null;
        KeyAgreement clientKeyAgree = null;
        try {
            Object object = genKeyLock;
            synchronized (object) {
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(skip1024Modulus, skip1024Base);
                KeyPairGenerator clientKpairGen = KeyPairGenerator.getInstance("DH");
                clientKpairGen.initialize(dhSkipParamSpec);
                KeyPair clientKpair = clientKpairGen.generateKeyPair();
                byte[] clientPubKeyEnc = clientKpair.getPublic().getEncoded();
                clientPubKeyEncEncrypted = Base64.encode((byte[])MiddlewareCrypto.encrypt(clientPubKeyEnc));
                clientKeyAgree = KeyAgreement.getInstance("DH");
                clientKeyAgree.init(clientKpair.getPrivate());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(this.msgCat.getMessage("TSNMServiceManager_AuthenticationFailed", (Object)hostUrl));
        }
        Response resp = null;
        try {
            Class[] HANDSHAKE_ARG_TYPE = new Class[]{Class.forName("java.lang.String")};
            Method HANDSHAKE_METHOD = Class.forName("org.eclipse.aperi.sanmgmt.middleware.DeviceServiceManager").getDeclaredMethod("handshake", HANDSHAKE_ARG_TYPE);
            Object[] HANDSHAKE_ARG = new Object[]{clientPubKeyEncEncrypted};
            this.setMethod(HANDSHAKE_METHOD, HANDSHAKE_ARG);
            this.call.setTargetObjectURI("DeviceServiceManager");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to exchange public keys: " + e.toString());
        }
        try {
            resp = this.call.invoke(this.url, null);
        }
        catch (SOAPException e) {
            throw e;
        }
        finally {
            this.call.setTargetObjectURI(service);
        }
        String serverPubKeyEncEncrypted = null;
        if (resp != null) {
            if (resp.generatedFault()) throw new RuntimeException("Handshake generated a fault.");
            Parameter result = resp.getReturnValue();
            if (result == null) throw new RuntimeException("Server public key is null.");
            serverPubKeyEncEncrypted = (String)result.getValue();
        }
        try {
            byte[] serverPubKeyEnc = MiddlewareCrypto.decrypt(Base64.decode(serverPubKeyEncEncrypted));
            KeyFactory clientKeyFac = KeyFactory.getInstance("DH");
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(serverPubKeyEnc);
            PublicKey serverPubKey = clientKeyFac.generatePublic(x509KeySpec);
            clientKeyAgree.doPhase(serverPubKey, true);
            this.clientSecretKey = clientKeyAgree.generateSecret("DES");
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(this.msgCat.getMessage("TSNMServiceManager_FailedToAuthenticate", (Object)hostUrl));
        }
    }

    public void setMethod(Method m, Object[] args) throws Exception {
        if (this.params != null) {
            this.params.removeAllElements();
        } else {
            this.params = new Vector();
        }
        if (m != null) {
            this.call.setMethodName(m.getName());
            Class<?>[] types = m.getParameterTypes();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (this.flaggedForEncryption(args[i])) {
                        this.sealObject(args[i]);
                        types[i] = args[i].getClass();
                    }
                    this.params.addElement(new Parameter("arg" + i, types[i], args[i], null));
                }
            }
        } else {
            throw new Exception("Method is null");
        }
        this.call.setParams(this.params);
    }

    public void setMethod(String methodName, Vector params) {
        if (params != null && methodName != null) {
            this.call.setMethodName(methodName);
            this.call.setParams(params);
        }
    }

    private boolean flaggedForEncryption(Object arg) {
        boolean flag = false;
        if (arg != null) {
            Class<?>[] interfaces = arg.getClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    if (!interfaces[i].isAssignableFrom(Class.forName("org.eclipse.aperi.sanmgmt.middleware.interfaces.ISecuredObject"))) continue;
                    flag = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    private SecuredObject sealObject(Object arg) {
        SecuredObject sObject = null;
        try {
            Cipher c = Cipher.getInstance("DES");
            c.init(1, this.clientSecretKey);
            SecuredObject so = new SecuredObject((Serializable)arg, c);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to seal object: " + e.getMessage());
        }
        return sObject;
    }
}

