/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;

public class Response
implements Serializable {
    private static final long serialVersionUID = 20001130L;
    public static final String VERSION_CONSTANT = "5.0.0";
    static final String MESSAGE_NAME = "aperi.logger.message.SanQueryEngine";
    static final String TRACE_NAME = "aperi.logger.trace.SanQueryEngine";
    public static transient ILogger msgLogger = null;
    public static transient ILogger traceLogger = null;
    private static String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
    static final String className = Response.class.getName();
    private int returnCode;
    private byte[] data;
    private int level;
    private int benchmarkLevel;
    private String benchmarkLabel;
    private boolean sameAsBenchmark;
    public static int RETURN_CODE_OK = 0;
    public static int RETURN_CODE_ERROR = 47;
    public static int RETURN_CODE_INACTIVE_SCANNER = 48;
    private Header header = null;

    public Response(int returnCode, String[] data, int level, int benchmarkLevel, String benchmarkLabel, boolean sameAsBenchmark) {
        String methodName = "Response(rtnCode, data, level, bnchmrkLvl, bnchmrkLbl, sameAsBnchmrk)";
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = returnCode;
        this.data = (byte[])(data != null && data.length != 0 ? this.compressData(this.convertToByteArray(data)) : null);
        this.level = level;
        this.benchmarkLevel = benchmarkLevel;
        this.benchmarkLabel = benchmarkLabel;
        this.sameAsBenchmark = sameAsBenchmark;
        if (traceLogger != null && traceLogger.isLogging()) {
            String msg = "Input: rc = " + this.returnCode + " sameAsBenchmark = " + this.sameAsBenchmark;
            msg = this.data == null ? msg + ", uncompressed data is NULL" : msg + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, msg);
        }
    }

    public Response(int returnCode, String[] data) {
        String methodName = "Response(rtnCode, data)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if ((traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME)) != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = returnCode;
        this.data = (byte[])(data != null && data.length != 0 ? this.compressData(this.convertToByteArray(data)) : null);
        this.level = -1;
        this.benchmarkLevel = -1;
        this.benchmarkLabel = "";
        this.sameAsBenchmark = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            String msg = "Input: rc = " + this.returnCode;
            msg = this.data == null ? msg + ", uncompressed data is NULL" : msg + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, msg);
        }
    }

    public Response(int returnCode, String data) {
        String methodName = "Response(rtnCode, data)";
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if ((msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME)) != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
        this.returnCode = returnCode;
        this.data = (byte[])(data != null && !data.equals("") ? this.compressData(data.getBytes()) : null);
        this.level = -1;
        this.benchmarkLevel = -1;
        this.benchmarkLabel = "";
        this.sameAsBenchmark = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            String msg = "Input: rc = " + this.returnCode;
            msg = this.data == null ? msg + ", uncompressed data is NULL" : msg + ", compressed data length = " + this.data.length;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, msg);
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getLevel() {
        return this.level;
    }

    public int getBenchmarkLevel() {
        return this.benchmarkLevel;
    }

    public String getBenchmarkLabel() {
        return this.benchmarkLabel;
    }

    public boolean isSameAsBenchmark() {
        return this.sameAsBenchmark;
    }

    public String getData() {
        if (this.data == null || this.data.length == 0) {
            return new String();
        }
        return new String(this.uncompressData(this.data));
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header hdr) {
        this.header = hdr;
    }

    public String toString() {
        String result = new String();
        result = result.concat("\nResponse object\n");
        result = result.concat("  Return code = " + this.returnCode + "\n");
        result = result.concat("  Level = " + this.level + "\n");
        result = result.concat("  BenchmarkLevel = " + this.benchmarkLevel + "\n");
        result = result.concat("  BenchmarkLabel = \"" + this.benchmarkLabel + "\"\n\n");
        if (this.header != null) {
            result = result.concat(this.header.toString() + "\n\n");
        }
        if (this.data != null) {
            result = result.concat("  Data = \n" + this.getData() + "\n\n");
        }
        return result;
    }

    private byte[] compressData(byte[] d) {
        String methodName = "compressData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        byte[] bytes = null;
        if (d != null && d.length != 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                gos.write(d, 0, d.length);
                gos.close();
                bytes = baos.toByteArray();
            }
            catch (IOException e) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "QueryEngine_compressDataException", e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return bytes;
    }

    private byte[] uncompressData(byte[] d) {
        String methodName = "uncompressData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        byte[] bytes = null;
        if (d != null && d.length != 0) {
            try {
                int bytesRead;
                ByteArrayInputStream bais = new ByteArrayInputStream(d);
                GZIPInputStream gis = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = gis.read(buffer, 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                gis.close();
                bytes = baos.toByteArray();
            }
            catch (IOException e) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "QueryEngine_uncompressDataException", e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return bytes;
    }

    private String convertToString(String[] s) {
        String methodName = "convertToString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        StringBuffer result = new StringBuffer();
        String str = null;
        if (s != null && s.length != 0) {
            for (int i = 0; i < s.length; ++i) {
                result.append(s[i]);
            }
            str = result.toString();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return str;
    }

    private byte[] convertToByteArray(String[] s) {
        String methodName = "convertToByteArray";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        byte[] bytes = null;
        if (s != null && s.length != 0) {
            bytes = this.convertToString(s).getBytes();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return bytes;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setBenchmarkLevel(int benchmarkLevel) {
        this.benchmarkLevel = benchmarkLevel;
    }

    public void setBenchmarkLabel(String benchmarkLabel) {
        this.benchmarkLabel = benchmarkLabel;
    }

    public void setSameAsBenchmark(boolean sameAsBenchmark) {
        this.sameAsBenchmark = sameAsBenchmark;
    }
}

