/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces;

import java.util.Stack;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ZoneDefSaxParser
extends DefaultHandler {
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = ZoneDefSaxParser.class.getName();
    private ZoneDefinition zoneDefinition;
    private Stack zStack = null;

    public ZoneDefSaxParser(ZoneDefinition definition) {
        String methodName = "ZoneDefSaxParser";
        this.zoneDefinition = definition;
        msgLogger = ZoneConstants.msgLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.SanZoneControl");
        traceLogger = ZoneConstants.traceLogger;
        this.zStack = new Stack();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
    }

    public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attribs) throws SAXException {
        String methodName = "startElement";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (qualifiedName.equalsIgnoreCase("ZoningConfigurations")) {
            if (traceLogger.isLogging()) {
                String msg = "qualifiedName = " + qualifiedName;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
            }
        } else if (qualifiedName.equalsIgnoreCase("ZoneSet")) {
            String name = attribs.getValue("name");
            boolean isactive = false;
            if (attribs.getValue("active").equalsIgnoreCase("FALSE")) {
                isactive = false;
            } else if (attribs.getValue("active").equalsIgnoreCase("TRUE")) {
                isactive = true;
            }
            ZoneSet zSet = new ZoneSet(name);
            this.zoneDefinition.addZoneSet(zSet);
            if (isactive) {
                this.zoneDefinition.activateZoneSet(zSet);
            }
            this.zStack.push(zSet);
            if (traceLogger.isLogging()) {
                String msg = "qualifiedName = " + qualifiedName + " name = " + name + " isActive = " + isactive;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
            }
        } else if (qualifiedName.equalsIgnoreCase("Zone")) {
            Object parent;
            String name = attribs.getValue("name");
            String vendorType = attribs.getValue("vendorType");
            short vtype = vendorType == null ? (short)1 : Short.parseShort(vendorType);
            Zone zone = this.zoneDefinition.getZone(name);
            if (zone == null) {
                zone = new Zone(name, vtype);
                this.zoneDefinition.addZone(zone);
            }
            if (!this.zStack.empty() && (parent = this.zStack.peek()) instanceof ZoneSet) {
                this.zoneDefinition.addZone((ZoneSet)parent, zone);
            }
            this.zStack.push(zone);
            if (traceLogger.isLogging()) {
                String msg = "qualifiedName = " + qualifiedName + " name = " + name + " vendorType = " + vendorType;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
            }
        } else if (qualifiedName.equalsIgnoreCase("ZoneAlias")) {
            Object parent;
            String name = attribs.getValue("name");
            ZoneAlias alias = this.zoneDefinition.getZoneAlias(name);
            if (alias == null) {
                alias = new ZoneAlias(name);
                this.zoneDefinition.addAlias(alias);
            }
            if (!this.zStack.empty() && (parent = this.zStack.peek()) instanceof Zone) {
                this.zoneDefinition.addAlias((Zone)parent, alias);
            }
            this.zStack.push(alias);
            if (traceLogger.isLogging()) {
                String msg = "qualifiedName = " + qualifiedName + " name = " + name;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
            }
        } else if (qualifiedName.equalsIgnoreCase("ZoneMember")) {
            String name = attribs.getValue("name");
            short type = new Integer(attribs.getValue("type")).shortValue();
            ZoneMember member = new ZoneMember(type, name);
            Object parent = this.zStack.peek();
            if (parent instanceof Zone) {
                this.zoneDefinition.addMember((Zone)parent, member);
            } else if (parent instanceof ZoneAlias) {
                this.zoneDefinition.addMember((ZoneAlias)parent, member);
            }
            this.zStack.push(member);
            if (traceLogger.isLogging()) {
                String msg = "qualifiedName = " + qualifiedName + " name = " + name + " type = " + type;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String methodName = "endElement";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
            String msg = "qName = " + qName;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, msg);
        }
        if (!this.zStack.empty()) {
            this.zStack.pop();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(this.GetErrorString(e));
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException(this.GetErrorString(e));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(this.GetErrorString(e));
    }

    private String GetErrorString(SAXParseException exception) {
        StringBuffer errString = new StringBuffer("Line: ");
        errString.append(exception.getLineNumber());
        errString.append("\nMessage: ");
        errString.append(exception.getMessage());
        return errString.toString();
    }
}

