/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.util;

public class InterpResolver {
    private static final long serialVersionUID = 20001130L;
    public static final String sunos = "SunOS";
    public static final String solaris = "Solaris";
    public static final String linux = "Linux";
    public static final String aix = "AIX";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    public static final String winxp = "Windows XP";
    public static final String ppc = "ppc";
    public static final String intel = "i386";
    public static final String wintel = "x86";
    public static final String unknown = "unknown";
    public static final String sunos4 = "sunos4";
    public static final String solaris2 = "solaris2";
    public static final String aix3 = "aix3-r2";
    public static final String aix4 = "aix4-r1";
    public static final String aix5 = "aix";
    public static final String linuxix86 = "linux";
    public static final String w32ix86 = "w32-ix86";

    public static String getInterp() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return InterpResolver.getInterp(osName, osVersion, osArch);
    }

    public static String getInterp(String osName, String osVersion, String osArch) {
        if (osName.equals(sunos) || osName.equals(solaris)) {
            return solaris2;
        }
        if (osName.equals(aix)) {
            return aix5;
        }
        if (InterpResolver.isLinux(osName)) {
            return linuxix86;
        }
        if (InterpResolver.isWindows(osName)) {
            return w32ix86;
        }
        return unknown;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return InterpResolver.isWindows(osName);
    }

    public static boolean isWindows(String osName) {
        boolean isWindows = false;
        if (osName.indexOf("windows") != -1 || osName.indexOf("Windows") != -1 || osName.indexOf("WINDOWS") != -1) {
            isWindows = true;
        }
        return isWindows;
    }

    public static boolean isLinux(String osName) {
        boolean isLinux = false;
        if (osName.equals(linux)) {
            isLinux = true;
        }
        return isLinux;
    }

    public static boolean isAIX(String osName) {
        boolean isAIX = false;
        if (osName.equals(aix5)) {
            isAIX = true;
        }
        return isAIX;
    }
}

