/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.StatDataWriter;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Alert
extends ListElement {
    static final long serialVersionUID = 1826896167609385913L;
    private long alertTime;
    private AlertDefinition alertDef;
    private String[] parms;
    private int[][] varBindOID;
    private String[] tecSlotNames;
    private int resourceID;
    private int computerID;
    private short resourceType;
    private int violatingValue;
    private int previousValue;
    private int violatorID;
    private short violatorType;
    private int trapType;
    private byte dbmsType;
    private int parentID;
    private int[] enterprise;
    private Hashtable varBinds;
    private String tecClass;
    private Hashtable tecAttributes;
    private String msgID;
    private Object[] msgParms;
    private int[] affectedResources = null;
    private String affectedHosts = null;
    private boolean hasAffectedResources = false;
    public StatDataWriter statWriter;
    public Serializable jobData;

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, String[] parms, int trapType, int[][] varBindOID, String[] tecSlotNames) {
        this(computerID, resourceID, resourceType, alertDef, parms, trapType, varBindOID, tecSlotNames, -1, -1, -1, -1);
    }

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, String[] parms, int trapType, int[][] varBindOID, String[] tecSlotNames, int violatingValue, int previousValue) {
        this(computerID, resourceID, resourceType, alertDef, parms, trapType, varBindOID, tecSlotNames, violatingValue, previousValue, -1, -1);
    }

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, String[] parms, int trapType, int[][] varBindOID, String[] tecSlotNames, int violatingValue, int previousValue, byte dbmsType, int parentID) {
        this(computerID, resourceID, resourceType, alertDef, parms, trapType, varBindOID, tecSlotNames, violatingValue, previousValue, -1, -1, dbmsType, parentID);
    }

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, String[] parms, int trapType, int[][] varBindOID, String[] tecSlotNames, int violatingValue, int previousValue, int violatorID, short violatorType) {
        this(computerID, resourceID, resourceType, alertDef, parms, trapType, varBindOID, tecSlotNames, violatingValue, previousValue, violatorID, violatorType, 0, -1);
    }

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, String[] parms, int trapType, int[][] varBindOID, String[] tecSlotNames, int violatingValue, int previousValue, int violatorID, short violatorType, byte dbmsType, int parentID) {
        this.computerID = computerID;
        this.resourceID = resourceID;
        this.resourceType = resourceType;
        this.alertDef = alertDef;
        this.parms = parms;
        this.trapType = trapType;
        this.varBindOID = varBindOID;
        this.tecSlotNames = tecSlotNames;
        this.violatingValue = violatingValue;
        this.previousValue = previousValue;
        this.violatorID = violatorID;
        this.violatorType = violatorType;
        this.dbmsType = dbmsType;
        this.parentID = parentID;
        this.setAlertTime();
    }

    public Alert(int computerID, int resourceID, short resourceType, AlertDefinition alertDef, int[] enterprise, int trapType, Hashtable varBinds, String tecClass, Hashtable tecAttributes, String msgID, Object[] msgParms) {
        this.computerID = computerID;
        this.resourceID = resourceID;
        this.resourceType = resourceType;
        this.alertDef = alertDef;
        this.enterprise = enterprise;
        this.trapType = trapType;
        this.varBinds = varBinds;
        this.tecClass = tecClass;
        this.tecAttributes = tecAttributes;
        this.msgID = msgID;
        this.msgParms = msgParms;
        this.dbmsType = alertDef.aldDbmsType;
        this.setAlertTime();
        if (msgParms != null) {
            this.parms = new String[msgParms.length];
            for (int i = 0; i < msgParms.length; ++i) {
                this.parms[i] = msgParms[i].toString();
            }
        }
    }

    private void setAlertTime() {
        try {
            this.alertTime = CurrentTime.getTimestamp().getTime();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(Alert.class.getName(), "Alert", sqle);
            }
            this.alertTime = System.currentTimeMillis();
            return;
        }
    }

    public long getAlertTime() {
        return this.alertTime;
    }

    public AlertDefinition getAlertDefinition() {
        return this.alertDef;
    }

    public String[] getParameters() {
        return this.parms;
    }

    public int[][] getVarBindOID() {
        return this.varBindOID;
    }

    public String[] getTecSlotNames() {
        return this.tecSlotNames;
    }

    public int getComputerID() {
        return this.computerID;
    }

    public short getResourceType() {
        return this.resourceType;
    }

    public int getResourceID() {
        return this.resourceID;
    }

    public short getViolatorType() {
        return this.violatorType;
    }

    public int getViolatorID() {
        return this.violatorID;
    }

    public int getViolatingValue() {
        return this.violatingValue;
    }

    public int getPreviousValue() {
        return this.previousValue;
    }

    public int getTrapType() {
        return this.trapType;
    }

    public byte getDbmsType() {
        return this.dbmsType;
    }

    public int getParentID() {
        return this.parentID;
    }

    public void setAlertDefinition(AlertDefinition alertDef) {
        this.alertDef = alertDef;
    }

    public int[] getEnterprise() {
        return this.enterprise;
    }

    public Hashtable getVarBinds() {
        return this.varBinds;
    }

    public String getTecClass() {
        return this.tecClass;
    }

    public Hashtable getTecAttributes() {
        return this.tecAttributes;
    }

    public String getMessageID() {
        return this.msgID;
    }

    public Object[] getMessageParameters() {
        return this.msgParms;
    }

    public boolean hasAffectedResources() {
        return this.hasAffectedResources;
    }

    public int[] getAffectedResources() {
        return this.affectedResources;
    }

    public String getAffectedHosts() {
        return this.affectedHosts;
    }

    public void setHasAffectedResources(boolean hasAffectedResources) {
        this.hasAffectedResources = hasAffectedResources;
    }

    public void setAffectedResources(int[] affectedResources) {
        this.affectedResources = affectedResources;
    }

    public void setAffectedHosts(String affectedHosts) {
        this.affectedHosts = affectedHosts;
    }
}

