/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.xmsg.MessageLog;

public class ViewerEntityPopulator {
    static Random r = new Random();
    public static final Integer ZERO_INT = new Integer(0);
    HashMap dictionary = new HashMap();
    public static int ctr = 0;

    public Object getUpdateDictionary(Object key) {
        Object value = this.dictionary.get(key);
        if (value == null) {
            this.dictionary.put(key, key);
            return key;
        }
        return value;
    }

    public String getPortType(Integer type) {
        if (type != null) {
            String res = DBConstants.getKeyFromValue("Port_Types", type.toString());
            return res;
        }
        return null;
    }

    public String getOsType(Integer osType) {
        String osTypeStr;
        if (osType != null && (osTypeStr = DBConstants.getKeyFromValue("OS_Type", osType.toString())) != null) {
            return MessageLog.getMessageNoID(osTypeStr);
        }
        return null;
    }

    public String getOtherType(Integer type) {
        if (type == null) {
            return null;
        }
        String res = null;
        res = type >= 30 ? FabricGuiUtil.getPeTypeString(type) : FabricGuiUtil.getNodeTypeString(type);
        return res;
    }

    public Vector getOperationalStatus(Integer status) {
        if (status == null) {
            return null;
        }
        Vector multiStatus = DBConstants.convertOperationalstatusBitValueToArray(status);
        Vector result = new Vector();
        for (String value : multiStatus) {
            DBConstants.getKeyFromValue("Operational_Status", value);
            result.add(result);
        }
        return result;
    }

    public Integer translateStatus(Integer status) {
        if (status != null) {
            status = status == 0 ? GraphModelConstant.STATUS_NORMAL : (status == 1 ? GraphModelConstant.STATUS_WARNING : (status == 2 ? GraphModelConstant.STATUS_CRITICAL : (status == 3 ? GraphModelConstant.STATUS_MISSING : GraphModelConstant.STATUS_UNKNOWN)));
            return status;
        }
        return GraphModelConstant.STATUS_UNKNOWN;
    }

    public void setStatus(GraphEntity node, Integer detectable, Integer propagated) {
        if (detectable == null) {
            node.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        } else if (detectable == 0 || detectable == 3) {
            node.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        } else {
            node.setHealthStatus(this.translateStatus(propagated));
        }
    }

    public void populateSan(ResultSet resultSet, GraphFabric gSan) throws SQLException {
        String WWN = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        String parentName = (String)this.getUpdateDictionary(resultSet.getObject("PARENT_DISPLAY_NAME"));
        Integer activeValue = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean active = null;
        if (activeValue != null && activeValue == 1) {
            active = Boolean.TRUE;
        } else if (activeValue != null && activeValue == 0) {
            active = Boolean.FALSE;
        }
        Integer isPhysical = (Integer)this.getUpdateDictionary(resultSet.getObject("IS_PHYSICAL"));
        Boolean isPhysicalVal = null;
        isPhysicalVal = isPhysical != null && isPhysical == 0 ? Boolean.FALSE : Boolean.TRUE;
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operational = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gSan.setOperationalStatus(operational);
        gSan.setWWN(WWN);
        gSan.setName(name);
        gSan.setParentLabel(parentName);
        gSan.setActive(active);
        gSan.setIsPhysical(isPhysicalVal);
        gSan.setDisplayName(displayName);
        gSan.setUDP1(udp1);
        gSan.setUDP2(udp2);
        gSan.setUDP3(udp3);
        gSan.setNumOfSubsystems(ZERO_INT);
        gSan.setNumOfComputers(ZERO_INT);
        gSan.setNumOfSwitches(ZERO_INT);
        gSan.setNumOfOthers(ZERO_INT);
        gSan.setNumOfTapeLibraries(ZERO_INT);
        this.setStatus(gSan, detectable, propagatedStatus);
    }

    public void populateRDBMS(ResultSet resultSet, GraphDatabaseGroup gRDBMS) throws SQLException {
        String name = (String)this.getUpdateDictionary(resultSet.getObject("RDBMS_NAME"));
        gRDBMS.setDisplayName(name);
    }

    public void populateDatabase(ResultSet resultSet, GraphDatabase gDB) throws SQLException {
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        gDB.setDisplayName(name);
    }

    public void populateTableSpace(ResultSet resultSet, GraphTableSpace gTS) throws SQLException {
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        gTS.setDisplayName(name);
    }

    public void populateTableFile(ResultSet resultSet, GraphTableSpace gTS) throws SQLException {
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        gTS.setDisplayName(name);
    }

    public void populateFileSystem(ResultSet resultSet, GraphFilesystem gFS) throws SQLException {
        BigDecimal size = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("PHYSICAL_SIZE"));
        String mountPoint = (String)this.getUpdateDictionary(resultSet.getObject("MOUNT_POINT"));
        Integer type = (Integer)this.getUpdateDictionary(resultSet.getObject("FILESYSTEM_TYPE"));
        gFS.setDisplayName(mountPoint);
        gFS.setMountPoint(mountPoint);
        gFS.setPhysicalSize(size != null ? new Long(size.longValue()) : null);
        gFS.setType(type);
    }

    public void populateLVM(ResultSet resultSet, GraphLogicalVolumeManager gLVM) throws SQLException {
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        Integer type = (Integer)this.getUpdateDictionary(resultSet.getObject("VOLGROUP_TYPE"));
        BigDecimal capacity = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        BigDecimal freespace = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("FREESPACE"));
        gLVM.setDisplayName(name);
        gLVM.setFreeSpace(freespace != null ? new Long(freespace.longValue()) : null);
        gLVM.setCapacity(capacity != null ? new Long(capacity.longValue()) : null);
        gLVM.setType(type);
    }

    public void populateLogicalVolume(ResultSet resultSet, GraphLogicalVolume gLogicalVolume) throws SQLException {
        String path = (String)this.getUpdateDictionary(resultSet.getObject("PATH"));
        gLogicalVolume.setDisplayName(path);
    }

    public void populateSubsystem(ResultSet resultSet, GraphSubsystem gArray) throws SQLException {
        Long allocatedCapacity = (Long)this.getUpdateDictionary(resultSet.getObject("ALLOCATED_CAPACITY"));
        Long availableCapacity = (Long)this.getUpdateDictionary(resultSet.getObject("AVAILABLE_CAPACITY"));
        Long backendStorageCapacity = (Long)this.getUpdateDictionary(resultSet.getObject("BACKEND_STORAGE_CAPACITY"));
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        Long cache = (Long)this.getUpdateDictionary(resultSet.getObject("CACHE"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String defaultElementManager = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        String type = (String)this.getUpdateDictionary(resultSet.getObject("TYPE"));
        String serial = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String ipAddress = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String codeLevel = (String)this.getUpdateDictionary(resultSet.getObject("CODE_LEVEL"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer consolidatedStat = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        gArray.setIsSVC("SVC".equals(type) ? Boolean.TRUE : Boolean.FALSE);
        gArray.setAllocatedCapacity(allocatedCapacity);
        gArray.setAvailableCapacity(availableCapacity);
        gArray.setBackendStorageCapacity(backendStorageCapacity);
        gArray.setVendor(vendor);
        gArray.setModel(model);
        gArray.setCache(cache);
        gArray.setType(type);
        gArray.setCodeLevel(codeLevel);
        gArray.setDisplayName(displayName);
        gArray.setIPAddress(ipAddress);
        gArray.setSerialNumber(serial);
        gArray.setOperationalStatus(operationalStatus);
        gArray.setDefaultElementManager(defaultElementManager);
        gArray.setUDP1(udp1);
        gArray.setUDP2(udp2);
        gArray.setUDP3(udp3);
        this.setStatus(gArray, detectable, propagatedStatus);
    }

    public void populateTapeLibrary(ResultSet resultSet, GraphTapeLibrary gTapeLibrary) throws SQLException {
        String firmwareVersion = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String serialNumber = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String defaultElementManager = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        Integer totalCartridges = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_CARTRIDGES"));
        Integer totalDrives = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_DRIVES"));
        Integer maxNumOfCartridges = (Integer)this.getUpdateDictionary(resultSet.getObject("MAX_CARTRIDGES"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer consolidatedStat = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        gTapeLibrary.setFirmwareVersion(firmwareVersion);
        gTapeLibrary.setVendor(vendor);
        gTapeLibrary.setModel(model);
        gTapeLibrary.setMaxNumOfCartridges(maxNumOfCartridges);
        gTapeLibrary.setNumOfCartridges(totalCartridges);
        gTapeLibrary.setNumOfDrives(totalDrives);
        gTapeLibrary.setDisplayName(displayName);
        gTapeLibrary.setSerialNumber(serialNumber);
        gTapeLibrary.setDefaultElementManager(defaultElementManager);
        gTapeLibrary.setUDP1(udp1);
        gTapeLibrary.setUDP2(udp2);
        gTapeLibrary.setUDP3(udp3);
        gTapeLibrary.setOperationalStatus(operationalStatus);
        this.setStatus(gTapeLibrary, detectable, propagatedStatus);
    }

    public void populateTapeDrive(ResultSet resultSet, GraphTapeDrive gTapeDrive) throws SQLException {
        Integer consolidatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer needsCleaning = (Integer)this.getUpdateDictionary(resultSet.getObject("NEEDS_CLEANING"));
        Long mountCount = (Long)this.getUpdateDictionary(resultSet.getObject("MOUNT_COUNT"));
        String location = (String)this.getUpdateDictionary(resultSet.getObject("LOCATION"));
        String firmwareVersion = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        if (needsCleaning != null && new Integer(1).equals(needsCleaning)) {
            gTapeDrive.setNeedCleaning(Boolean.TRUE);
        } else {
            gTapeDrive.setNeedCleaning(Boolean.FALSE);
        }
        gTapeDrive.setFirmwareVersion(firmwareVersion);
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        gTapeDrive.setDisplayName(displayName);
        gTapeDrive.setOperationalStatus(operationalStatus);
        gTapeDrive.setMountCount(mountCount);
        gTapeDrive.setLocation(location);
        gTapeDrive.setUDP1(udp1);
        gTapeDrive.setUDP2(udp2);
        gTapeDrive.setUDP3(udp3);
        this.setStatus(gTapeDrive, detectable, propagatedStatus);
    }

    public void populateTapeMediaChanger(ResultSet resultSet, GraphMediaChanger gTapeMediaChanger) throws SQLException {
        Integer consolidatedStat = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        String firmwareVersion = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        gTapeMediaChanger.setFirmwareVersion(firmwareVersion);
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        gTapeMediaChanger.setDisplayName(displayName);
        gTapeMediaChanger.setOperationalStatus(operationalStatus);
        gTapeMediaChanger.setUDP1(udp1);
        gTapeMediaChanger.setUDP2(udp2);
        gTapeMediaChanger.setUDP3(udp3);
        this.setStatus(gTapeMediaChanger, detectable, propagatedStatus);
    }

    public void populateSwitch(ResultSet resultSet, GraphSwitch gSwitch, boolean usePropagatedStatus) throws SQLException {
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String logicalName = (String)this.getUpdateDictionary(resultSet.getObject("LOGICAL_NAME"));
        String switchWwn = (String)this.getUpdateDictionary(resultSet.getObject("SWITCH_WWN"));
        String serialNumber = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String description = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        String ipAddress = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String domain = (String)this.getUpdateDictionary(resultSet.getObject("DOMAIN"));
        String version = (String)this.getUpdateDictionary(resultSet.getObject("VERSION"));
        String defaultElementManager = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String parentSwitchWwn = (String)this.getUpdateDictionary(resultSet.getObject("PARENT_SWITCH_WWN"));
        gSwitch.setVendor(vendor);
        gSwitch.setModel(model);
        gSwitch.setLogicalName(logicalName);
        gSwitch.setWWN(switchWwn);
        gSwitch.setSerialNumber(serialNumber);
        gSwitch.setDescription(description);
        gSwitch.setIPAddress(ipAddress);
        gSwitch.setDomain(domain);
        gSwitch.setVersion(version);
        gSwitch.setDisplayName(displayName);
        gSwitch.setParentWWN(parentSwitchWwn);
        gSwitch.setUDP1(udp1);
        gSwitch.setUDP2(udp2);
        gSwitch.setUDP3(udp3);
        gSwitch.setDefaultElementManager(defaultElementManager);
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gSwitch.setOperationalStatus(operationalStatus);
        this.setStatus(gSwitch, detectable, propagatedStatus);
    }

    public void populateHost(ResultSet resultSet, GraphComputer gHost) throws SQLException {
        boolean bothAgnts;
        String GUID2 = (String)this.getUpdateDictionary(resultSet.getObject("GUID"));
        String hostName = (String)this.getUpdateDictionary(resultSet.getObject("HOST_NAME"));
        String osType = (String)this.getUpdateDictionary(this.getOsType((Integer)resultSet.getObject("OS_TYPE")));
        String osVersion = (String)this.getUpdateDictionary(resultSet.getObject("OS_VERSION"));
        String ipAddress = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String datAgnt = (String)this.getUpdateDictionary(resultSet.getObject("DAT_STATUS"));
        String devAgnt = (String)this.getUpdateDictionary(resultSet.getObject("DEV_STATUS"));
        Object cpuArchitecture = null;
        gHost.setGUID(GUID2);
        gHost.setOSType(osType);
        gHost.setOSVersion(osVersion);
        gHost.setHostname(hostName);
        gHost.setIPAddress(ipAddress);
        boolean bl = bothAgnts = datAgnt != null && devAgnt != null;
        if (devAgnt != null) {
            devAgnt = devAgnt.trim();
        }
        String agents = (datAgnt != null ? "data(" + datAgnt + ")" : "") + (bothAgnts ? "," : "") + (devAgnt != null ? "device(" + devAgnt + ")" : "");
        gHost.setAgentsInstalled((String)this.getUpdateDictionary(agents));
        gHost.setDisplayName(displayName);
        gHost.setUDP1(udp1);
        gHost.setUDP2(udp2);
        gHost.setUDP3(udp3);
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gHost.setOperationalStatus(operationalStatus);
        this.setStatus(gHost, detectable, propagatedStatus);
    }

    public void populateHBA(ResultSet resultSet, GraphHBA gHba, boolean usePropagatedStatus) throws SQLException {
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        Integer apiVersion = (Integer)this.getUpdateDictionary(resultSet.getObject("API_VERSION"));
        String wwn = (String)this.getUpdateDictionary(resultSet.getObject("HBA_WWN"));
        String firmwareVersion = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String serialNumber = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String driverVersion = (String)this.getUpdateDictionary(resultSet.getObject("DRIVER_VERSION"));
        String driverName = (String)this.getUpdateDictionary(resultSet.getObject("DRIVER_NAME"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        gHba.setVendor(vendor);
        gHba.setModel(model);
        gHba.setWWN(wwn);
        gHba.setFirmwareVersion(firmwareVersion);
        gHba.setSerialNumber(serialNumber);
        gHba.setDriverVersion(driverVersion);
        gHba.setDriverName(driverName);
        gHba.setDisplayName(displayName);
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gHba.setOperationalStatus(operationalStatus);
        this.setStatus(gHba, detectable, propagatedStatus);
    }

    public void populateOther(ResultSet resultSet, GraphOther gOther) throws SQLException {
        Integer displayType = (Integer)this.getUpdateDictionary(resultSet.getObject("DISPLAY_TYPE"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String serial = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        gOther.setDisplayName(displayName);
        gOther.setType(displayType);
        gOther.setVendor(vendor);
        gOther.setModel(model);
        gOther.setSerialNumber(serial);
        this.setStatus(gOther, detectable, propagatedStatus);
    }

    public void populatePort(ResultSet resultSet, GraphFCPort gFCPort) throws SQLException {
        Integer type = (Integer)this.getUpdateDictionary(resultSet.getObject("TYPE"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String portNumber = (String)this.getUpdateDictionary(resultSet.getObject("PORT_NUMBER"));
        String name = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        Long portSpeed = (Long)this.getUpdateDictionary(resultSet.getObject("PORT_SPEED"));
        gFCPort.setName(name);
        gFCPort.setType((String)this.getUpdateDictionary(this.getPortType(type)));
        gFCPort.setPortNumber(portNumber);
        gFCPort.setDisplayName(displayName);
        gFCPort.setPortSpeed(portSpeed);
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gFCPort.setOperationalStatus(operationalStatus);
        this.setStatus(gFCPort, detectable, consolidateStatus);
    }

    public void populatePort2Port(ResultSet resultSet, GraphEntity gNode) throws SQLException {
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        if (detectable == null) {
            gNode.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        } else if (detectable == 0) {
            gNode.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        } else {
            gNode.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        }
    }

    public void populateZone(ResultSet resultSet, GraphZone gZone) throws SQLException {
        Integer zoneTypeVal = (Integer)this.getUpdateDictionary(resultSet.getObject("ZONE_TYPE"));
        String zoneType = null;
        Integer activeVal = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean active = null;
        active = activeVal != null && activeVal == 1 ? Boolean.TRUE : Boolean.FALSE;
        String fabricWwn = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String zoneName = (String)this.getUpdateDictionary(resultSet.getObject("ZONE_NAME"));
        String description = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        gZone.setActive(active);
        gZone.setDescription(description);
        gZone.setZoneType(zoneType);
        gZone.setDisplayName(zoneName);
        gZone.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
    }

    public void populateZoneSet(ResultSet resultSet, GraphZoneSet gZoneSet) throws SQLException {
        Integer activeVal = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean active = null;
        active = activeVal != null && activeVal == 1 ? Boolean.TRUE : Boolean.FALSE;
        String fabricWwn = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String zoneSetName = (String)this.getUpdateDictionary(resultSet.getObject("ZSET_NAME"));
        String description = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        gZoneSet.setActive(active);
        gZoneSet.setDescription(description);
        gZoneSet.setDisplayName(zoneSetName);
        gZoneSet.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
    }

    public void populateLUN(ResultSet resultSet, GraphLun gLun) throws SQLException {
        Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
        Integer hostId = (Integer)resultSet.getObject("HOST_ID");
        Integer targetId = (Integer)resultSet.getObject("TARGET_ID");
        Integer lunId = (Integer)resultSet.getObject("DEVICE_LUN_ID");
        Integer deviceId = (Integer)resultSet.getObject("DEVICE_ID");
        String path = (String)resultSet.getObject("PATH");
        BigDecimal capacity = (BigDecimal)resultSet.getObject("CAPACITY");
        BigDecimal freespace = (BigDecimal)resultSet.getObject("FREE_SPACE");
        Integer consolidated_status = (Integer)resultSet.getObject("CONSOLIDATED_STATUS");
        Integer operational_status = (Integer)resultSet.getObject("OPERATIONAL_STATUS");
        gLun.setLunID(lunId);
        gLun.setCapacity(capacity == null ? null : new Long(capacity.longValue()));
        gLun.setFreeSpace(freespace == null ? null : new Long(freespace.longValue()));
        gLun.setOperationalStatus(operational_status);
        gLun.setDisplayName(path);
        gLun.setSCSITargetID(targetId);
        this.setStatus(gLun, new Integer(1), consolidated_status);
    }

    public void populateStoragePool(ResultSet resultSet, GraphPool gPool) throws SQLException {
        Long totalManagedSpace = (Long)this.getUpdateDictionary(resultSet.getObject("TOTAL_MANAGED_SPACE"));
        Long remaningManagedSpace = (Long)this.getUpdateDictionary(resultSet.getObject("REMAINING_MANAGED_SPACE"));
        String RAIDLevel = (String)this.getUpdateDictionary(resultSet.getObject("RAID_LEVEL"));
        Integer primordialVal = (Integer)this.getUpdateDictionary(resultSet.getObject("PRIMORDIAL"));
        Boolean primordial = null;
        primordial = primordialVal != null && primordialVal == 1 ? Boolean.TRUE : Boolean.FALSE;
        Integer numOfStorageVolumes = (Integer)this.getUpdateDictionary(resultSet.getObject("NUMBER_OF_STORAGE_VOLUMES"));
        Integer totalDisks = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_DISKS"));
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        gPool.setNumOfDisks(totalDisks);
        gPool.setTotalManagedSpace(totalManagedSpace);
        gPool.setRemainingManagedSpace(remaningManagedSpace);
        gPool.setRAIDLevel(RAIDLevel);
        gPool.setPrimodial(primordial);
        gPool.setNumOfVolumes(numOfStorageVolumes);
        gPool.setUDP1(udp1);
        gPool.setUDP2(udp2);
        gPool.setUDP3(udp3);
        gPool.setDisplayName(displayName);
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gPool.setOperationalStatus(operationalStatus);
        Integer propagatedStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        this.setStatus(gPool, detectable, consolidateStatus);
    }

    public void populateStorageVolume(ResultSet resultSet, GraphVolume gVolume) throws SQLException {
        Long capacity = (Long)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        Integer isAssigned = (Integer)this.getUpdateDictionary(resultSet.getObject("IS_ASSIGNED"));
        Boolean _isAssigned = null;
        if (isAssigned != null) {
            if (isAssigned == 1) {
                _isAssigned = Boolean.TRUE;
            } else if (isAssigned == 0) {
                _isAssigned = Boolean.FALSE;
            }
        }
        Integer format = (Integer)this.getUpdateDictionary(resultSet.getObject("FORMAT"));
        Integer gvFormat = GraphVolume.FORMAT_FB;
        if (format != null) {
            if (format >= 1 && format <= 4) {
                gvFormat = GraphVolume.FORMAT_FB;
            } else if (format == 5) {
                gvFormat = GraphVolume.FORMAT_CKD_3380;
            } else if (format == 6) {
                gvFormat = GraphVolume.FORMAT_CKD_3390;
            }
        }
        String udp1 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String udp2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String udp3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        gVolume.setIsAssigned(_isAssigned);
        gVolume.setCapacity(capacity);
        gVolume.setUDP1(udp1);
        gVolume.setUDP2(udp2);
        gVolume.setUDP3(udp3);
        gVolume.setDisplayName(displayName);
        gVolume.setFormat(gvFormat);
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        gVolume.setOperationalStatus(operationalStatus);
        this.setStatus(gVolume, detectable, consolidateStatus);
    }

    public void populateStorageDisk(ResultSet resultSet, GraphDisk gDisk) throws SQLException {
        Long capacity = (Long)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        String displayName = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String vendor = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String model = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String serialNumber = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        Integer operationalStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer detectable = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer consolidateStatus = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        gDisk.setCapacity(capacity);
        gDisk.setSerialNumber(serialNumber);
        gDisk.setDisplayName(displayName);
        gDisk.setVendor(vendor);
        gDisk.setModel(model);
        gDisk.setOperationalStatus(operationalStatus);
        this.setStatus(gDisk, detectable, consolidateStatus);
    }

    public void populateVolumeGroup(ResultSet resultSet, GraphSwitch gSwitch) throws SQLException {
    }
}

