/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerOtherL0
extends ViewerSanL1 {
    public static boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on \tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tOTHER.VENDOR_ID = VENDOR.VENDOR_ID ";
    public static final String SELECT_SANS_FROM_OTHER = "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOther(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerOtherL0.class.getName(), "getOther", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("other...");
        }
        GraphOther gOther = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_OTHER);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer otherID = (Integer)resultSet.getObject("OTHER_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                String otherKey = prefixId + otherID;
                if (entityMap == null || entityMap.get(otherKey) == null) {
                    gOther = new GraphOther(otherKey);
                    this.populator.populateOther(resultSet, gOther);
                    model.put(gOther);
                    entityMap.put(otherKey, gOther);
                    if (model != null) {
                        model.put(gOther);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(otherKey, gOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + otherKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getOther", e);
                }
            }
        }
        if (debug) {
            System.out.println("other totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerOtherL0.class.getName(), "getOther", "");
        }
    }

    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        this.getSansFromUnknown(con, model, entityMap, (Object[])null, SELECT_SANS_FROM_OTHER);
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerOtherL0.class.getName(), "getView", "");
        }
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            GraphModelOtherL0 gModel = new GraphModelOtherL0((GraphModelOtherL0.ID)rqst.getModelID());
            this.getOther(con, gModel, entityMap);
            gModel.setWithZoneData(true);
            this.commit(con);
            resp.addResponse(0, gModel);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerOtherL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

