/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelOverview;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerRoot {
    static boolean debug = false;
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static String SELECT_COUNT_ENTITIES = "  SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status is NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'switch' type,           MIN((case when SWITCH.DETECTABLE = 1 then SWITCH.PROPAGATED_STATUS WHEN SWITCH.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when SWITCH.DETECTABLE = 1 then SWITCH.PROPAGATED_STATUS WHEN SWITCH.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS,           COUNT(SWITCH.SWITCH_ID) TOTAL,           COUNT(CASE WHEN SWITCH.PROPAGATED_STATUS > 0 and SWITCH.PROPAGATED_STATUS != 4 THEN SWITCH.SWITCH_ID WHEN SWITCH.DETECTABLE = 0 THEN SWITCH.SWITCH_ID else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VSWITCH SWITCH) TMP2   UNION   SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'san' type, MIN((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\t\t\tMAX((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(FABRIC.FABRIC_ID) TOTAL,           COUNT(CASE WHEN FABRIC.PROPAGATED_STATUS > 0 and FABRIC.PROPAGATED_STATUS != 4 THEN FABRIC.FABRIC_ID                          WHEN FABRIC.DETECTABLE = 0 THEN FABRIC.FABRIC_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_RES_FABRIC FABRIC) TMP2   UNION   SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'vsan' type, MIN((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(FABRIC.FABRIC_ID) TOTAL,           COUNT(CASE WHEN FABRIC.PROPAGATED_STATUS > 0 and FABRIC.PROPAGATED_STATUS != 4 THEN FABRIC.FABRIC_ID                          WHEN FABRIC.DETECTABLE = 0 THEN FABRIC.FABRIC_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_RES_FABRIC FABRIC        WHERE \t\t\tFABRIC.PARENT_FABRIC_WWN IS NOT NULL) TMP2    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'host' type, MIN((case when HOST.DETECTABLE = 1 then HOST.PROPAGATED_STATUS WHEN HOST.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when HOST.DETECTABLE = 1 then HOST.PROPAGATED_STATUS WHEN HOST.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(HOST.COMPUTER_ID) TOTAL,           COUNT(CASE WHEN HOST.PROPAGATED_STATUS > 0 and HOST.PROPAGATED_STATUS != 4 THEN HOST.COMPUTER_ID                          WHEN HOST.DETECTABLE = 0 THEN HOST.COMPUTER_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VHOST HOST) TMP2    UNION    SELECT        TMP1.TYPE TYPE,        TMP1.TOTAL TOTAL,        TMP1.ABNORMAL ABNORMAL,        case            when TMP1.max_gui_status = 0 then 0            when TMP1.min_gui_status = 2 then 2            when TMP1.min_gui_status = 3 then 3            when TMP1.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT 'subsystem' TYPE, MIN(TMP2.MIN_GUI_STATUS) MIN_GUI_STATUS, MAX(TMP2.MAX_GUI_STATUS) MAX_GUI_STATUS, SUM(TMP2.TOTAL) TOTAL, SUM(TMP2.ABNORMAL) ABNORMAL        FROM        (SELECT           MIN((case when SUBSYSTEM.DETECTABLE = 1 then SUBSYSTEM.PROPAGATED_STATUS WHEN SUBSYSTEM.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when SUBSYSTEM.DETECTABLE = 1 then SUBSYSTEM.PROPAGATED_STATUS WHEN SUBSYSTEM.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(SUBSYSTEM.SUBSYSTEM_ID) TOTAL,           COUNT(CASE WHEN SUBSYSTEM.PROPAGATED_STATUS > 0 and SUBSYSTEM.PROPAGATED_STATUS != 4 THEN SUBSYSTEM.SUBSYSTEM_ID                          WHEN SUBSYSTEM.DETECTABLE = 0 THEN SUBSYSTEM.SUBSYSTEM_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM        UNION        SELECT           MIN((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, 0 TOTAL, 0 ABNORMAL        FROM           T_RES_TAPE_LIBRARY TAPE        ) TMP2) TMP1    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'tape' type, MIN((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(TAPE.TAPE_LIBRARY_ID) TOTAL,            COUNT(CASE WHEN TAPE.PROPAGATED_STATUS > 0 and TAPE.PROPAGATED_STATUS != 4 THEN TAPE.TAPE_LIBRARY_ID                          WHEN TAPE.DETECTABLE = 0 THEN TAPE.TAPE_LIBRARY_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VTAPE_LIBRARY TAPE) TMP2    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'other' type, MIN((case when OTHER.DETECTABLE = 1 then OTHER.PROPAGATED_STATUS WHEN OTHER.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when OTHER.DETECTABLE = 1 then OTHER.PROPAGATED_STATUS WHEN OTHER.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(OTHER.PREFIX_ID) TOTAL,            COUNT(CASE WHEN OTHER.PROPAGATED_STATUS > 0 and OTHER.PROPAGATED_STATUS != 4 THEN OTHER.OTHER_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM T_VIEW_VOTHER OTHER ) TMP2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotals(Connection con, GraphModel model) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRoot.class.getName(), "getView", "");
        }
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(SELECT_COUNT_ENTITIES);
            resultSet = stmt.executeQuery();
            GraphFabricSummary sanL0 = new GraphFabricSummary("SanL0");
            sanL0.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC"));
            sanL0.setNumOfFabrics(new Integer(0));
            sanL0.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            sanL0.setNumOfAbnormalFabrics(new Integer(0));
            sanL0.setNumOfAbnormalVirtualFabrics(new Integer(0));
            sanL0.setNumOfVirtualFabrics(new Integer(0));
            GraphStorageSummary storageL0 = new GraphStorageSummary("StorageL0");
            storageL0.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_STORAGE"));
            storageL0.setNumOfSubsystems(new Integer(0));
            storageL0.setNumOfTapeLibraries(new Integer(0));
            storageL0.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            storageL0.setNumOfAbnormalSubsystems(new Integer(0));
            storageL0.setNumOfAbnormalTapeLibraries(new Integer(0));
            GraphComputerSummary hostL0 = new GraphComputerSummary("HostL0");
            hostL0.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER"));
            hostL0.setNumOfComputers(new Integer(0));
            hostL0.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            hostL0.setNumOfAbnormalComputers(new Integer(0));
            GraphOtherSummary otherL0 = new GraphOtherSummary("Others");
            otherL0.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER"));
            otherL0.setNumOfOthers(new Integer(0));
            otherL0.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            otherL0.setNumOfAbnormalOthers(new Integer(0));
            GraphSwitchSummary switchesL0 = new GraphSwitchSummary("Switches");
            switchesL0.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"));
            switchesL0.setNumOfSwitches(new Integer(0));
            switchesL0.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            switchesL0.setNumOfAbnormalSwitches(new Integer(0));
            while (resultSet.next()) {
                int total = resultSet.getInt("TOTAL");
                String type = ((String)resultSet.getObject("TYPE")).trim();
                Integer propagatedStatus = (Integer)resultSet.getObject("PROPAGATED_STATUS");
                Integer abnormalCtr = (Integer)resultSet.getObject("ABNORMAL");
                Integer status = null;
                status = propagatedStatus;
                Integer guiStatus = GraphModelConstant.STATUS_UNKNOWN;
                if (status != null) {
                    switch (status) {
                        case 0: {
                            guiStatus = GraphModelConstant.STATUS_NORMAL;
                            break;
                        }
                        case 1: {
                            guiStatus = GraphModelConstant.STATUS_WARNING;
                            break;
                        }
                        case 2: {
                            guiStatus = GraphModelConstant.STATUS_CRITICAL;
                            break;
                        }
                        case 3: {
                            guiStatus = GraphModelConstant.STATUS_MISSING;
                        }
                    }
                }
                if ("san".equals(type)) {
                    sanL0.setNumOfFabrics(new Integer(total));
                    sanL0.setNumOfAbnormalFabrics(abnormalCtr);
                    sanL0.setHealthStatus(guiStatus);
                    continue;
                }
                if ("vsan".equals(type)) {
                    sanL0.setNumOfVirtualFabrics(new Integer(total));
                    sanL0.setNumOfAbnormalVirtualFabrics(abnormalCtr);
                    continue;
                }
                if ("switch".equals(type)) {
                    switchesL0.setNumOfSwitches(new Integer(total));
                    switchesL0.setNumOfAbnormalSwitches(abnormalCtr);
                    switchesL0.setHealthStatus(guiStatus);
                    continue;
                }
                if ("host".equals(type)) {
                    hostL0.setNumOfComputers(new Integer(total));
                    hostL0.setHealthStatus(guiStatus);
                    hostL0.setNumOfAbnormalComputers(abnormalCtr);
                    continue;
                }
                if ("subsystem".equals(type)) {
                    storageL0.setNumOfSubsystems(new Integer(total));
                    storageL0.setNumOfAbnormalSubsystems(abnormalCtr);
                    storageL0.setHealthStatus(guiStatus);
                    continue;
                }
                if ("tape".equals(type)) {
                    storageL0.setNumOfTapeLibraries(new Integer(total));
                    storageL0.setNumOfAbnormalTapeLibraries(abnormalCtr);
                    continue;
                }
                if (!"other".equals(type)) continue;
                otherL0.setNumOfOthers(new Integer(total));
                otherL0.setNumOfAbnormalOthers(abnormalCtr);
                otherL0.setHealthStatus(guiStatus);
            }
            model.put(sanL0);
            model.put(hostL0);
            model.put(storageL0);
            model.put(otherL0);
            model.put(switchesL0);
        }
        finally {
            block31: {
                block30: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block30;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getTotal", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block31;
                    TraceLogger.exception(ViewerRoot.class.getName(), "getTotal", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRoot.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRoot.class.getName(), "getView", "");
        }
        GraphModelOverview gModel = new GraphModelOverview((GraphModelOverview.ID)rqst.getModelID());
        HashMap entityMap = new HashMap();
        long init = System.currentTimeMillis();
        Object stmt = null;
        Object resultSet = null;
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            this.getTotals(con, gModel);
            this.commit(con);
            gModel.setWithZoneData(true);
            resp.addResponse(0, gModel);
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRoot.class.getName(), "getView", "");
        }
    }

    public static void main(String[] args) {
    }
}

