/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerRoot;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerSanL0 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SAN = "SELECT distinct \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 , \tPARENT.FABRIC_ID PARENT_FABRIC_ID from     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN ORDER by PARENT.FABRIC_ID DESC";
    public static String COUNT_OTHER_FROM_SAN = "select \tcount (OTHER2FABRIC.PREFIX_ID) TOTAL from T_VIEW_VOTHER2FABRIC OTHER2FABRIC where \tOTHER2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_OTHER_FROM_SAN = "select    COUNT(CASE WHEN OTHER.PROPAGATED_STATUS > 0 and OTHER.PROPAGATED_STATUS != 4 THEN OTHER2FABRIC.PREFIX_ID             else cast(null as char) END) TOTAL from \tT_VIEW_VOTHER2FABRIC OTHER2FABRIC, T_VIEW_VOTHER OTHER where \tOTHER2FABRIC.FABRIC_ID = ? and    OTHER2FABRIC.PREFIX_ID = OTHER.PREFIX_ID and    OTHER2FABRIC.OTHER_ID = OTHER.OTHER_ID";
    public static String COUNT_ARRAY_FROM_SAN = "select \tCOUNT(SUBSYSTEM2FABRIC.SUBSYSTEM_ID) TOTAL FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC WHERE \tSUBSYSTEM2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_ARRAY_FROM_SAN = "select \tCOUNT(CASE WHEN SUBSYSTEM.PROPAGATED_STATUS > 0 AND SUBSYSTEM.PROPAGATED_STATUS != 4\t\t  THEN SUBSYSTEM.SUBSYSTEM_ID\t\t  WHEN SUBSYSTEM.DETECTABLE = 0 THEN SUBSYSTEM.SUBSYSTEM_ID\t\t  ELSE cast (NULL as integer) END) TOTAL FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM WHERE \tSUBSYSTEM2FABRIC.FABRIC_ID = ? and    SUBSYSTEM2FABRIC.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID and    SUBSYSTEM2FABRIC.PREFIX_ID = SUBSYSTEM.PREFIX_ID";
    public static String COUNT_TAPE_FROM_SAN = "SELECT \tCOUNT(TAPE2FABRIC.TAPE_LIBRARY_ID) TOTAL FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.FABRIC_ID = ?";
    public static String COUNT_ABNORMAL_TAPE_FROM_SAN = "SELECT    COUNT(CASE WHEN TAPE.PROPAGATED_STATUS > 0 and TAPE.PROPAGATED_STATUS != 4 THEN TAPE.TAPE_LIBRARY_ID    \t  \tWHEN TAPE.DETECTABLE = 0 THEN TAPE.TAPE_LIBRARY_ID            else cast (null as integer) END) TOTAL FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC, T_VIEW_VTAPE_LIBRARY TAPE WHERE     TAPE2FABRIC.FABRIC_ID = ? and     TAPE2FABRIC.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID and  \t TAPE2FABRIC.PREFIX_ID = TAPE.PREFIX_ID ";
    public static String COUNT_HOST_FROM_SAN = "SELECT \t\tcount(HOST2FABRIC.HOST_ID) TOTAL FROM T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE    HOST2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_HOST_FROM_SAN = "SELECT    COUNT(CASE WHEN HOST.PROPAGATED_STATUS > 0 and HOST.PROPAGATED_STATUS != 4 THEN HOST.COMPUTER_ID    \t  \tWHEN HOST.DETECTABLE = 0 THEN HOST.COMPUTER_ID            else cast (null as integer) END) TOTAL FROM T_VIEW_VHOST2FABRIC HOST2FABRIC,\t\tT_VIEW_VHOST HOST WHERE    HOST2FABRIC.FABRIC_ID = ? and   HOST2FABRIC.PREFIX_ID = HOST.PREFIX_ID and \t  HOST2FABRIC.HOST_ID = HOST.COMPUTER_ID  ";
    public static String COUNT_SWITCH_FROM_SAN = "SELECT  \tCOUNT(distinct SWITCH.SWITCH_WWN) TOTAL from T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH WHERE \tSWITCH2FABRIC.FABRIC_ID = ? and   SWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID ";
    public static String COUNT_ABNORMAL_SWITCH_FROM_SAN = "SELECT     COUNT(CASE WHEN SWITCH.PROPAGATED_STATUS > 0 and SWITCH.PROPAGATED_STATUS != 4 THEN SWITCH.SWITCH_WWN    \t  \tWHEN SWITCH.DETECTABLE = 0 THEN SWITCH.SWITCH_WWN            else null END) TOTAL FROM T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH where \tSWITCH2FABRIC.FABRIC_ID = ? and    SWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalSingle(Connection con, String query, Integer sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL0.class.getName(), "getView", "");
        }
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                int total = resultSet.getInt("TOTAL");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=" + total);
                }
                int n = total;
                return n;
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public static int getTotal(Connection con, String query, Integer sanId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL0.class.getName(), "getView", "");
        }
        GraphModelFabricL0 gModel = new GraphModelFabricL0((GraphModelFabricL0.ID)rqst.getModelID());
        HashMap<String, GraphEntity> entityMap = new HashMap<String, GraphEntity>();
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            Timestamp prevUpdate = rqst.getTimestamp();
            Timestamp lastUpdate = null;
            if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
                stmt = con.prepareStatement(SELECT_SAN);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    Integer sanId = (Integer)resultSet.getObject("FABRIC_ID");
                    if (sanId == null) continue;
                    String sanKey = "fabric:" + sanId;
                    if (entityMap.get(sanKey) == null) {
                        Integer fabricId = (Integer)resultSet.getObject("PARENT_FABRIC_ID");
                        GraphFabric gSan = new GraphFabric(sanKey);
                        int totalSwitchesInSan = ViewerSanL0.getTotalSingle(con, COUNT_SWITCH_FROM_SAN, sanId);
                        int totalHostsInSan = ViewerSanL0.getTotalSingle(con, COUNT_HOST_FROM_SAN, sanId);
                        int totalSubsystemsInSan = ViewerSanL0.getTotalSingle(con, COUNT_ARRAY_FROM_SAN, sanId);
                        int totalTapesInSan = ViewerSanL0.getTotalSingle(con, COUNT_TAPE_FROM_SAN, sanId);
                        int totalOthersInSan = ViewerSanL0.getTotalSingle(con, COUNT_OTHER_FROM_SAN, sanId);
                        this.populator.populateSan(resultSet, gSan);
                        gSan.setNumOfComputers(new Integer(totalHostsInSan));
                        gSan.setNumOfSubsystems(new Integer(totalSubsystemsInSan));
                        gSan.setNumOfSwitches(new Integer(totalSwitchesInSan));
                        gSan.setNumOfTapeLibraries(new Integer(totalTapesInSan));
                        gSan.setNumOfOthers(new Integer(totalOthersInSan));
                        totalSwitchesInSan = ViewerSanL0.getTotalSingle(con, COUNT_ABNORMAL_SWITCH_FROM_SAN, sanId);
                        totalHostsInSan = ViewerSanL0.getTotalSingle(con, COUNT_ABNORMAL_HOST_FROM_SAN, sanId);
                        totalSubsystemsInSan = ViewerSanL0.getTotalSingle(con, COUNT_ABNORMAL_ARRAY_FROM_SAN, sanId);
                        totalTapesInSan = ViewerSanL0.getTotalSingle(con, COUNT_ABNORMAL_TAPE_FROM_SAN, sanId);
                        totalOthersInSan = ViewerSanL0.getTotalSingle(con, COUNT_ABNORMAL_OTHER_FROM_SAN, sanId);
                        gSan.setNumOfAbnormalComputers(new Integer(totalHostsInSan));
                        gSan.setNumOfAbnormalSubsystems(new Integer(totalSubsystemsInSan));
                        gSan.setNumOfAbnormalSwitches(new Integer(totalSwitchesInSan));
                        gSan.setNumOfAbnormalTapeLibraries(new Integer(totalTapesInSan));
                        gSan.setNumOfAbnormalOthers(new Integer(totalOthersInSan));
                        if (fabricId != null) {
                            GraphFabric parentSan = (GraphFabric)entityMap.get("fabric:" + fabricId);
                            if (parentSan != null) {
                                String keySan2VsanKey = "fabric2vfabric:" + fabricId + ',' + sanId;
                                GraphFabric2VirtualFabric san2vsanGraph = new GraphFabric2VirtualFabric(keySan2VsanKey);
                                san2vsanGraph.setFabricID((GraphFabric.ID)parentSan.getEntityID());
                                san2vsanGraph.setVirtualFabricID((GraphFabric.ID)gSan.getEntityID());
                                entityMap.put(keySan2VsanKey, san2vsanGraph);
                                gModel.put(san2vsanGraph);
                            } else if (TraceLogger.enableTrace) {
                                TraceLogger.traceMessage(1, ViewerSanL0.class.getName(), "getView", "Parent SAN not found: fabric:" + fabricId);
                            }
                        }
                        entityMap.put(sanKey, gSan);
                        gModel.put(gSan);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL0.class.getName(), "getView", "San already exists:" + sanKey);
                }
                gModel.setWithZoneData(true);
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, null);
            }
        }
        finally {
            block25: {
                block24: {
                    this.commit(con);
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerRoot.class.getName(), "getView", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

