/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;

public class ViewerSanL1
extends ViewerSanL0 {
    private static boolean debug = false;
    public static final String SELECT_SWITCH2SWITCH_FROM_SAN = "SELECT DISTINCT \tSWITCH2SWITCH.SWITCH_PREFIX_ID1,    SWITCH2SWITCH.SWITCH_ID1 SWITCH1_ID, \tSWITCH2SWITCH.SWITCH_PREFIX_ID2,    SWITCH2SWITCH.SWITCH_ID2 SWITCH2_ID, \tSWITCH2SWITCH.PORT2PORT_ID PORT2PORT_ID, \tSWITCH2SWITCH.DETECTABLE DETECTABLE FROM (select \n\t  SWITCH1.PREFIX_ID SWITCH_PREFIX_ID1, \n     SWITCH1.SWITCH_ID SWITCH_ID1, \n     SWITCH2PORT1.PORT_ID SWITCH1_PORT_ID, \n\t  SWITCH2.PREFIX_ID SWITCH_PREFIX_ID2, \n     SWITCH2.SWITCH_ID SWITCH_ID2,\n     SWITCH2PORT2.PORT_ID SWITCH2_PORT_ID, \n\t  PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\n\t  PORT2PORT.DETECTABLE DETECTABLE \nFROM \nT_VIEW_PORT2PORT PORT2PORT, \n     T_VIEW_VSWITCH SWITCH2, T_VIEW_VSWITCH2PORT SWITCH2PORT1, T_VIEW_VSWITCH2PORT SWITCH2PORT2, \n\t  T_VIEW_VSWITCH SWITCH1 left outer join T_VIEW_VSWITCH SWITCH3 on \n     SWITCH1.SWITCH_WWN = SWITCH3.PARENT_SWITCH_WWN \nWHERE \n     SWITCH3.SWITCH_WWN is NULL and \n\t  SWITCH1.PREFIX_ID = SWITCH2PORT1.PREFIX_ID and \n\t  SWITCH1.SWITCH_ID = SWITCH2PORT1.SWITCH_ID and \n     SWITCH2PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \n     PORT2PORT.PORT_ID2 = SWITCH2PORT2.PORT_ID and \n     SWITCH2PORT2.PREFIX_ID = SWITCH2.PREFIX_ID and \n\t  SWITCH2PORT2.SWITCH_ID = SWITCH2.SWITCH_ID \n) SWITCH2SWITCH,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC1, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC2 WHERE    SWITCH2FABRIC1.FABRIC_ID = ? and    SWITCH2FABRIC1.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID1 and    SWITCH2FABRIC2.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID2 and    SWITCH2FABRIC1.FABRIC_ID = SWITCH2FABRIC2.FABRIC_ID";
    public static String SELECT_SWITCH_FROM_SAN = "SELECT DISTINCT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM    T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC,    T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID WHERE \tSWITCH2FABRIC.FABRIC_ID = ? and    SWITCH2FABRIC.SWITCH_ID = T_RES_SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = T_RES_SWITCH.PREFIX_ID";
    public static String SELECT_SAN = "SELECT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_RES_FABRIC left outer join T_RES_FABRIC PARENT on \tT_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE \tT_RES_FABRIC.FABRIC_ID = ? ";
    public static String SELECT_HOST_FROM_SAN = "SELECT  \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2FABRIC HOST2FABRIC, \tT_VIEW_VHOST T_RES_HOST WHERE \tT_RES_HOST.COMPUTER_ID = HOST2FABRIC.HOST_ID and \tHOST2FABRIC.FABRIC_ID = ? ";
    public static String SELECT_SANS_FROM_HOST_FROM_SAN = "SELECT     HOST2FABRIC1.FABRIC_ID,     HOST2FABRIC1.PREFIX_ID, \t HOST2FABRIC1.HOST_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC1,T_VIEW_VHOST2FABRIC HOST2FABRIC2 WHERE     HOST2FABRIC1.PREFIX_ID = HOST2FABRIC2.HOST_ID and \t HOST2FABRIC1.HOST_ID = HOST2FABRIC2.HOST_ID and     HOST2FABRIC2.FABRIC_ID = ?";
    public static String SELECT_ARRAY_FROM_SAN = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC,    T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on\t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE     SUBSYSTEM2FABRIC.FABRIC_ID = ? and     SUBSYSTEM2FABRIC.PREFIX_ID =  T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static String SELECT_SANS_FROM_ARRAY_FROM_SAN = "SELECT     SUBSYSTEM2FABRIC1.FABRIC_ID,     SUBSYSTEM2FABRIC1.PREFIX_ID,     SUBSYSTEM2FABRIC1.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC1, T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC2 WHERE     SUBSYSTEM2FABRIC1.PREFIX_ID = SUBSYSTEM2FABRIC2.SUBSYSTEM_ID and \t SUBSYSTEM2FABRIC1.SUBSYSTEM_ID = SUBSYSTEM2FABRIC2.SUBSYSTEM_ID and     SUBSYSTEM2FABRIC2.FABRIC_ID = ?";
    public static String SELECT_TAPE_FROM_SAN = "SELECT  \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC,    T_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_VENDOR VENDOR on\t T_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID WHERE     TAPE2FABRIC.FABRIC_ID = ? and     TAPE2FABRIC.PREFIX_ID = T_RES_TAPE_LIBRARY.PREFIX_ID and \t TAPE2FABRIC.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID ";
    public static String SELECT_SANS_FROM_TAPE_FROM_SAN = "SELECT     TAPE2FABRIC1.PREFIX_ID,     TAPE2FABRIC1.FABRIC_ID FABRIC_ID,     TAPE2FABRIC1.TAPE_LIBRARY_ID TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC1,T_VIEW_VTAPE2FABRIC TAPE2FABRIC2 WHERE     TAPE2FABRIC1.PREFIX_ID = TAPE2FABRIC2.PREFIX_ID and \t TAPE2FABRIC1.TAPE_LIBRARY_ID = TAPE2FABRIC2.TAPE_LIBRARY_ID and     TAPE2FABRIC2.FABRIC_ID = ?";
    public static final String SELECT_HOST2SWITCH_FROM_SAN = "SELECT distinct \t\tSWITCH2HOST.HOST_PREFIX_ID,      SWITCH2HOST.HOST_ID HOST_ID,\t\tSWITCH2HOST.SWITCH_PREFIX_ID, \t\tSWITCH2HOST.SWITCH_ID SWITCH_ID,\t    SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2HOST.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE       SWITCH2HOST.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\t SWITCH2HOST.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and       SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2STORAGE_FROM_SAN = "SELECT distinct \t\tSWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID, \t\tSWITCH2SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID,\t\tSWITCH2SUBSYSTEM.SWITCH_PREFIX_ID, \t\tSWITCH2SUBSYSTEM.SWITCH_ID SWITCH_ID,\t    SWITCH2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE      SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\tSWITCH2SUBSYSTEM.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and      SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2TAPE_FROM_SAN = "SELECT distinct \t\tSWITCH2TAPE.TAPE_PREFIX_ID, \t\tSWITCH2TAPE.TAPE_LIBRARY_ID TAPE_LIBRARY_ID,\t\tSWITCH2TAPE.SWITCH_PREFIX_ID, \t\tSWITCH2TAPE.SWITCH_ID SWITCH_ID,\t    SWITCH2TAPE.PORT2PORT_ID PORT2PORT_ID, \t    SWITCH2TAPE.DETECTABLE DETECTABLE from T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC where      SWITCH2TAPE.SWITCH_PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t\tSWITCH2TAPE.SWITCH_ID = SWITCH2FABRIC.SWITCH_ID and      SWITCH2FABRIC.FABRIC_ID = ? ";
    public static final String SELECT_OTHER_FROM_SAN = "SELECT  \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE  FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC,T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on OTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on OTHER.VENDOR_ID = VENDOR.VENDOR_ID WHERE \tOTHER2FABRIC.FABRIC_ID = ? and \tOTHER2FABRIC.PREFIX_ID = OTHER.PREFIX_ID and \tOTHER2FABRIC.OTHER_ID = OTHER.OTHER_ID ";
    public static final String SELECT_SANS_FROM_OTHER_FROM_SAN = "SELECT \t OTHER2FABRIC1.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC1.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC1.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC1,T_VIEW_VOTHER2FABRIC OTHER2FABRIC2 WHERE \t OTHER2FABRIC1.PREFIX_ID = OTHER2FABRIC2.PREFIX_ID and     OTHER2FABRIC1.OTHER_ID = OTHER2FABRIC2.OTHER_ID and     OTHER2FABRIC2.FABRIC_ID = ? ";
    public static final String SELECT_SWITCH2OTHER_FROM_SAN = "SELECT distinct     SWITCH2OTHER.OTHER_PREFIX_ID OTHER_PREFIX_ID,     SWITCH2OTHER.OTHER_ID OTHER_ID, \t SWITCH2OTHER.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2OTHER.SWITCH_ID SWITCH_ID, \t SWITCH2OTHER.PORT2PORT_ID PORT2PORT_ID,    SWITCH2OTHER.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE \t SWITCH2FABRIC.FABRIC_ID = ? and     SWITCH2FABRIC.PREFIX_ID = SWITCH2FABRIC.PREFIX_ID and \t SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_SAN = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM  \t T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE \t T_RES_FABRIC.FABRIC_ID = ?";
    public static final String SELECT_ZONES_FROM_SAN = "SELECT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME ,\tFABRIC.FABRIC_ID FABRIC_ID FROM     T_RES_ZONE, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = T_RES_ZONE.FABRIC_WWN";
    public static final String SELECT_ZONESET2ZONE_FROM_SAN = "SELECT \t ZONESET2ZONE.ZSET_ID ZSET_ID,\t ZONESET2ZONE.ZONE_ID ZONE_ID FROM     T_RES_ZSET2ZONE ZONESET2ZONE, T_RES_ZSET ZSET, T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = ZSET.FABRIC_WWN and     ZSET.ZSET_ID = ZONESET2ZONE.ZSET_ID";
    public static final String SELECT_ZONESET_FROM_SAN = "SELECT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME ,\tFABRIC.FABRIC_ID FABRIC_ID FROM     T_RES_ZSET , T_RES_FABRIC FABRIC WHERE     FABRIC.FABRIC_ID = ? and     FABRIC.FABRIC_WWN = T_RES_ZSET.FABRIC_WWN";
    public static final String SELECT_ZONE2MEMBER_FROM_SAN = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     PORT2ZONE.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE.MEMBER_NAME,\t PORT2ZONE.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM  \t T_RES_ZONE ZONE, T_VIEW_PORT2ZONE PORT2ZONE left outer join T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE.PORT_ID = ENTITY_TO_PORT.PORT_ID ,  T_RES_FABRIC FABRIC WHERE  \t PORT2ZONE.ZONE_ID = ZONE.ZONE_ID and \t ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN and \t FABRIC.FABRIC_ID = ? ";
    public static final String INSERT_TMP_HOST = "INSERT INTO T_RES_TMP_TOPOLOGY_ENTITY (PREFIX_ID, ENTITY_ID, ID) VALUES (?,?,?)";
    public static final String DELETE_TMP_HOSTS = "DELETE FROM T_RES_TMP_TOPOLOGY_ENTITY WHERE ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphFabric getSan(Connection srmConnection, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("san...");
        }
        GraphFabric gSan = null;
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer sanWwn = (Integer)resultSet.getObject("FABRIC_ID");
                if (sanWwn == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSan", "FABRIC_WWN field is null:");
                    continue;
                }
                String fabricKey = "fabric:" + sanWwn;
                if (entityMap == null || entityMap.get(fabricKey) == null) {
                    gSan = new GraphFabric(fabricKey);
                    this.populator.populateSan(resultSet, gSan);
                    if (model != null) {
                        model.put(gSan);
                    }
                    if (entityMap != null) {
                        entityMap.put(fabricKey, gSan);
                    }
                    break;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSan", "Duplicated san entry:" + fabricKey);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("san totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSan", "");
        }
        return gSan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromSan(Connection srmConnection, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        GraphFabric gSan;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitchFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switches...");
        }
        if ((gSan = (GraphFabric)entityMap.get("fabric:" + sanId)) == null) {
            TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getHostFromSwitch", "No SAN graph object found: " + sanId);
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) continue;
                String switchKey = prefixId + switchId;
                if (entityMap.get(switchKey) == null) {
                    GraphSwitch gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    Vector<GraphEntity.ID> sanIds = new Vector<GraphEntity.ID>();
                    sanIds.add(gSan.getEntityID());
                    model.put(gSwitch);
                    entityMap.put(switchKey, gSwitch);
                    String san2hostKey = "fabric2switch:" + sanId + ',' + switchKey;
                    GraphFabric2Switch gSan2switch = new GraphFabric2Switch(san2hostKey);
                    gSan2switch.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    gSan2switch.setFabricID((GraphFabric.ID)gSan.getEntityID());
                    model.put(gSan2switch);
                    entityMap.put(san2hostKey, gSan2switch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitchFromSan", "Duplicated switch entry:" + switchKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitchFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitchFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitchFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHostFromSan(Connection srmConnection, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        GraphFabric gSan;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getHostFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Hosts...");
        }
        if ((gSan = (GraphFabric)entityMap.get("fabric:" + sanId)) == null) {
            TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getHostFromSan", "No SAN graph object found: " + sanId);
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_HOST_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                if (hostId == null) continue;
                String hostKey = prefixId + hostId;
                if (entityMap.get(hostKey) == null) {
                    GraphComputer gHost = new GraphComputer(hostKey);
                    this.populator.populateHost(resultSet, gHost);
                    entityMap.put(hostKey, gHost);
                    model.put(gHost);
                    String san2hostKey = "fabric2server:" + sanId + ',' + hostKey;
                    GraphFabric2Computer gSan2host = new GraphFabric2Computer(san2hostKey);
                    gSan2host.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gSan2host.setFabricID((GraphFabric.ID)gSan.getEntityID());
                    model.put(gSan2host);
                    entityMap.put(san2hostKey, gSan2host);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getHostFromSan", "Duplicated host entry:" + hostKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getHostFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getHostFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("host totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getHostFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getArrayFromSan(Connection srmConnection, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        GraphFabric gSan;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getArrayFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Array...");
        }
        if ((gSan = (GraphFabric)entityMap.get("fabric:" + sanId)) == null) {
            TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getArrayFromSan", "No SAN graph object found: " + sanId);
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_ARRAY_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystem_id = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (subsystem_id == null) continue;
                String subsystemKey = prefixId + subsystem_id;
                if (entityMap.get(subsystemKey) == null) {
                    GraphSubsystem gArray = new GraphSubsystem(subsystemKey);
                    this.populator.populateSubsystem(resultSet, gArray);
                    model.put(gArray);
                    entityMap.put(subsystemKey, gArray);
                    model.put(gArray);
                    String san2arrayKey = "fabric2subsystem:" + sanId + ',' + subsystemKey;
                    GraphFabric2Subsystem gSan2array = new GraphFabric2Subsystem(san2arrayKey);
                    gSan2array.setSubsystemID((GraphSubsystem.ID)gArray.getEntityID());
                    gSan2array.setFabricID((GraphFabric.ID)gSan.getEntityID());
                    model.put(gSan2array);
                    entityMap.put(san2arrayKey, gSan2array);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getArrayFromSan", "Duplicated array entry:" + subsystemKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getArrayFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getArrayFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("Array totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getArrayFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTapeFromSan(Connection srmConnection, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        GraphFabric gSan;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getTapeFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("tape...");
        }
        if ((gSan = (GraphFabric)entityMap.get("fabric:" + sanId)) == null) {
            TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getTapeFromSan", "No SAN graph object found: " + sanId);
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_TAPE_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                if (tapeId == null) continue;
                String tapeKey = prefixId + tapeId;
                if (entityMap.get(tapeKey) == null) {
                    GraphTapeLibrary gTape = new GraphTapeLibrary(tapeKey);
                    this.populator.populateTapeLibrary(resultSet, gTape);
                    model.put(gTape);
                    entityMap.put(tapeKey, gTape);
                    model.put(gTape);
                    String san2arrayKey = "fabric2tape:" + sanId + ',' + tapeKey;
                    GraphFabric2TapeLibrary gSan2tape = new GraphFabric2TapeLibrary(san2arrayKey);
                    gSan2tape.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                    gSan2tape.setFabricID((GraphFabric.ID)gSan.getEntityID());
                    model.put(gSan2tape);
                    entityMap.put(san2arrayKey, gSan2tape);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getTapeFromSan", "Duplicated array entry:" + tapeKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getTapeFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getTapeFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("tape totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getTapeFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2SwitchFromSan(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Switch...");
        }
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2SWITCH_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String switchPrefixId1 = (String)resultSet.getObject("SWITCH_PREFIX_ID1");
                Integer switchId1 = (Integer)resultSet.getObject("SWITCH1_ID");
                String switchPrefixId2 = (String)resultSet.getObject("SWITCH_PREFIX_ID2");
                Integer switchId2 = (Integer)resultSet.getObject("SWITCH2_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String switchKey1 = switchPrefixId1 + switchId1;
                String switchKey2 = switchPrefixId2 + switchId2;
                GraphSwitch ref1Switch = (GraphSwitch)entityMap.get(switchKey1);
                GraphSwitch ref2Switch = (GraphSwitch)entityMap.get(switchKey2);
                if (ref1Switch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch element not found: " + switchKey1);
                    continue;
                }
                if (ref2Switch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch element not found: " + switchKey2);
                    continue;
                }
                String switch2switchKey1 = "port2port:" + port2portId;
                if (entityMap.get(switch2switchKey1) == null) {
                    GraphSwitch2Switch switch2switch = new GraphSwitch2Switch(switch2switchKey1);
                    switch2switch.setSwitch1ID((GraphSwitch.ID)ref1Switch.getEntityID());
                    switch2switch.setSwitch2ID((GraphSwitch.ID)ref2Switch.getEntityID());
                    this.populator.populatePort2Port(resultSet, switch2switch);
                    model.put(switch2switch);
                    entityMap.put(switch2switchKey1, switch2switch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch2Switch already exists!");
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2HostFromSan(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2HostFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Host...");
        }
        try {
            stmt = con.prepareStatement(SELECT_HOST2SWITCH_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                String switchPrefixId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String switchKey = switchPrefixId + switchId;
                String hostKey = hostPrefixId + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gHost != null && gSwitch != null) {
                    String switch2hostKey = "port2port:" + switchPrefixId + switchId + ',' + hostPrefixId + hostId + ',' + port2portId;
                    if (entityMap.get(switch2hostKey) == null) {
                        GraphSwitch2Computer switch2host = new GraphSwitch2Computer(switch2hostKey);
                        switch2host.setComputerID((GraphComputer.ID)gHost.getEntityID());
                        switch2host.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2host);
                        model.put(switch2host);
                        entityMap.put(switch2hostKey, switch2host);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch2Host already exists!");
                    continue;
                }
                if (gSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Switch not fould: switch:" + switchKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "Server not fould: server:" + hostKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Host totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2HostFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2ArrayFromSan(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Array...");
        }
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2STORAGE_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixSubsystemId = (String)resultSet.getObject("SUBSYSTEM_PREFIX_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                String prefixSwitchId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String switchKey = prefixSwitchId + switchId;
                String subsystemKey = prefixSubsystemId + subsystemId;
                GraphSubsystem refArray = (GraphSubsystem)entityMap.get(subsystemKey);
                GraphSwitch refSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (refArray != null && refSwitch != null) {
                    String switch2arrayKey = "port2port:" + prefixSwitchId + switchId + ',' + prefixSubsystemId + subsystemId + ',' + port2portId;
                    if (entityMap.get(switch2arrayKey) == null) {
                        GraphSwitch2Subsystem switch2array = new GraphSwitch2Subsystem(switch2arrayKey);
                        switch2array.setSubsystemID((GraphSubsystem.ID)refArray.getEntityID());
                        switch2array.setSwitchID((GraphSwitch.ID)refSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2array);
                        model.put(switch2array);
                        entityMap.put(switch2arrayKey, switch2array);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Switch2Array already exists!");
                    continue;
                }
                if (refSwitch != null) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Switch not fould: switch:" + switchId);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "Array not fould: array:" + subsystemId);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Array totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2ArrayFromSan", "");
        }
    }

    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        this.getSansFromSubsystem(con, model, entityMap, null, new Integer(sanId), SELECT_SANS_FROM_ARRAY_FROM_SAN);
    }

    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap, String prefixId, Integer focusId, String query) throws SQLException {
        Object[] objectArray;
        if (focusId != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = prefixId;
            objectArray = objectArray2;
            objectArray2[1] = focusId;
        } else {
            objectArray = null;
        }
        this.getSansFromSubsystem(con, model, entityMap, objectArray, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2subsystem...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSubsystem refArray = new GraphSubsystem("subsystem:" + subsystemId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                GraphFabric2Subsystem gSan2array = new GraphFabric2Subsystem("fabric2subsystem:" + fabricIds + ',' + subsystemId);
                gSan2array.setSubsystemID((GraphSubsystem.ID)refArray.getEntityID());
                gSan2array.setFabricID((GraphFabric.ID)san.getEntityID());
                model.put(gSan2array);
                model.put(refArray);
                model.put(san);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("san2subsystem totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int sanId) throws SQLException {
        this.getSansFromHost(con, model, entityMap, prefixId, new Integer(sanId), SELECT_SANS_FROM_HOST_FROM_SAN);
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, Integer focusId, String query) throws SQLException {
        Object[] objectArray;
        if (focusId != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = prefixId;
            objectArray = objectArray2;
            objectArray2[1] = focusId;
        } else {
            objectArray = null;
        }
        this.getSansFromHost(con, model, entityMap, objectArray, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2host...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphComputer refHost = new GraphComputer(prefixId + hostId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                GraphFabric2Computer san2host = new GraphFabric2Computer("fabric2server:" + fabricIds + ',' + hostId);
                san2host.setFabricID((GraphFabric.ID)san.getEntityID());
                san2host.setComputerID((GraphComputer.ID)refHost.getEntityID());
                model.put(refHost);
                model.put(san);
                model.put(san2host);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("san2host totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getZonesFromEntitiesConnectedToEntity(Connection con, GraphModel model, HashMap entityMap, Object[] values, String[] queries) throws SQLException {
        String zoneSetKey;
        GraphZoneFabric zonesan;
        Integer fabricId;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (queries[0] != null) {
            init = System.currentTimeMillis();
            if (debug) {
                System.out.println("fabric...");
            }
            try {
                stmt = con.prepareStatement(queries[0]);
                for (int i = 0; i < values.length; ++i) {
                    stmt.setObject(i + 1, values[i]);
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    String zoneSanKey;
                    GraphZoneFabric zoneSan;
                    Integer fabricId2 = (Integer)resultSet.getObject("FABRIC_ID");
                    String fabricKey = "fabric:" + fabricId2;
                    GraphFabric gFabric = (GraphFabric)entityMap.get(fabricKey);
                    if (gFabric == null) {
                        gFabric = new GraphFabric(fabricKey);
                        this.populator.populateSan(resultSet, gFabric);
                        model.put(gFabric);
                        entityMap.put(fabricKey, gFabric);
                    }
                    if ((zoneSan = (GraphZoneFabric)entityMap.get(zoneSanKey = "zonesan:" + fabricId2)) != null) continue;
                    zoneSan = new GraphZoneFabric(zoneSanKey);
                    zoneSan.setDisplayName(gFabric.getDisplayName());
                    zoneSan.setFabricID((GraphFabric.ID)gFabric.getEntityID());
                    model.put(zoneSan);
                    entityMap.put(zoneSanKey, zoneSan);
                }
            }
            finally {
                block98: {
                    block97: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block97;
                            TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block98;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                    }
                }
            }
        }
        if (debug) {
            System.out.println("zones totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        stmt = null;
        resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("zones...");
        }
        try {
            stmt = con.prepareStatement(queries[1]);
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String zone2fabricKey;
                GraphZoneFabric2Zone zoneSan2zone;
                Integer zoneId = (Integer)resultSet.getObject("ZONE_ID");
                fabricId = (Integer)resultSet.getObject("FABRIC_ID");
                String zoneKey = "zone:" + zoneId;
                GraphZone gZone = (GraphZone)entityMap.get(zoneKey);
                if (gZone == null) {
                    gZone = new GraphZone(zoneKey);
                    this.populator.populateZone(resultSet, gZone);
                    model.put(gZone);
                    entityMap.put(zoneKey, gZone);
                }
                if ((zoneSan2zone = (GraphZoneFabric2Zone)entityMap.get(zone2fabricKey = "zone2san:" + zoneId)) != null || fabricId == null) continue;
                zoneSan2zone = new GraphZoneFabric2Zone(zone2fabricKey);
                zonesan = (GraphZoneFabric)entityMap.get("zonesan:" + fabricId);
                if (zonesan == null) continue;
                zoneSan2zone.setZoneFabricID((GraphZoneFabric.ID)zonesan.getEntityID());
                zoneSan2zone.setZoneID((GraphZone.ID)gZone.getEntityID());
                model.put(zoneSan2zone);
                entityMap.put(zone2fabricKey, zoneSan2zone);
            }
        }
        finally {
            block101: {
                block100: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block100;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block101;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                }
            }
        }
        if (debug) {
            System.out.println("zones totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("zonesets...");
        }
        try {
            stmt = con.prepareStatement(queries[2]);
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String zset2fabricKey;
                GraphZoneFabric2ZoneSet zoneSan2zset;
                Integer zoneSetId = (Integer)resultSet.getObject("ZSET_ID");
                fabricId = (Integer)resultSet.getObject("FABRIC_ID");
                zoneSetKey = "zset:" + zoneSetId;
                GraphZoneSet gZoneSet = (GraphZoneSet)entityMap.get(zoneSetKey);
                if (gZoneSet == null) {
                    gZoneSet = new GraphZoneSet(zoneSetKey);
                    this.populator.populateZoneSet(resultSet, gZoneSet);
                    model.put(gZoneSet);
                    entityMap.put(zoneSetKey, gZoneSet);
                }
                if ((zoneSan2zset = (GraphZoneFabric2ZoneSet)entityMap.get(zset2fabricKey = "zset2san:" + zoneSetId)) != null || fabricId == null) continue;
                zoneSan2zset = new GraphZoneFabric2ZoneSet(zset2fabricKey);
                zonesan = (GraphZoneFabric)entityMap.get("zonesan:" + fabricId);
                if (zonesan == null) continue;
                zoneSan2zset.setZoneFabricID((GraphZoneFabric.ID)zonesan.getEntityID());
                zoneSan2zset.setZoneSetID((GraphZoneSet.ID)gZoneSet.getEntityID());
                model.put(zoneSan2zset);
                entityMap.put(zset2fabricKey, zoneSan2zset);
            }
        }
        finally {
            block104: {
                block103: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block103;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block104;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                }
            }
        }
        if (debug) {
            System.out.println("zonesets totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("zset2zone...");
        }
        try {
            stmt = con.prepareStatement(queries[3]);
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer zoneSetId = (Integer)resultSet.getObject("ZSET_ID");
                Integer zoneId = (Integer)resultSet.getObject("ZONE_ID");
                zoneSetKey = "zset:" + zoneSetId;
                String zoneKey = "zone:" + zoneId;
                String zoneset2zoneKey = "zone2zoneset:" + zoneSetId + ',' + zoneId;
                GraphZoneSet2Zone gZoneSet2zone = (GraphZoneSet2Zone)entityMap.get(zoneset2zoneKey);
                if (gZoneSet2zone != null) continue;
                GraphZoneSet gZoneSet = (GraphZoneSet)entityMap.get(zoneSetKey);
                GraphZone gZone = (GraphZone)entityMap.get(zoneKey);
                gZoneSet2zone = new GraphZoneSet2Zone(zoneset2zoneKey);
                gZoneSet2zone.setZoneID((GraphZone.ID)gZone.getEntityID());
                gZoneSet2zone.setZoneSetID((GraphZoneSet.ID)gZoneSet.getEntityID());
                model.put(gZoneSet2zone);
                entityMap.put(zoneset2zoneKey, gZoneSet2zone);
            }
        }
        finally {
            block107: {
                block106: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block106;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block107;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                }
            }
        }
        if (debug) {
            System.out.println("zone2member totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("zset2zone...");
        }
        try {
            stmt = con.prepareStatement(queries[4]);
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer zoneId = (Integer)resultSet.getObject("ZONE_ID");
                Integer portID = (Integer)resultSet.getObject("PORT_ID");
                String type = (String)resultSet.getObject("TYPE");
                String memberName = (String)resultSet.getObject("MEMBER_NAME");
                Integer memberNameId = (Integer)resultSet.getObject("ZONE_MEMBER_ID");
                String displayName = (String)resultSet.getObject("DISPLAY_NAME");
                String portDisplayName = (String)resultSet.getObject("PORT_DISPLAY_NAME");
                String portNumber = (String)resultSet.getObject("PORT_NUMBER");
                String prefixID = (String)resultSet.getObject("PREFIX_ID");
                Integer entityID = (Integer)resultSet.getObject("ENTITY_ID");
                String entityKey = prefixID + entityID;
                String zoneKey = "zone:" + zoneId;
                String key = "" + memberNameId + ',' + zoneId + ',' + entityKey + ',' + portID;
                String zonememberKey = "zonemember:" + key;
                GraphZoneMember gZoneMember = (GraphZoneMember)entityMap.get(zonememberKey);
                if (gZoneMember == null) {
                    gZoneMember = new GraphZoneMember(zonememberKey);
                    GraphEntity gNode = (GraphEntity)entityMap.get(entityKey);
                    String portIdKey = "Port:" + portID;
                    GraphFCPort gPort = (GraphFCPort)entityMap.get(portIdKey);
                    gZoneMember.setDisplayName(memberName);
                    if (gNode != null) {
                        gZoneMember.setParentID(gNode.getEntityID());
                    } else {
                        gNode = null;
                    }
                    gZoneMember.setParentLabel(displayName);
                    if (gPort != null) {
                        gZoneMember.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                    } else {
                        gPort = null;
                    }
                    gZoneMember.setFCPortPortNumber(portNumber);
                    gZoneMember.setFCPortLabel(portDisplayName);
                    gZoneMember.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                    model.put(gZoneMember);
                    entityMap.put(zonememberKey, gZoneMember);
                    zoneKey = "zone:" + zoneId;
                    GraphZone zone = (GraphZone)entityMap.get(zoneKey);
                    if (zone == null) continue;
                    String zone2memberKey = "zone2member:" + key;
                    GraphZone2ZoneMember zone2member = new GraphZone2ZoneMember(zone2memberKey);
                    zone2member.setZoneMemberID((GraphZoneMember.ID)gZoneMember.getEntityID());
                    zone2member.setZoneID((GraphZone.ID)zone.getEntityID());
                    model.put(zone2member);
                    entityMap.put(zone2memberKey, zone2member);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "Zone2Member fould: " + entityKey);
            }
        }
        finally {
            block110: {
                block109: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block109;
                        TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block110;
                    TraceLogger.exception(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", e);
                }
            }
        }
        if (debug) {
            System.out.println("zone2member totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL2.class.getName(), "getZonesFROMEntitiesConnectedToEntity", "");
        }
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixId, Integer focusId, String query) throws SQLException {
        Object[] objectArray;
        if (focusId != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = prefixId;
            objectArray = objectArray2;
            objectArray2[1] = focusId;
        } else {
            objectArray = null;
        }
        this.getSansFromSwitch(con, model, entityMap, objectArray, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2switch...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSwitch refSwitch = new GraphSwitch(prefixId + switchId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                this.populator.populateSan(resultSet, san);
                GraphFabric2Switch san2switch = new GraphFabric2Switch("fabric2switch:" + fabricIds + ',' + switchId);
                san2switch.setFabricID((GraphFabric.ID)san.getEntityID());
                san2switch.setSwitchID((GraphSwitch.ID)refSwitch.getEntityID());
                model.put(san);
                model.put(san2switch);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", e);
                }
            }
        }
        if (debug) {
            System.out.println("san2switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
    }

    public void getSansFromTape(Connection con, GraphModel model, HashMap entityMap, String prefixId, int focusId) throws SQLException {
        this.getSansFromTape(con, model, entityMap, prefixId, new Integer(focusId), SELECT_SANS_FROM_TAPE_FROM_SAN);
    }

    public void getSansFromTape(Connection con, GraphModel model, HashMap entityMap, String prefixId, Integer focusId, String query) throws SQLException {
        Object[] objectArray;
        if (focusId != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = prefixId;
            objectArray = objectArray2;
            objectArray2[1] = focusId;
        } else {
            objectArray = null;
        }
        this.getSansFromTape(con, model, entityMap, objectArray, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromTape(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromTape", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("sans2tape...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphTapeLibrary refTape = new GraphTapeLibrary(prefixId + tapeId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                GraphFabric2TapeLibrary san2tape = new GraphFabric2TapeLibrary("fabric2tape:" + fabricIds + ',' + tapeId);
                san2tape.setFabricID((GraphFabric.ID)san.getEntityID());
                san2tape.setTapeLibraryID((GraphTapeLibrary.ID)refTape.getEntityID());
                model.put(san);
                model.put(san2tape);
                model.put(refTape);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromTape", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromTape", e);
                }
            }
        }
        if (debug) {
            System.out.println("sant22tape totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromTape", "");
        }
    }

    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        this.getSansFromUnknown(con, model, entityMap, new Integer(sanId), SELECT_SANS_FROM_OTHER_FROM_SAN);
    }

    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap, Integer focusId, String query) throws SQLException {
        this.getSansFromUnknown(con, model, entityMap, new Integer[]{focusId}, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromUnknown", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("sans2unknown...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer otherID = (Integer)resultSet.getObject("OTHER_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                String otherId = prefixId + otherID;
                GraphOther refOther = new GraphOther(otherId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                GraphFabric2Other san2other = new GraphFabric2Other("fabric2other:" + fabricIds + ',' + otherId);
                san2other.setOtherID((GraphOther.ID)refOther.getEntityID());
                san2other.setFabricID((GraphFabric.ID)san.getEntityID());
                model.put(san2other);
                model.put(san);
                model.put(refOther);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromUnknown", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromUnknown", e);
                }
            }
        }
        if (debug) {
            System.out.println("sans2unknown totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromUnknown", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2TapeFromSan(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("Switch2Tape...");
        }
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2TAPE_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String tapePrefixId = (String)resultSet.getObject("TAPE_PREFIX_ID");
                Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                String switchPrefixId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphTapeLibrary gTape = (GraphTapeLibrary)entityMap.get(tapePrefixId + tapeId);
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchPrefixId + switchId);
                if (gTape != null && gSwitch != null) {
                    String switch2arrayKey = "port2port:" + switchPrefixId + switchId + ',' + tapePrefixId + tapeId + ',' + port2portId;
                    if (entityMap.get(switch2arrayKey) == null) {
                        GraphSwitch2TapeLibrary switch2tape = new GraphSwitch2TapeLibrary(switch2arrayKey);
                        switch2tape.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                        switch2tape.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2tape);
                        model.put(switch2tape);
                        entityMap.put(switch2arrayKey, switch2tape);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Switch2tape already exists!");
                    continue;
                }
                if (gSwitch != null) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Switch not fould: switch:" + switchId);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "Tape not fould: tape:" + tapeId);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", e);
                }
            }
        }
        if (debug) {
            System.out.println("Switch2Tape totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSwitch2TapeFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2Unknown(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getwitch2Unknown", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("switch2unknown...");
        }
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2OTHER_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer unknownId = (Integer)resultSet.getObject("OTHER_ID");
                String prefixId = (String)resultSet.getObject("OTHER_PREFIX_ID");
                String switchPrefixId = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String switchKey = switchPrefixId + switchId;
                String otherKey = prefixId + unknownId;
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchKey);
                Object o = entityMap.get(otherKey);
                GraphOther gOther = (GraphOther)o;
                if (gSwitch != null && gOther != null) {
                    String switch2otherKey = "port2port:" + switchPrefixId + switchId + ',' + prefixId + unknownId + ',' + port2portId;
                    GraphSwitch2Other gSwitch2Other = new GraphSwitch2Other(switch2otherKey);
                    gSwitch2Other.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    gSwitch2Other.setOtherID((GraphOther.ID)gOther.getEntityID());
                    this.populator.populatePort2Port(resultSet, gSwitch2Other);
                    model.put(gSwitch2Other);
                    entityMap.put(switch2otherKey, gSwitch2Other);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                if (gOther == null) {
                    TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "switch2unknown", "Other not found: " + otherKey);
                    continue;
                }
                TraceLogger.traceMessage(1, ViewerSanL1.class.getName(), "switch2unknown", "Switch not found: " + switchKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", e);
                }
            }
        }
        if (debug) {
            System.out.println("switch2unknown totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUnknownFromSan(Connection con, GraphModel model, HashMap entityMap, int sanId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("unknown...");
        }
        try {
            stmt = con.prepareStatement(SELECT_OTHER_FROM_SAN);
            stmt.setInt(1, sanId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer unknownId = (Integer)resultSet.getObject("OTHER_ID");
                String otherKey = prefixId + unknownId;
                GraphOther gOther = (GraphOther)entityMap.get(otherKey);
                if (gOther != null) continue;
                gOther = new GraphOther(otherKey);
                this.populator.populateOther(resultSet, gOther);
                model.put(gOther);
                entityMap.put(otherKey, gOther);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "switch2unknown", e);
                }
            }
        }
        if (debug) {
            System.out.println("unknown totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getUnknownFromSan", "");
        }
    }

    public void getZonesFromSan(Connection con, GraphModel model, HashMap entityMap, int entityId) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{new Integer(entityId)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_SAN, SELECT_ZONES_FROM_SAN, SELECT_ZONESET_FROM_SAN, SELECT_ZONESET2ZONE_FROM_SAN, SELECT_ZONE2MEMBER_FROM_SAN});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTmpHosts(Connection con, int ID2) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(DELETE_TMP_HOSTS);
            stmt.setInt(1, ID2);
            stmt.executeUpdate();
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "removeTmpHosts", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "removeTmpHosts", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTmpEntity(Connection con, Vector childFocusNodeIDV, int ID2) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(INSERT_TMP_HOST);
            for (GraphEntity.ID nodeId : childFocusNodeIDV) {
                String entityIdStr = (String)nodeId.getID();
                int i = entityIdStr.indexOf(58);
                String prefixId = entityIdStr.substring(0, i + 1);
                entityIdStr = entityIdStr.substring(i + 1);
                int entityIdInt = Integer.parseInt(entityIdStr);
                stmt.setString(1, prefixId);
                stmt.setInt(2, entityIdInt);
                stmt.setInt(3, ID2);
                stmt.executeUpdate();
            }
        }
        finally {
            block16: {
                block15: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "setHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block16;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "setHost", e);
                }
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getView", "");
        }
        GraphModelFabricL2 gModel = null;
        String sanId = null;
        GraphEntity.ID id = rqst.getModelID().getFocusEntityID();
        sanId = (String)id.getID();
        sanId = sanId.substring(sanId.indexOf(58) + 1);
        int sanIdInt = Integer.parseInt(sanId);
        HashMap<String, GraphFabric> entityMap = new HashMap<String, GraphFabric>();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            gModel = new GraphModelFabricL2((GraphModelFabricL2.ID)rqst.getModelID());
            GraphFabric gSan = this.getSan(con, null, null, sanIdInt);
            if (gSan != null) {
                entityMap.put("fabric:" + sanIdInt, gSan);
                gModel.put(gSan);
                this.getSwitchFromSan(con, gModel, entityMap, sanIdInt);
                this.getHostFromSan(con, gModel, entityMap, sanIdInt);
                this.getArrayFromSan(con, gModel, entityMap, sanIdInt);
                this.getTapeFromSan(con, gModel, entityMap, sanIdInt);
                this.getUnknownFromSan(con, gModel, entityMap, sanIdInt);
                this.commit(con);
                this.getSwitch2SwitchFromSan(con, gModel, entityMap, sanIdInt);
                this.getSwitch2ArrayFromSan(con, gModel, entityMap, sanIdInt);
                this.getSwitch2HostFromSan(con, gModel, entityMap, sanIdInt);
                this.getSwitch2TapeFromSan(con, gModel, entityMap, sanIdInt);
                this.getSwitch2Unknown(con, gModel, entityMap, sanIdInt);
                this.commit(con);
                if (rqst.getModelID().isNeedZoneData()) {
                    this.getZonesFromSan(con, gModel, entityMap, sanIdInt);
                    this.commit(con);
                }
                gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, gModel);
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(2, ViewerSanL1.class.getName(), "getSwitch2SwitchFromSan", "gmodel=" + gModel);
                }
            }
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

