/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerServerL0
extends ViewerSanL1 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SERVER = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VHOST T_RES_HOST ";
    public static String SELECT_SANS_FOR_HOST = "select distinct \tHOST2FABRIC.PREFIX_ID, \tHOST2FABRIC.HOST_ID HOST_ID, \tHOST2FABRIC.FABRIC_ID FABRIC_ID from T_VIEW_VHOST2FABRIC HOST2FABRIC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHosts(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerServerL0.class.getName(), "getHosts", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host...");
        }
        GraphComputer gHost = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SERVER);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                if (hostId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHosts", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String hostKey = prefixId + hostId;
                if (entityMap == null || entityMap.get(hostKey) == null) {
                    gHost = new GraphComputer(hostKey);
                    this.populator.populateHost(resultSet, gHost);
                    if (model != null) {
                        model.put(gHost);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(hostKey, gHost);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHosts", "Duplicated Host entry:" + hostKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHosts", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHosts", e);
                }
            }
        }
        if (debug) {
            System.out.println("host totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerServerL0.class.getName(), "getHosts", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, Object[] focusId, String query) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2host...");
        }
        try {
            stmt = con.prepareStatement(query);
            if (focusId != null) {
                for (int i = 0; i < focusId.length; ++i) {
                    stmt.setObject(i + 1, focusId[i]);
                }
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer fabricIds = (Integer)resultSet.getObject("FABRIC_ID");
                GraphComputer refHost = new GraphComputer(prefixId + hostId);
                GraphFabric san = new GraphFabric("fabric:" + fabricIds);
                GraphFabric2Computer san2host = new GraphFabric2Computer("fabric2server:" + fabricIds + ',' + hostId);
                san2host.setFabricID((GraphFabric.ID)san.getEntityID());
                san2host.setComputerID((GraphComputer.ID)refHost.getEntityID());
                model.put(refHost);
                model.put(san);
                model.put(san2host);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("san2host totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSubsystem", "");
        }
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        this.getSansFromHost(con, model, entityMap, (Object[])null, SELECT_SANS_FOR_HOST);
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerServerL0.class.getName(), "getView", "");
        }
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            GraphModelComputerL0 gModel = new GraphModelComputerL0((GraphModelComputerL0.ID)rqst.getModelID());
            this.getHosts(con, gModel, entityMap);
            resp.addResponse(0, gModel);
            gModel.setWithZoneData(true);
            this.commit(con);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerServerL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

