/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerStorageL0
extends ViewerSanL1 {
    ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SUBSYSTEM = "SELECT \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID ";
    public static String SELECT_TAPES = "SELECT \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_VENDOR VENDOR on \tT_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID ";
    public static String SELECT_SANS_FROM_ARRAY = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC";
    public static String SELECT_SANS_FROM_TAPE = "SELECT     TAPE2FABRIC.FABRIC_ID FABRIC_ID,     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.TAPE_LIBRARY_ID TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubsystems(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getSubsystems", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        GraphSubsystem gArray = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SUBSYSTEM);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                try {
                    String prefixId = (String)resultSet.getObject("PREFIX_ID");
                    Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                    if (subsystemId == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystems", "SUBSYSTEM_ID is NULL");
                        continue;
                    }
                    String subsystemKey = prefixId + subsystemId;
                    if (entityMap == null || entityMap.get(subsystemKey) == null) {
                        gArray = new GraphSubsystem(subsystemKey);
                        this.populator.populateSubsystem(resultSet, gArray);
                        if (model != null) {
                            model.put(gArray);
                        }
                        if (entityMap == null) continue;
                        entityMap.put(subsystemKey, gArray);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystems", "Duplicated Host entry:" + subsystemKey);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", e);
                }
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", e);
                }
            }
        }
        if (debug) {
            System.out.println("subsystem totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getHosts", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTapes(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getTapes", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("tape...");
        }
        GraphTapeLibrary gLibrary = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_TAPES);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                if (tapeId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getTapes", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String libraryKey = prefixId + tapeId;
                if (entityMap == null || entityMap.get(libraryKey) == null) {
                    gLibrary = new GraphTapeLibrary(libraryKey);
                    this.populator.populateTapeLibrary(resultSet, gLibrary);
                    if (model != null) {
                        model.put(gLibrary);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(libraryKey, gLibrary);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getTapes", "Duplicated Host entry:" + libraryKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getTapes", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getTapes", e);
                }
            }
        }
        if (debug) {
            System.out.println("tape totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getTapes", "");
        }
    }

    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        this.getSansFromSubsystem(con, model, entityMap, null, SELECT_SANS_FROM_ARRAY);
    }

    public void getSansFromTape(Connection con, GraphModel model, HashMap entityMap) throws SQLException {
        this.getSansFromTape(con, model, entityMap, (Object[])null, SELECT_SANS_FROM_TAPE);
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getView", "");
        }
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            GraphModelStorageL0 gModel = new GraphModelStorageL0((GraphModelStorageL0.ID)rqst.getModelID());
            this.getSubsystems(con, gModel, entityMap);
            this.getTapes(con, gModel, entityMap);
            gModel.setWithZoneData(true);
            this.commit(con);
            resp.addResponse(0, gModel);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

