/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.topology.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.topology.gui.TopologyViewerDefinition;

public class TopologyViewerTreeDDI
extends DataDisplayInfo
implements ActionListener {
    private static final String clazz = TopologyViewerDefinition.class.getName();
    private boolean usingHandlers = false;
    private JComponent panel1 = null;
    private boolean losingFocus = true;

    public TopologyViewerTreeDDI() {
        super(GuiUtil.getString("TOPO_MSG_TOPOLOGY"));
        this.helpID = null;
        this.displayInScrollPane = false;
    }

    public void printData(Container dashboard) {
        if (this.panel != null) {
            ((TopologyViewerDefinition)this.panel).print(dashboard);
        }
    }

    public String getHelpID() {
        String level = ((TopologyViewerDefinition)this.panel).getCurrentViewType();
        if (level.equals("Overview")) {
            return "bta_dlg_topology_topologyview";
        }
        if (level.equals("FabricL0")) {
            return "bta_dlg_topology_sansl0";
        }
        if (level.equals("FabricL1")) {
            return "bta_dlg_topology_sansl1";
        }
        if (level.equals("ComputerL0")) {
            return "bta_dlg_topology_computersl0";
        }
        if (level.equals("ComputerL1")) {
            return "bta_dlg_topology_computersl1";
        }
        if (level.equals("ComputerL2")) {
            return "bta_dlg_topology_computersl2";
        }
        if (level.equals("SwitchL2")) {
            return "bta_dlg_topology_sansl2_switch";
        }
        if (level.equals("StorageL0")) {
            return "bta_dlg_topology_storagel0";
        }
        if (level.equals("SubsystemL1")) {
            return "bta_dlg_topology_storagel1_subsystems";
        }
        if (level.equals("SubsystemL2")) {
            return "bta_dlg_topology_storagel2_subsystem";
        }
        if (level.equals("TapeLibraryL1")) {
            return "bta_dlg_topology_storagel1_tapelibs";
        }
        if (level.equals("TapeLibraryL2")) {
            return "bta_dlg_topology_storagel2_tapelib";
        }
        if (level.equals("OtherL0")) {
            return "bta_dlg_topology_otherl0";
        }
        if (level.equals("OtherL1")) {
            return "bta_dlg_topology_otherl1";
        }
        if (level.equals("OtherL2")) {
            return "bta_dlg_topology_otherl2";
        }
        return "bta_ovw_topologyviewer";
    }

    public void showPanel() {
        this.show();
    }

    public void show() {
        super.show();
        if (this.panel != null && this.panel.getParent() != null) {
            this.panel.getParent().validate();
        }
    }

    private void constructView(BaseTreeNode newTreeNode, GraphModel.ID id) {
        if (this.panel == null) {
            this.losingFocus = true;
            this.panel = new TopologyViewerDefinition();
        }
        if (guiMain == null) {
            guiMain = GuiManager.getGuiManager().getGuiMain();
        }
        guiMain.setSaveActionEnabled(false, false);
        if (!this.usingHandlers) {
            this.usingHandlers = true;
            guiMain.addCancelActionListener(this);
            guiMain.addStopActionListener(this);
        }
        if (this.panel instanceof TopologyViewerDefinition && id != null) {
            ((TopologyViewerDefinition)this.panel).openView(id);
        }
        if (newTreeNode != null) {
            this.treeNode = newTreeNode;
        }
    }

    public void reDisplay() {
        this.losingFocus = false;
        this.constructView(null, null);
        this.show();
    }

    public void reDisplay(BaseTreeNode newTreeNode, GraphModel.ID id) {
        this.losingFocus = false;
        this.constructView(newTreeNode, id);
        this.show();
    }

    public void losingFocus() {
        if (guiMain == null) {
            guiMain = GuiManager.getGuiManager().getGuiMain();
        }
        if (this.losingFocus) {
            guiMain.setSaveActionEnabled(false, false);
            guiMain.setSaveActionToolTip(null);
            if (this.usingHandlers) {
                this.usingHandlers = false;
                guiMain.removeCancelActionListener(this);
                guiMain.removeStopActionListener(this);
            }
            if (this.panel instanceof TopologyViewerDefinition) {
                ((TopologyViewerDefinition)this.panel).setConfigOUT();
            }
        }
        this.losingFocus = true;
    }

    public void panelToBeNulled() {
        if (this.panel != null && this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).setConfigOUT();
        }
        this.panel = null;
    }

    public void goingAway() {
        if (this.panel != null && this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).goingAway();
        }
        this.panel = null;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
        this.save();
        this.remove();
    }

    public void actionPerformed(ActionEvent event) {
        if (this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).actionPerformed(event);
        }
    }

    private void save() {
        if (this.panel instanceof TopologyViewerDefinition) {
            ((TopologyViewerDefinition)this.panel).save();
        }
    }
}

