/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.LinkedList;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.util.queue.IJobFilter;

public class Queue {
    private LinkedList order = new LinkedList();
    private Object lock = new Object();
    private IJobFilter filter = null;

    public Queue(IJobFilter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            int disposition = this.filter.disposition(job, this);
            if (disposition == 0) {
                this.order.addLast(job);
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getNextJob() {
        JobInfo job = null;
        while (!Thread.interrupted() && job == null) {
            Object object = this.lock;
            synchronized (object) {
                while (this.order.size() > 0) {
                    job = (JobInfo)this.order.get(0);
                    while (job.getStatus() == 4) {
                        this.order.remove(job);
                        job = job.getReplacementJob();
                    }
                    if (!this.filter.okToRun(job) || job == null) continue;
                    this.order.remove(job);
                    this.jobStarted(job);
                    break;
                }
            }
            if (job != null) continue;
            try {
                object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException ie) {
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobStarted(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            this.filter.jobStarted(job);
            job.setStartTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCompleted(JobInfo job) {
        this.filter.jobCompleted(job);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

