/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.util.queue.IJobQueue;

public class QueueController {
    private static QueueController iCurrentInstance = new QueueController();
    private Hashtable queues = new Hashtable();

    private QueueController() {
    }

    public static QueueController getInstance() {
        return iCurrentInstance;
    }

    public boolean addQueue(String name, IJobQueue queue) {
        if (this.queues.containsKey(name)) {
            return false;
        }
        this.queues.put(name, queue);
        return true;
    }

    public void addJob(JobInfo aJobInfo) {
        String methodName = "addJob";
        IJobQueue queue = (IJobQueue)this.queues.get(aJobInfo.getResourceQueue());
        if (queue == null) {
            Exception e = new Exception("QueueController->addJob:No queue registered for " + aJobInfo.getResourceQueue());
            e.printStackTrace();
            return;
        }
        queue.addJob(aJobInfo);
    }

    public JobInfo getNextJob(String jobType) {
        String methodName = "getNextJob";
        IJobQueue queue = (IJobQueue)this.queues.get(jobType);
        if (queue == null) {
            Exception e = new Exception("QueueController->getNextJob:No queue registered for " + jobType);
            e.printStackTrace();
            return null;
        }
        JobInfo tempJobInfo = queue.getNextJob();
        if (Thread.interrupted()) {
            return null;
        }
        return tempJobInfo;
    }

    public void jobComplete(JobInfo aJobInfo) {
        String methodName = "jobComplete";
        IJobQueue queue = (IJobQueue)this.queues.get(aJobInfo.getResourceQueue());
        if (queue == null) {
            Exception e = new Exception("QueueController->jobComplete:No queue registered for " + aJobInfo.getResourceQueue());
            e.printStackTrace();
            return;
        }
        queue.jobCompleted(aJobInfo);
    }
}

