/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.TextRendererProvider;

public class MessageRegistry {
    private static ProviderChain commonProviders = new ProviderChain();
    private static Map<ClassLoader, ProviderChain> byClassLoaderMap = new HashMap<ClassLoader, ProviderChain>();

    public static void registerProvider(TextRendererProvider provider) {
        commonProviders.add(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(ClassLoader loader, TextRendererProvider provider) {
        ProviderChain chain;
        Map<ClassLoader, ProviderChain> map = byClassLoaderMap;
        synchronized (map) {
            chain = byClassLoaderMap.get(loader);
            if (chain == null) {
                chain = new ProviderChain();
                byClassLoaderMap.put(loader, chain);
            }
        }
        chain.add(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MessageTextRenderer lookUpRenderer(ClassLoader loader, String productID) {
        MessageTextRenderer result = null;
        if (loader != null) {
            ProviderChain chain;
            Map<ClassLoader, ProviderChain> map = byClassLoaderMap;
            synchronized (map) {
                chain = byClassLoaderMap.get(loader);
            }
            if (chain != null) {
                result = chain.lookUp(productID);
            }
        }
        if (result == null) {
            result = commonProviders.lookUp(productID);
        }
        return result;
    }

    private static class ProviderChain {
        public TextRendererProvider head = null;
        public TextRendererProvider tail = null;

        public synchronized void add(TextRendererProvider provider) {
            provider.nextProvider = null;
            if (this.tail == null) {
                this.head = provider;
            } else {
                this.tail.nextProvider = provider;
            }
            this.tail = provider;
        }

        public MessageTextRenderer lookUp(String productID) {
            MessageTextRenderer result = null;
            TextRendererProvider provider = this.head;
            while (result == null && provider != null) {
                result = provider.lookUpRenderer(productID);
                provider = provider.nextProvider;
            }
            return result;
        }
    }
}

