/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TabInfo;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

public class DD_Version
implements Formatable {
    private transient DataDictionaryImpl bootingDictionary;
    int majorVersionNumber;
    private int minorVersionNumber;

    public DD_Version() {
    }

    DD_Version(DataDictionaryImpl dataDictionaryImpl, int n) {
        this.majorVersionNumber = n;
        this.minorVersionNumber = this.getJBMSMinorVersionNumber();
        this.bootingDictionary = dataDictionaryImpl;
    }

    public String toString() {
        return DD_Version.majorToString(this.majorVersionNumber);
    }

    private static String majorToString(int n) {
        switch (n) {
            case 80: {
                return "5.0";
            }
            case 90: {
                return "5.1";
            }
            case 100: {
                return "5.2";
            }
            case 110: {
                return "8.1";
            }
            case 120: {
                return "10.0";
            }
            case 130: {
                return "10.1";
            }
        }
        return null;
    }

    void upgradeIfNeeded(DD_Version dD_Version, TransactionController transactionController, Properties properties) throws StandardException {
        if (dD_Version.majorVersionNumber > this.majorVersionNumber) {
            throw StandardException.newException("XCL20.S", dD_Version, (Object)this);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.bootingDictionary.af.isReadOnly();
        if (dD_Version.majorVersionNumber == this.majorVersionNumber) {
            if (dD_Version.minorVersionNumber == this.minorVersionNumber) {
                return;
            }
            bl = true;
        } else if (Monitor.isFullUpgrade(properties, dD_Version.toString())) {
            bl2 = true;
        } else {
            bl3 = true;
        }
        transactionController.commit();
        if (bl2) {
            this.doFullUpgrade(transactionController, dD_Version.majorVersionNumber);
        }
        if (!bl && !bl4) {
            DD_Version dD_Version2 = (DD_Version)transactionController.getProperty("derby.softDataDictionaryVersion");
            int n = 0;
            if (dD_Version2 != null) {
                n = dD_Version2.majorVersionNumber;
            }
            if (n < this.majorVersionNumber) {
                this.applySafeChanges(transactionController, dD_Version.majorVersionNumber, n);
            }
        }
        this.handleMinorRevisionChange(transactionController, dD_Version, bl3);
        transactionController.commit();
    }

    private void applySafeChanges(TransactionController transactionController, int n, int n2) throws StandardException {
        transactionController.setProperty("derby.softDataDictionaryVersion", this, true);
    }

    private void doFullUpgrade(TransactionController transactionController, int n) throws StandardException {
        if (n < 120) {
            throw StandardException.newException("XCW00.D", DD_Version.majorToString(n), (Object)this);
        }
        if (n == 120) {
            this.bootingDictionary.create_10_1_system_procedures(transactionController, this.bootingDictionary.getSystemUtilSchemaDescriptor().getUUID());
        }
    }

    private void handleMinorRevisionChange(TransactionController transactionController, DD_Version dD_Version, boolean bl) throws StandardException {
        boolean bl2 = this.bootingDictionary.af.isReadOnly();
        if (!bl2) {
            this.bootingDictionary.clearSPSPlans();
            if (bl) {
                dD_Version.minorVersionNumber = 1;
                DD_Version dD_Version2 = dD_Version;
            } else {
                DD_Version dD_Version3 = this;
                dD_Version.majorVersionNumber = this.majorVersionNumber;
                dD_Version.minorVersionNumber = this.minorVersionNumber;
            }
            transactionController.setProperty("DataDictionaryVersion", dD_Version, true);
        } else {
            this.bootingDictionary.readOnlyUpgrade = true;
        }
        this.bootingDictionary.clearCaches();
    }

    protected void dropJDBCMetadataSPSes(TransactionController transactionController, boolean bl) throws StandardException {
        Iterator iterator = this.bootingDictionary.getAllSPSDescriptors().iterator();
        while (iterator.hasNext()) {
            SPSDescriptor sPSDescriptor = (SPSDescriptor)iterator.next();
            SchemaDescriptor schemaDescriptor = sPSDescriptor.getSchemaDescriptor();
            boolean bl2 = schemaDescriptor.getSchemaName().equals("SYSIBM");
            if (!schemaDescriptor.isSystemSchema() && !bl2 || (!bl || !bl2) && (bl || bl2)) continue;
            this.bootingDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
            this.bootingDictionary.dropDependentsStoredDependencies(sPSDescriptor.getUUID(), transactionController);
        }
    }

    protected void makeSystemCatalog(TransactionController transactionController, TabInfo tabInfo) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.bootingDictionary.getSystemSchemaDescriptor();
        this.bootingDictionary.makeCatalog(tabInfo, schemaDescriptor, transactionController);
    }

    protected void dropSystemCatalogDescription(TransactionController transactionController, TableDescriptor tableDescriptor) throws StandardException {
        this.bootingDictionary.dropAllColumnDescriptors(tableDescriptor.getUUID(), transactionController);
        this.bootingDictionary.dropAllConglomerateDescriptors(tableDescriptor, transactionController);
        this.bootingDictionary.dropTableDescriptor(tableDescriptor, tableDescriptor.getSchemaDescriptor(), transactionController);
        this.bootingDictionary.clearCaches();
    }

    protected void dropSystemCatalog(TransactionController transactionController, CatalogRowFactory catalogRowFactory) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.bootingDictionary.getSystemSchemaDescriptor();
        TableDescriptor tableDescriptor = this.bootingDictionary.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor);
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            transactionController.dropConglomerate(conglomerateDescriptorArray[i].getConglomerateNumber());
        }
        this.dropSystemCatalogDescription(transactionController, tableDescriptor);
    }

    protected void fillIndex(TransactionController transactionController, long l, TabInfo tabInfo, int n) throws StandardException {
        long l2 = tabInfo.getIndexConglomerate(n);
        IndexRowGenerator indexRowGenerator = tabInfo.getIndexRowGenerator(n);
        CatalogRowFactory catalogRowFactory = tabInfo.getCatalogRowFactory();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        ScanController scanController = transactionController.openScan(l, false, 0, 7, 4, null, null, 1, null, null, -1);
        RowLocation rowLocation = scanController.newRowLocationTemplate();
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 4, 7, 4);
        while (scanController.next()) {
            scanController.fetch(execRow.getRowArray());
            scanController.fetchLocation(rowLocation);
            indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
            conglomerateController.insert(execIndexRow.getRowArray());
        }
        conglomerateController.close();
        scanController.close();
    }

    public int getTypeFormatId() {
        return this.majorVersionNumber == 90 ? 402 : 401;
    }

    public final void readExternal(ObjectInput objectInput) throws IOException {
        this.majorVersionNumber = objectInput.readInt();
        this.minorVersionNumber = objectInput.readInt();
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.majorVersionNumber);
        objectOutput.writeInt(this.minorVersionNumber);
    }

    private int getJBMSMinorVersionNumber() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        return productVersionHolder.getMinorVersion() * 100 + productVersionHolder.getMaintVersion() + (productVersionHolder.isBeta() ? 0 : 1) + 2;
    }

    boolean checkVersion(int n, String string) throws StandardException {
        if (this.majorVersionNumber < n) {
            if (string != null) {
                throw StandardException.newException("XCL47.S", string, (Object)DD_Version.majorToString(this.majorVersionNumber), (Object)DD_Version.majorToString(n));
            }
            return false;
        }
        return true;
    }
}

