/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.net.DatagramPacket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.snmp.AbstractPollingInfo;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.PollingInfo;
import org.eclipse.aperi.snmp.PseudoPoller;
import org.eclipse.aperi.snmp.ShortcutInfo;
import org.eclipse.aperi.snmp.ShortcutPoller;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpPoller;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.SwadeohPoller;
import org.eclipse.aperi.snmp.TablePoller;
import org.eclipse.aperi.snmp.TablePollingInfo;
import org.eclipse.aperi.snmp.TableWalker;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.SingleInstanceFactory;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

class PollingDriver
implements Wakeable {
    protected boolean anyChanges;
    protected Vector tables;
    private Vector pollers;
    private Vector addThese;
    private Vector removeThese;
    private Hashtable mibvar;
    private Hashtable ravbim;
    private Hashtable responses;
    private SnmpSession session;
    private SnmpPDU[] getPDU;
    private DatagramPacket[] getPDUber;
    private boolean[][] lastRow;
    private boolean inProgress;
    private boolean stopping;
    private Timer timer;
    private int interval;
    private long nextWakeUpTime;
    private boolean viaTimerPop;
    private static final int VARBINDS_PER_PDU = 20;

    public PollingDriver(SnmpSession snmpSession, int sampleIntervalMsec) {
        this.session = snmpSession;
        this.interval = sampleIntervalMsec;
        this.inProgress = false;
        this.pollers = new Vector();
        this.addThese = new Vector();
        this.removeThese = new Vector();
        this.tables = new Vector();
        this.mibvar = new Hashtable();
        this.ravbim = new Hashtable();
        this.responses = new Hashtable();
        this.anyChanges = false;
        this.stopping = false;
        this.viaTimerPop = true;
    }

    public void notByTimerPop() {
        this.viaTimerPop = false;
    }

    public synchronized void add(AbstractSnmpPoller poller, Object userData) {
        AbstractPollingInfo info = null;
        if (poller instanceof ShortcutPoller) {
            info = new ShortcutInfo((ShortcutPoller)poller, userData, this.session);
        } else if (poller instanceof SnmpPoller) {
            info = new PollingInfo((SnmpPoller)poller, userData);
        } else if (poller instanceof TablePoller) {
            TablePoller tpoller = (TablePoller)poller;
            long[] tableInts = new long[tpoller.oids[0].value.length - 2];
            for (int i = 0; i < tableInts.length; ++i) {
                tableInts[i] = tpoller.oids[0].value[i];
            }
            OID tableOID = new OID(tableInts, true);
            TableWalker walker = null;
            for (int i = 0; walker == null && i < this.tables.size(); ++i) {
                TableWalker temp = (TableWalker)this.tables.elementAt(i);
                if (!temp.tableoid.equals(tableOID)) continue;
                boolean match = false;
                if (tpoller.index == null && temp.index == null) {
                    match = true;
                } else if (tpoller.index != null && temp.index != null && tpoller.index.length == temp.index.length) {
                    match = true;
                    for (int j = 0; match && j < tpoller.index.length; ++j) {
                        match = tpoller.index[j] == temp.index[j];
                    }
                }
                if (!match) continue;
                walker = temp;
            }
            if (walker == null) {
                walker = new TableWalker(tableOID, tpoller.oids[0], tpoller.index, this.interval, this, this.session);
                this.tables.addElement(walker);
            }
            info = new TablePollingInfo(tpoller, userData, walker);
            walker.addPoller((TablePollingInfo)info);
        } else {
            info = new AbstractPollingInfo(poller, userData);
        }
        if (this.inProgress) {
            this.addThese.addElement(info);
        } else {
            this.pollers.addElement(info);
            this.anyChanges = true;
        }
        if (!this.inProgress && this.pollers.size() == 1) {
            this.startSampling();
        }
    }

    public synchronized void remove(AbstractSnmpPoller poller) {
        AbstractPollingInfo info;
        boolean removed = false;
        Enumeration e = this.pollers.elements();
        while (!removed && e.hasMoreElements()) {
            info = (AbstractPollingInfo)e.nextElement();
            if (info.poller != poller) continue;
            removed = true;
            if (this.inProgress) {
                this.removeThese.addElement(info);
            } else {
                this.pollers.removeElement(info);
                this.anyChanges = true;
            }
            if (!(info instanceof TablePollingInfo)) continue;
            ((TablePollingInfo)info).removed = true;
            boolean found = false;
            for (int i = 0; !found && i < this.tables.size(); ++i) {
                TableWalker walker = (TableWalker)this.tables.elementAt(i);
                if (!walker.pollers.contains(info)) continue;
                walker.removePoller((TablePollingInfo)info);
            }
        }
        if (!removed) {
            e = this.addThese.elements();
            while (!removed && e.hasMoreElements()) {
                info = (AbstractPollingInfo)e.nextElement();
                if (info.poller != poller) continue;
                removed = true;
                this.addThese.removeElement(info);
                if (!(info instanceof TablePollingInfo)) continue;
                ((TablePollingInfo)info).removed = true;
            }
        }
        if (this.pollers.size() == 0) {
            this.stopSampling();
        }
    }

    public synchronized int count() {
        return this.pollers.size() + this.addThese.size() - this.removeThese.size();
    }

    protected synchronized void startSampling() {
        if (this.viaTimerPop) {
            long delay = this.interval;
            long now = System.currentTimeMillis();
            delay = (now + (long)this.interval - 1L) / (long)this.interval * (long)this.interval - now;
            delay = this.session.redshift < this.interval ? (delay += (long)this.session.redshift) : (delay += (long)((int)((double)this.interval * Math.random())));
            this.timer = TimerService.scheduleWakeUp((int)delay, this);
            this.nextWakeUpTime = delay + now;
        }
    }

    protected synchronized void stopSampling() {
        if (this.inProgress) {
            this.stopping = true;
        } else if (this.viaTimerPop) {
            TimerService.cancelWakeUp(this.timer);
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(Object userData) {
        int i;
        int i2;
        long pdusReceivedTimestamp;
        int limit;
        long scheduledStartTimestamp = this.nextWakeUpTime;
        this.nextWakeUpTime += (long)this.interval;
        long startTimestamp = System.currentTimeMillis();
        if (this.viaTimerPop) {
            Vector<AbstractPollingInfo> moves = new Vector<AbstractPollingInfo>();
            PollingDriver pollingDriver = this;
            synchronized (pollingDriver) {
                AbstractPollingInfo info;
                int i3;
                this.inProgress = true;
                limit = this.addThese.size();
                for (i3 = 0; i3 < limit; ++i3) {
                    info = (AbstractPollingInfo)this.addThese.elementAt(i3);
                    this.pollers.addElement(info);
                    this.anyChanges = true;
                }
                this.addThese.removeAllElements();
                limit = this.removeThese.size();
                for (i3 = 0; i3 < limit; ++i3) {
                    info = (AbstractPollingInfo)this.removeThese.elementAt(i3);
                    this.pollers.removeElement(info);
                    this.anyChanges = true;
                }
                this.removeThese.removeAllElements();
                i3 = 0;
                while (i3 < this.pollers.size()) {
                    info = (AbstractPollingInfo)this.pollers.elementAt(i3);
                    if (info.poller.interval.interval != this.interval) {
                        this.pollers.removeElementAt(i3);
                        moves.addElement(info);
                        this.anyChanges = true;
                        continue;
                    }
                    if (info instanceof TablePollingInfo) {
                        TablePollingInfo tInfo = (TablePollingInfo)info;
                        TableWalker tableWalker = tInfo.walker;
                        synchronized (tableWalker) {
                            tInfo.walker.polling = true;
                            if (tInfo.anyChanges) {
                                this.anyChanges = true;
                            }
                        }
                    }
                    ++i3;
                }
                if (this.pollers.size() == 0) {
                    this.timer = null;
                    this.inProgress = false;
                }
            }
            limit = moves.size();
            for (int i4 = 0; i4 < limit; ++i4) {
                AbstractPollingInfo info2 = (AbstractPollingInfo)moves.elementAt(i4);
                this.session.add(info2.poller, info2.cookie);
            }
            moves.removeAllElements();
        } else {
            this.inProgress = true;
        }
        if (!this.inProgress) {
            limit = this.pollers.size();
            for (int i5 = 0; i5 < limit; ++i5) {
                TablePollingInfo info;
                if (!(this.pollers.elementAt(i5) instanceof TablePollingInfo)) continue;
                TablePollingInfo info2 = info = (TablePollingInfo)this.pollers.elementAt(i5);
                synchronized (info2) {
                    info.walker.polling = false;
                    info.walker.notify();
                    continue;
                }
            }
            return;
        }
        if (this.anyChanges) {
            this.mibvar.clear();
            this.ravbim.clear();
            limit = this.pollers.size();
            for (int j = 0; j < limit; ++j) {
                int maxrows;
                AbstractSnmpPoller poller;
                AbstractPollingInfo abInfo = (AbstractPollingInfo)this.pollers.elementAt(j);
                if (abInfo instanceof PollingInfo) {
                    PollingInfo info = (PollingInfo)abInfo;
                    poller = (SnmpPoller)info.poller;
                    int limit2 = ((SnmpPoller)poller).oids.length;
                    for (int i6 = 0; i6 < limit2; ++i6) {
                        OID prev = SnmpMetaPDU.getPreviousOID(((SnmpPoller)poller).oids[i6]);
                        this.mibvar.put(((SnmpPoller)poller).oids[i6], prev);
                        this.ravbim.put(prev, ((SnmpPoller)poller).oids[i6]);
                    }
                    continue;
                }
                if (!(abInfo instanceof TablePollingInfo)) continue;
                TablePollingInfo info = (TablePollingInfo)abInfo;
                poller = (TablePoller)info.poller;
                int baseLen = ((TablePoller)poller).oids[0].value.length;
                int limit2 = info.walker.rows.size();
                if (limit2 > (maxrows = ((TablePoller)poller).getMaxRows())) {
                    limit2 = maxrows;
                }
                for (int i7 = 0; i7 < limit2; ++i7) {
                    OID oid;
                    OID prev;
                    OID rowOID = (OID)info.walker.rows.elementAt(i7);
                    int rowIndexLen = rowOID.value.length - baseLen;
                    long[] rowIndex = new long[rowIndexLen];
                    for (int k = 0; k < rowIndexLen; ++k) {
                        rowIndex[k] = rowOID.value[baseLen + k];
                    }
                    if (i7 >= 1) {
                        prev = (OID)info.walker.rows.elementAt(i7 - 1);
                        oid = (OID)info.walker.rows.elementAt(i7);
                        if (!this.mibvar.containsKey(oid)) {
                            this.mibvar.put(oid, prev);
                        }
                        if (!this.ravbim.containsKey(prev)) {
                            this.ravbim.put(prev, oid);
                        }
                    } else {
                        prev = ((TablePoller)poller).oids[0].concatenate(((TablePoller)poller).index);
                        oid = (OID)info.walker.rows.elementAt(0);
                        if (!this.mibvar.containsKey(oid)) {
                            this.mibvar.put(oid, prev);
                        }
                        if (!this.ravbim.containsKey(prev)) {
                            this.ravbim.put(prev, oid);
                        }
                    }
                    int limit3 = ((TablePoller)poller).oids.length;
                    for (int k = 0; k < limit3; ++k) {
                        OID oid2 = ((TablePoller)poller).oids[k].concatenate(rowIndex);
                        OID prev2 = SnmpMetaPDU.getPreviousOID(oid2);
                        if (!this.mibvar.containsKey(oid2)) {
                            this.mibvar.put(oid2, prev2);
                        }
                        if (this.ravbim.containsKey(prev2)) continue;
                        this.ravbim.put(prev2, oid2);
                    }
                }
                if (limit2 > 0 && maxrows == Integer.MAX_VALUE) {
                    int[] lastrow = new int[]{-1};
                    OID prev = (OID)info.walker.rows.elementAt(info.walker.rows.size() - 1);
                    OID oid = ((TablePoller)poller).oids[0].concatenate(((TablePoller)poller).index).concatenate(lastrow);
                    int columnPos = info.walker.tableoid.value.length + 1;
                    oid.value[columnPos] = prev.value[columnPos];
                    if (!this.mibvar.containsKey(oid)) {
                        this.mibvar.put(oid, prev);
                    }
                    if (!this.ravbim.containsKey(prev)) {
                        this.ravbim.put(prev, oid);
                    }
                }
                info.anyChanges = false;
            }
            int numPdus = 1 + (this.mibvar.size() - 1) / 20;
            this.getPDU = new SnmpPDU[numPdus];
            this.getPDUber = new DatagramPacket[numPdus];
            this.lastRow = new boolean[numPdus][20];
            int ix = 20;
            int num = -1;
            Enumeration e = this.mibvar.elements();
            while (e.hasMoreElements()) {
                OID oid = (OID)e.nextElement();
                if (ix == 20) {
                    this.getPDU[++num] = this.session.makePDU();
                    this.getPDU[num].operation = 1;
                    this.getPDU[num].correlator = num;
                    ix = 0;
                }
                this.getPDU[num].addVarBind(oid);
                OID test = (OID)this.ravbim.get(oid);
                if (test.value[test.value.length - 1] == -1L) {
                    this.lastRow[num][ix] = true;
                }
                ++ix;
            }
            if (this.session.canReplayMessages) {
                for (int i8 = 0; i8 < this.getPDU.length; ++i8) {
                    if (this.getPDU[i8] == null) continue;
                    this.getPDUber[i8] = this.session.socket.encodeThePDU(this.session, this.getPDU[i8], true);
                }
            }
        }
        long pdusBuiltTimestamp = System.currentTimeMillis();
        int numOIDs = this.mibvar.size();
        this.anyChanges = false;
        int numPending = 0;
        for (int i9 = 0; i9 < this.getPDU.length; ++i9) {
            if (this.getPDU[i9] == null) continue;
            ++numPending;
        }
        int numPDUs = numPending;
        int numDeviants = 0;
        this.responses.clear();
        Queue rspQ = new Queue(true);
        SnmpPDU rspPDU = null;
        if (this.session.canReplayMessages) {
            this.session.send(this.getPDU, this.getPDUber, rspQ);
        } else {
            this.session.send(this.getPDU, rspQ);
        }
        Vector<AbstractPollingInfo> tablePollers = new Vector<AbstractPollingInfo>();
        limit = this.pollers.size();
        for (int i10 = 0; i10 < limit; ++i10) {
            AbstractPollingInfo info = (AbstractPollingInfo)this.pollers.elementAt(i10);
            if (!(info instanceof TablePollingInfo)) continue;
            tablePollers.addElement(info);
        }
        Vector<OID> newRows = new Vector<OID>();
        while (numPending > 0) {
            rspPDU = (SnmpPDU)rspQ.dequeue();
            if (rspPDU.errorStatus == 0) {
                limit = rspPDU.varBindListSize();
                for (int i11 = 0; i11 < limit; ++i11) {
                    OID oid;
                    int num = rspPDU.correlator;
                    if (!this.lastRow[num][i11]) {
                        SnmpVarBind vb = rspPDU.varBindAt(i11);
                        oid = vb.get_oid();
                        this.responses.put(oid, vb.get_value());
                        continue;
                    }
                    OID getOID = this.getPDU[num].varBindAt(i11).get_oid();
                    oid = (OID)this.ravbim.get(getOID);
                    OID rspOID = rspPDU.varBindAt(i11).get_oid();
                    int limit2 = oid.value.length - 1;
                    if (rspOID.value.length < limit2) continue;
                    boolean matches = true;
                    for (int j = limit2 - 1; matches && j >= 0; --j) {
                        matches = rspOID.value[j] == oid.value[j];
                    }
                    if (!matches) continue;
                    newRows.addElement(rspOID);
                }
                --numPending;
                continue;
            }
            if (rspPDU.errorStatus == 100 || rspPDU.errorStatus == 102) {
                SnmpPDU orig = this.getPDU[rspPDU.correlator];
                Object timeout = SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.Timeout");
                limit = orig.varBindListSize();
                for (int i12 = 0; i12 < limit; ++i12) {
                    OID prev = orig.varBindAt(i12).get_oid();
                    OID oid = (OID)this.ravbim.get(prev);
                    this.responses.put(oid, timeout);
                }
                --numPending;
                if (rspPDU.errorStatus != 102 || this.session.switchedDestination) continue;
                this.stopSampling();
                System.out.println("SnmpSession: KILLING SAMPLING");
                continue;
            }
            if (this.stopping) {
                --numPending;
                continue;
            }
            this.anyChanges = true;
            SnmpPDU fixMe = this.getPDU[rspPDU.correlator];
            OID oid = fixMe.varBindAt(rspPDU.errorIndex - 1).get_oid();
            this.responses.put(oid, SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.NotSupported"));
            fixMe.errorStatus = rspPDU.errorStatus;
            fixMe.errorIndex = rspPDU.errorIndex;
            fixMe.fix();
            int num = rspPDU.correlator;
            int limit2 = 19;
            for (int i13 = rspPDU.errorIndex - 1; i13 < limit2; ++i13) {
                this.lastRow[num][i13] = this.lastRow[num][i13 + 1];
            }
            this.session.send(fixMe, rspQ);
        }
        this.session.switchedDestination = false;
        long timestamp = pdusReceivedTimestamp = System.currentTimeMillis();
        limit = tablePollers.size();
        for (int i1 = 0; i1 < limit; ++i1) {
            boolean rewalk = false;
            TablePollingInfo info = (TablePollingInfo)tablePollers.elementAt(i1);
            TablePoller poller = (TablePoller)info.poller;
            int limit2 = info.walker.rows.size();
            for (int i22 = 0; i22 < limit2; ++i22) {
                if (this.responses.get(info.walker.rows.elementAt(i22)) != null) continue;
                rewalk = true;
            }
            if (poller.changed) {
                rewalk = true;
                poller.changed = false;
            }
            if (!rewalk) {
                OID baseOID = poller.oids[0].concatenate(poller.index);
                for (int i23 = 0; !rewalk && i23 < newRows.size(); ++i23) {
                    OID newRow = (OID)newRows.elementAt(i23);
                    if (!newRow.startsWith(baseOID)) continue;
                    rewalk = true;
                    newRows.removeElementAt(i23);
                }
            }
            if (limit2 == 0) {
                rewalk = true;
            }
            if (!rewalk) continue;
            info.walker.rescan = true;
        }
        if (this.stopping) {
            if (this.viaTimerPop && this.session.pollDrivers != null) {
                this.session.pollDrivers.remove(new Integer(this.interval));
            }
            this.pollers.removeAllElements();
            return;
        }
        Object notSupported = SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.NotSupported");
        Vector<OID> tryWithGET = null;
        limit = this.pollers.size();
        for (int k = 0; k < limit; ++k) {
            AbstractSnmpPoller poller;
            AbstractPollingInfo info;
            AbstractPollingInfo abInfo = (AbstractPollingInfo)this.pollers.elementAt(k);
            if (abInfo instanceof PollingInfo) {
                info = (PollingInfo)abInfo;
                poller = (SnmpPoller)info.poller;
                int limit2 = poller.oids.length;
                for (int i14 = 0; i14 < limit2; ++i14) {
                    Object newval;
                    if (poller.keepOldValues) {
                        info.oldValues[i14] = info.newValues[i14];
                    }
                    if ((newval = this.responses.get(poller.oids[i14])) == null) {
                        newval = notSupported;
                        if (tryWithGET == null) {
                            tryWithGET = new Vector<OID>();
                        }
                        tryWithGET.addElement(poller.oids[i14]);
                    }
                    info.newValues[i14] = newval;
                }
                continue;
            }
            if (!(abInfo instanceof TablePollingInfo)) continue;
            info = (TablePollingInfo)abInfo;
            poller = (TablePoller)((TablePollingInfo)info).poller;
            int baseLen = ((TablePoller)poller).oids[0].value.length;
            int limit2 = ((TablePollingInfo)info).walker.rows.size();
            for (int i1 = 0; i1 < limit2; ++i1) {
                Serializable[] newval = (Serializable[])((TablePollingInfo)info).newValues.elementAt(i1);
                Serializable[] oldval = (Serializable[])((TablePollingInfo)info).oldValues.elementAt(i1);
                OID rowOID = (OID)((TablePollingInfo)info).walker.rows.elementAt(i1);
                int indexSize = rowOID.value.length - baseLen;
                long[] index = new long[indexSize];
                for (int i24 = 0; i24 < indexSize; ++i24) {
                    index[i24] = rowOID.value[baseLen + i24];
                }
                int limit3 = ((TablePoller)poller).oids.length;
                for (i2 = 0; i2 < limit3; ++i2) {
                    if (((TablePoller)poller).keepOldValues) {
                        oldval[i2] = newval[i2];
                    }
                    OID oid = ((TablePoller)poller).oids[i2].concatenate(index);
                    newval[i2] = (Serializable)this.responses.get(oid);
                    if (newval[i2] != null) continue;
                    newval[i2] = (Serializable)notSupported;
                    if (tryWithGET == null) {
                        tryWithGET = new Vector();
                    }
                    tryWithGET.addElement(oid);
                }
            }
        }
        long dataExtractedTimestamp = System.currentTimeMillis();
        if (tryWithGET != null) {
            int i15;
            numDeviants = tryWithGET.size();
            this.responses.clear();
            numPending = tryWithGET.size();
            for (i15 = 0; i15 < numPending; ++i15) {
                SnmpPDU pdu = this.session.makePDU();
                pdu.operation = 0;
                pdu.addVarBind((OID)tryWithGET.elementAt(i15));
                this.session.send(pdu, rspQ);
            }
            for (i15 = 0; i15 < numPending; ++i15) {
                rspPDU = (SnmpPDU)rspQ.dequeue();
                if (rspPDU.errorStatus != 0) continue;
                SnmpVarBind vb = rspPDU.varBindAt(0);
                this.responses.put(vb.get_oid(), vb.get_value());
            }
            timestamp = System.currentTimeMillis();
            limit = this.pollers.size();
            for (int k = 0; k < limit; ++k) {
                AbstractSnmpPoller poller;
                AbstractPollingInfo info;
                AbstractPollingInfo abInfo = (AbstractPollingInfo)this.pollers.elementAt(k);
                if (abInfo instanceof PollingInfo) {
                    info = (PollingInfo)abInfo;
                    poller = (SnmpPoller)info.poller;
                    int limit2 = poller.oids.length;
                    for (int i16 = 0; i16 < limit2; ++i16) {
                        Object newval;
                        if (info.newValues[i16] != notSupported || (newval = this.responses.get(poller.oids[i16])) == null) continue;
                        info.newValues[i16] = newval;
                    }
                    continue;
                }
                if (!(abInfo instanceof TablePollingInfo)) continue;
                info = (TablePollingInfo)abInfo;
                poller = (TablePoller)((TablePollingInfo)info).poller;
                int baseLen = ((TablePoller)poller).oids[0].value.length;
                int limit2 = ((TablePollingInfo)info).walker.rows.size();
                for (int i1 = 0; i1 < limit2; ++i1) {
                    Serializable[] newval = (Serializable[])((TablePollingInfo)info).newValues.elementAt(i1);
                    OID rowOID = (OID)((TablePollingInfo)info).walker.rows.elementAt(i1);
                    int indexSize = rowOID.value.length - baseLen;
                    long[] index = new long[indexSize];
                    for (i2 = 0; i2 < indexSize; ++i2) {
                        index[i2] = rowOID.value[baseLen + i2];
                    }
                    int limit3 = ((TablePoller)poller).oids.length;
                    for (int i25 = 0; i25 < limit3; ++i25) {
                        OID oid;
                        Object newVal;
                        if (newval[i25] != notSupported || (newVal = this.responses.get(oid = ((TablePoller)poller).oids[i25].concatenate(index))) == null) continue;
                        newval[i25] = (Serializable)newVal;
                    }
                }
            }
        }
        long secondRoundTimestamp = System.currentTimeMillis();
        if (this.stopping) {
            if (this.viaTimerPop && this.session.pollDrivers != null) {
                this.session.pollDrivers.remove(new Integer(this.interval));
            }
            this.pollers.removeAllElements();
            if (this.viaTimerPop) {
                SnmpSession info = this.session;
                synchronized (info) {
                    if (this.session.pollDrivers != null && this.session.pollDrivers.size() == 0) {
                        this.session.pollDrivers = null;
                    }
                }
            }
            return;
        }
        Vector<AbstractPollingInfo> pseudoPollers = new Vector<AbstractPollingInfo>();
        limit = this.pollers.size();
        for (int i17 = 0; i17 < limit; ++i17) {
            AbstractPollingInfo abInfo = (AbstractPollingInfo)this.pollers.elementAt(i17);
            if (this.removeThese.contains(abInfo)) continue;
            if (abInfo instanceof PollingInfo) {
                PollingInfo info = (PollingInfo)abInfo;
                SnmpPoller poller = (SnmpPoller)info.poller;
                try {
                    if (poller.prefilter != null) {
                        poller.prefilter.preHandle(info.cookie, info.newValues, info.oldValues, timestamp);
                    }
                    boolean pass = true;
                    if (poller.filter != null) {
                        pass = poller.filter.evaluate(info.cookie, info.newValues, info.oldValues, timestamp);
                    }
                    if (pass && poller.action != null) {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("SnmpSession calling handle (" + info.cookie + ")");
                        }
                        poller.action.handle(info.cookie, info.newValues, info.oldValues, timestamp);
                        continue;
                    }
                    if (!SnmpV1API.isTracing()) continue;
                    SnmpV1API.trace("SnmpSession filter=false not calling handle (" + info.cookie + ")");
                }
                catch (Exception excep) {
                    System.err.println("Recovered from the following exception:");
                    excep.printStackTrace();
                }
                continue;
            }
            if (abInfo instanceof TablePollingInfo) {
                TablePollingInfo info = (TablePollingInfo)abInfo;
                TablePoller poller = (TablePoller)info.poller;
                try {
                    if (poller.prefilter != null) {
                        poller.prefilter.preHandle(info.cookie, info.rowCookie, info.newValues, info.oldValues, timestamp);
                    }
                    boolean pass = true;
                    if (poller.filter != null) {
                        pass = poller.filter.evaluate(info.cookie, info.rowCookie, info.newValues, info.oldValues, timestamp);
                    }
                    if (pass && poller.action != null) {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("SnmpSession calling table handle (" + info.cookie + ")");
                        }
                        poller.action.handle(info.cookie, info.rowCookie, info.newValues, info.oldValues, timestamp);
                    } else if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("SnmpSession filter=false not calling table handle (" + info.cookie + ")");
                    }
                }
                catch (Exception excep) {
                    System.err.println("Recovered from the following exception:");
                    excep.printStackTrace();
                }
                TableWalker excep = info.walker;
                synchronized (excep) {
                    info.walker.polling = false;
                    info.walker.notify();
                    continue;
                }
            }
            pseudoPollers.addElement(abInfo);
        }
        long pollersDoneTimestamp = System.currentTimeMillis();
        Vector<AbstractPollingInfo> swadeohs = new Vector<AbstractPollingInfo>();
        limit = pseudoPollers.size();
        for (int i18 = 0; i18 < limit; ++i18) {
            AbstractPollingInfo info = (AbstractPollingInfo)pseudoPollers.elementAt(i18);
            PseudoPoller poller = (PseudoPoller)info.poller;
            if (poller instanceof SwadeohPoller) {
                swadeohs.addElement(info);
                continue;
            }
            poller.action.intervalCompleted(info.cookie, timestamp);
        }
        long pseudosDoneTimestamp = System.currentTimeMillis();
        limit = swadeohs.size();
        for (i = 0; i < limit; ++i) {
            AbstractPollingInfo info = (AbstractPollingInfo)swadeohs.elementAt(i);
            SwadeohPoller swadeoh = (SwadeohPoller)info.poller;
            swadeoh.scheduledStartTime = scheduledStartTimestamp;
            swadeoh.actualStartTime = startTimestamp;
            swadeoh.pdusBuiltTime = pdusBuiltTimestamp;
            swadeoh.pdusReceivedTime = pdusReceivedTimestamp;
            swadeoh.dataExtractedTime = dataExtractedTimestamp;
            swadeoh.secondRoundTime = secondRoundTimestamp;
            swadeoh.pollersDoneTime = pollersDoneTimestamp;
            swadeoh.pseudosDoneTime = pseudosDoneTimestamp;
            swadeoh.numOIDs = numOIDs;
            swadeoh.numPDUs = numPDUs;
            swadeoh.numDeviants = numDeviants;
            swadeoh.action.intervalCompleted(info.cookie, pseudosDoneTimestamp);
        }
        limit = this.tables.size();
        for (i = 0; i < limit; ++i) {
            TableWalker walker = (TableWalker)this.tables.elementAt(i);
            if (!walker.rescan) continue;
            walker.rescan = false;
            walker.walkTheTable();
        }
        if (this.viaTimerPop) {
            int waitTime = (int)(this.nextWakeUpTime - System.currentTimeMillis());
            if (waitTime < 0) {
                for (waitTime = -waitTime; waitTime > this.interval; waitTime -= this.interval) {
                    this.nextWakeUpTime += (long)this.interval;
                }
                waitTime = 0;
            }
            this.timer = TimerService.scheduleWakeUp(waitTime, this);
        }
    }
}

