/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import org.eclipse.aperi.snmp.MyAction;
import org.eclipse.aperi.snmp.PollingInterval;
import org.eclipse.aperi.snmp.SnmpPoller;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SomeChanged;

public class Pollsnmp {
    public static void main(String[] args) {
        SnmpSession session;
        if (args.length != 1) {
            System.err.println("Usage: java Pollsnmp <hostname>");
            return;
        }
        try {
            SnmpV1API.initialize();
            session = SnmpSession.open(args[0]);
        }
        catch (Exception e) {
            System.out.println("Exception caught: " + e.toString());
            return;
        }
        String[] myOids = new String[]{"1.3.6.1.2.1.1.3.0"};
        String[] hisOids = new String[]{"1.3.6.1.2.1.2.2.1.10.1"};
        SomeChanged filter = new SomeChanged();
        MyAction myAction = new MyAction();
        PollingInterval interval = new PollingInterval(1000);
        SnmpPoller poller = new SnmpPoller(interval, myOids, true, myAction, null, null);
        PollingInterval int2 = new PollingInterval(4000);
        SnmpPoller p2 = new SnmpPoller(int2, hisOids, true, myAction, null, null);
        session.add(poller, (Object)"poller number 1");
        session.add(p2, (Object)"poller number 2");
        try {
            Thread.currentThread();
            Thread.sleep(12000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("\n\nStopping pollers");
        session.remove(poller);
        session.remove(p2);
        session.close();
        SnmpV1API.terminate();
        System.out.println("Done");
    }
}

