/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.FullCounter64;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.Null;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.SpecialValue;
import org.eclipse.aperi.snmp.data.TimeTicks;
import org.eclipse.aperi.snmp.utils.InstrumentationMapper;

public abstract class SnmpMetaPDU
implements Serializable {
    public int version;
    public OctetString communityString;
    public Vector varBindList;
    public IPAddress senderAddr = null;
    public int senderPort = -1;
    protected static Null nullInstance = new Null();
    public static final int INTEGER_TYPE = -1;
    public static final int COUNTER_TYPE = -2;
    public static final int COUNTER64_TYPE = -3;
    public static final int GAUGE_TYPE = -4;
    public static final int TIMETICKS_TYPE = -5;
    public static final int IPADDRESS_TYPE = -6;
    public static final int OID_TYPE = -7;
    public static final int OCTET_TYPE = -8;
    public static final int IMPLEN_OCTET_TYPE = -9;

    protected SnmpMetaPDU() {
        this.version = 0;
        this.communityString = null;
        this.varBindList = new Vector();
    }

    protected SnmpMetaPDU(int version, String communityString, Vector vars) {
        this.version = version;
        this.communityString = new OctetString(communityString, true);
        this.varBindList = vars;
    }

    protected SnmpMetaPDU(Vector vars) {
        this.version = 0;
        this.communityString = null;
        this.varBindList = vars;
    }

    protected SnmpMetaPDU(SnmpMetaPDU pdu) {
        this.version = pdu.version;
        if (pdu.communityString != null) {
            this.communityString = new OctetString(pdu.communityString);
        }
        this.varBindList = new Vector();
        for (int i = 0; i < pdu.varBindListSize(); ++i) {
            SnmpVarBind b = new SnmpVarBind(pdu.varBindAt(i));
            this.varBindList.addElement(b);
        }
    }

    public boolean equals(SnmpMetaPDU p) {
        boolean returnVal = true;
        if (this.version != p.version) {
            return false;
        }
        if (!this.communityString.equals(p.communityString)) {
            return false;
        }
        if (this.varBindList.size() != p.varBindListSize()) {
            return false;
        }
        for (int i = 0; i < this.varBindList.size() && returnVal; ++i) {
            returnVal = ((SnmpVarBind)this.varBindList.elementAt(i)).equals(p.varBindAt(i));
        }
        return returnVal;
    }

    public String varBindListToString() {
        StringBuffer buffer = new StringBuffer("(");
        if (!this.varBindList.isEmpty()) {
            for (int i = 0; i < this.varBindList.size(); ++i) {
                if (i == 0) {
                    buffer.append(this.varBindList.elementAt(i).toString());
                    continue;
                }
                buffer.append(", " + this.varBindList.elementAt(i).toString());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void trim() {
        this.varBindList.removeElementAt(this.varBindList.size() - 1);
    }

    public void delete_vb(int position) throws ArrayIndexOutOfBoundsException {
        this.varBindList.removeElementAt(position);
    }

    public Vector get_vblist() {
        return this.varBindList;
    }

    public void set_vblist(Vector varBindList) {
        this.varBindList = varBindList;
    }

    public SnmpVarBind get_vb(int position) throws ArrayIndexOutOfBoundsException {
        return (SnmpVarBind)this.varBindList.elementAt(position);
    }

    public void get_vb(SnmpVarBind varBind, int position) throws ArrayIndexOutOfBoundsException {
        this.varBindList.insertElementAt(varBind, position);
    }

    public int get_vb_count() {
        return this.varBindList.size();
    }

    public void deleteVarBindList() {
        this.varBindList = new Vector();
    }

    public SnmpVarBind firstVarBind() {
        return (SnmpVarBind)this.varBindList.firstElement();
    }

    public int varBindListSize() {
        return this.varBindList.size();
    }

    public SnmpVarBind varBindAt(int i) {
        if (this.varBindList.size() > i) {
            return (SnmpVarBind)this.varBindList.elementAt(i);
        }
        return null;
    }

    public Vector varBindList() {
        return this.varBindList;
    }

    public void addVarBind(SnmpVarBind var) {
        this.varBindList.addElement(var);
    }

    public int addVarBindReturnIndex(SnmpVarBind var) {
        this.varBindList.addElement(var);
        return this.varBindList.size();
    }

    public void insertVarBindAt(SnmpVarBind var, int location) {
        this.varBindList.insertElementAt(var, location);
    }

    public void insertVarBindAt(String oidStr, Serializable value, int location) {
        OID oid = new OID(oidStr);
        SnmpVarBind b = new SnmpVarBind(oid, value);
        this.varBindList.insertElementAt(b, location);
    }

    public void addVarBind(String oidStr, Serializable value) {
        OID oid = new OID(oidStr);
        this.addVarBind(oid, value);
    }

    public void addVarBind(OID oid, Serializable value) {
        SnmpVarBind b = new SnmpVarBind(oid, value);
        this.varBindList.addElement(b);
    }

    public void addVarBind(String oidStr) {
        OID oid = new OID(oidStr);
        this.addVarBind(oid);
    }

    public void addVarBind(OID oid) {
        SnmpVarBind b = new SnmpVarBind(oid);
        this.varBindList.addElement(b);
    }

    public void removeVarBindAt(int i) {
        this.varBindList.removeElementAt(i);
    }

    public void removeVarBind(Object o) {
        this.varBindList.removeElement(o);
    }

    public void setVarBindList(Vector varBinds) {
        this.varBindList = varBinds;
    }

    public static int[] getIndex(Serializable[] index, int[] indexTypes) {
        return SnmpMetaPDU.getIndex(index, indexTypes, null, null);
    }

    public static int[] getIndex(Serializable[] ind, int[] indexTypes, int[] varsPerIndex, Object[] mapper) {
        int limit;
        int i;
        Serializable[] index;
        Vector<Serializable> indexOID = new Vector<Serializable>();
        Serializable[] indexData = new Serializable[]{null, null, null, null, null, null, null, null};
        int rawIx = 0;
        if (ind.length < indexTypes.length) {
            index = new Serializable[indexTypes.length];
            for (i = 0; i < indexTypes.length; ++i) {
                index[i] = i < ind.length ? ind[i] : null;
            }
        } else {
            index = ind;
        }
        if (varsPerIndex != null) {
            for (i = 0; i < indexTypes.length; ++i) {
                if (mapper[i] == null) {
                    indexData[rawIx++] = index[i];
                    continue;
                }
                if (index[i] != null) {
                    Serializable[] tmp = ((InstrumentationMapper)mapper[i]).toInstr(index[i]);
                    for (int j = 0; j < tmp.length; ++j) {
                        indexData[rawIx++] = tmp[j];
                    }
                    continue;
                }
                for (int j = 0; j < varsPerIndex[i]; ++j) {
                    indexData[rawIx++] = null;
                }
            }
        } else {
            for (i = 0; i < indexTypes.length; ++i) {
                indexData[i] = index[i];
            }
        }
        boolean nullIndexFound = false;
        for (int i2 = 0; i2 < indexTypes.length; ++i2) {
            if (indexData[i2] == null || indexData[i2] instanceof Null) {
                nullIndexFound = true;
                continue;
            }
            if (nullIndexFound) {
                RuntimeException e = new RuntimeException("SnmpMetaPDU: getIndex received a null index that preceeded non-null indexes");
                throw e;
            }
            if (indexData[i2] instanceof Integer) {
                indexOID.addElement(indexData[i2]);
                continue;
            }
            if (indexData[i2] instanceof OctetString || indexData[i2] instanceof String) {
                if (indexData[i2] instanceof String) {
                    indexData[i2] = new OctetString((String)((Object)indexData[i2]), true);
                }
                if (indexTypes[i2] == -8) {
                    indexOID.addElement(new Integer(((OctetString)indexData[i2]).value.length));
                }
                for (int j = 0; j < ((OctetString)indexData[i2]).value.length; ++j) {
                    int val = 0xFF & ((OctetString)indexData[i2]).value[j];
                    indexOID.addElement(new Integer(val));
                }
                continue;
            }
            if (indexData[i2] instanceof IPAddress) {
                byte[] ipaddr = ((IPAddress)indexData[i2]).getBytes();
                indexOID.addElement(new Integer(0xFF & ipaddr[0]));
                indexOID.addElement(new Integer(0xFF & ipaddr[1]));
                indexOID.addElement(new Integer(0xFF & ipaddr[2]));
                indexOID.addElement(new Integer(0xFF & ipaddr[3]));
                continue;
            }
            if (indexData[i2] instanceof OID) {
                long[] value = ((OID)indexData[i2]).value;
                indexOID.addElement(new Long(value.length));
                for (int j = 0; j < value.length; ++j) {
                    indexOID.addElement(new Long(value[j]));
                }
                continue;
            }
            if (indexData[i2] instanceof Counter) {
                indexOID.addElement(new Integer((int)((Counter)indexData[i2]).value));
                continue;
            }
            if (indexData[i2] instanceof Counter64) {
                indexOID.addElement(new Integer((int)((Counter64)indexData[i2]).value));
                continue;
            }
            if (indexData[i2] instanceof Gauge) {
                indexOID.addElement(new Integer((int)((Gauge)indexData[i2]).value));
                continue;
            }
            if (indexData[i2] instanceof TimeTicks) {
                indexOID.addElement(new Integer((int)((TimeTicks)indexData[i2]).value));
                continue;
            }
            if (indexData[i2] instanceof FullCounter64) {
                indexOID.addElement(new Integer(((FullCounter64)indexData[i2]).value.intValue()));
                continue;
            }
            if (indexData[i2] instanceof SpecialValue) {
                indexOID.removeAllElements();
                break;
            }
            System.out.println("SnmpMetaPDU: getIndex received bad type " + indexData[i2].getClass());
            indexOID.removeAllElements();
            break;
        }
        if ((limit = indexOID.size()) == 0) {
            return null;
        }
        int[] retval = new int[limit];
        for (int i3 = 0; i3 < limit; ++i3) {
            retval[i3] = (Integer)indexOID.elementAt(i3);
        }
        return retval;
    }

    public static OID getPreviousOID(OID oid) {
        OID prevOID = null;
        int last = oid.value.length - 1;
        if (oid.value[last] < 1L) {
            --last;
            while (oid.value[last] == 0L) {
                --last;
            }
            long[] newVals = new long[last + 1];
            for (int i = last; i >= 0; --i) {
                newVals[i] = oid.value[i];
                prevOID = new OID(newVals, true);
            }
        } else {
            prevOID = new OID(oid);
            prevOID.value[last] = oid.value[last] - 1L;
        }
        return prevOID;
    }
}

